/* Copyright (c) 1988,1989 by Sozobon, Limited.  Author: Tony Andrews
 *           (c) 1990 - 2009 by H. Robbers.   ANSI upgrade.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Jan 1991: Modified by Han Driesen, Stichting ST, The Netherlands
 * Optimizer integrated in the compiler.
 */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <tos.h>
#include "param.h"

#include "out.h"
#include "opt.h"
#include "reg.h"
#include "peep.h"
#include "inst.h"

char *str_alloc(char *s);
string pascode(short tok);

global
bool change_reg(IP ip, short to, short fro, short which)
{
	OPND *arg = ip->arg,
	     *dst = nil;

	short am;

	bool changed = false;

	if (ip->reg eq fro)
		changed |= true,
		ip->reg = to;

	if (arg)
	{
		dst = arg->next;
		am = arg->amode&~(INC|DEC|XLONG);

		if (am > NONE and am <= REGIDX and arg->areg eq fro)
			changed |= true,
			arg->areg = to;

		if ( (am eq PCDX or am eq REGIDX) and arg->ireg eq fro)
			changed |= true,
			arg->ireg = to;
	}

	if (dst)
	{
		am = dst->amode&~(INC|DEC|XLONG);

		if (am > NONE and am <= REGIDX and dst->areg eq fro)
			changed |= true,
			dst->areg = to;

		if ( (am eq PCDX or am eq REGIDX) and dst->ireg eq fro)
			changed |= true,
			dst->ireg = to;
	}

	if (changed)
	{
#if 0
		console("[%d]changed %ld: %s", which, ip->inr, preg(fro));
		console(" to %s\n", preg(to));
#endif
		uprefs(ip);
		PDBG(ip, p1_reg);
	}
	return changed;
}

short plink = 0, punlink = 0;

bool change_all_reg(BP bp, short to, short fro, short which)
{
	bool changed = false;

	while (bp)
	{
		IP ip = bp->first;
		while (ip)
		{
			if ( ((ip->rref|ip->rset)&RM(fro)) ne 0)
				 changed |= change_reg(ip, to, fro, which);
			ip = ip->next;
		}
		bp = bp->next;
	}

	return changed;
}

static
bool used_reg(IP ip, RMASK regs)
{
	return ((ip->rref|ip->rset) & regs) ne 0;
}

bool reg_used(BP bp, IP ip, RMASK regs)
{
	/* first check following ip */
	ip = ip->next;
	while (ip)
	{
		if (used_reg(ip, regs))
			return true;
		ip = ip->next;
	}
	/* then check following bp */
	bp = bp->next;
	while (bp)
	{
		if ((bp->rref | bp->rset) &regs)
			return true;
		bp = bp->next;
	}

	return false;
}

static
bool changed_reg(IP ip, short reg1, short reg2)
{
	RMASK regs = RM(reg1)|RM(reg2);

	if ((regs & ip->rset) eq 0)
		return false;

	if (    (ip->opcode eq LDX)
	    and ip->arg
		and ip->arg->amode eq REG
	    and (ip->rref|ip->rset) eq regs
	   )
		return false;		/* not really changed :-) */

	return true;
}

bool reg_changed(BP bp, IP ip, short reg1, short reg2)
{
	/* first check following ip in this block*/
	ip = ip->next;
	while (ip)
	{
		if (changed_reg(ip, reg1, reg2))
			return true;
		ip = ip->next;
	}
	/* then check following blocks */
	bp = bp->next;
	while (bp)
	{
		ip = bp->first;
		while (ip)
		{
			if (changed_reg(ip, reg1, reg2))
				return true;
			ip = ip->next;
		}
		bp = bp->next;
	}
	return false;
}

bool regdown(BP bp, RMASK wrk, RMASK var, int which)
{
	short to = 0, fro = 0;

	while ( (var & (RM(fro))) eq 0 ) fro++;	/* find a used var */
	while ( (wrk & (RM(to ))) ne 0 ) to ++; /* find a unused work */

	return change_all_reg(bp, to, fro, which);
}

/* returns true if CC is not involved in the next instruction (or block) */
bool not_cc(IP ip, BP bp)
{
	if (ISA(ip->reg))		/* setting address reg doesnt change cc */
		return true;
	if (ip->next)
		return (idata[ip->next->opcode].iflag&CCU) eq 0;
	else
		return bp->cond eq nil;		/* last instruction and no conditional block */
}

bool is_number(const OPND *op)
{
	if (op)						/* 12'09 HR: stupid Milan!!! */
	if ((op->amode & 0xff) eq ABS)
	{
		char *s = op->astr;
		if (s eq nil) return true;		/* 12'09 HR: then already in op->disp */
		if (isdigit(s[0]))
			return true;
		if (s[0] eq '-' and isdigit(s[1]))
			return true;
	}
	return false;
}

bool any_number(IP ip)
{
	if (ip->arg)
	{
		if (is_number(ip->arg))
			return true;
		if (ip->arg->next)
			if (is_number(ip->arg->next))
				return true;
	}
	return false;
}

static
bool cf(OPND *s, OPND *d)
{
	short sm = MM(s->amode), dm = MM(d->amode);

	if (sm <  REGID)					return true;
	if (sm eq REGID  and dm < REGIDX)	return true;
	if (sm eq PCD    and dm < REGIDX)	return true;
	if (sm eq REGIDX and dm < REGID)	return true;
	switch (sm)
	{
		case ABS:
		case IMM:
		case PCDX:
			if (dm < REGID)				return true;
	}

/*	console("no cf %d,%d\n", sm, dm); */

	return false;
}

static
short free_work(IP ip, short reg)
{
	short i;
	if (reg > A0)
	{
		for (i = A0; i <= ARV_START; i++)
			if ((ip->live&RM(i)) eq 0)
				if ((ip->rref&RM(i)) eq 0)
					return i;
		return -1;
	}
#if FLOAT
	if (reg > F0)
	{
		for (i = F0; i <= FRV_START; i++)
			if ((ip->live&RM(i)) eq 0)
				if ((ip->rref&RM(i)) eq 0)
					return i;
		return -1;
	}
#endif
	for (i = D0; i <= DRV_START; i++)
		if ((ip->live&RM(i)) eq 0)
			if ((ip->rref&RM(i)) eq 0)
				return i;
	return -1;
}

bool split(BP bp, IP ip)
{
	IP new;
	short r = free_work(ip, D0);
	if (r < 0)
	{
		console("no free reg\n");
		return false;
	}

	new = instbefore(bp, ip, false);
	new->arg = ip->arg;
	ip-> arg = ip->arg->next;
	new->reg = r;
	ip-> reg = r;	
	new->opcode = LDX;
	ip-> opcode = STO;
	new->iflg.i = ip->iflg.i;
	new->sz   = ip->sz;
	uprefs(new);
	uprefs(ip);
	return true;
}

/*
 * ipeep1(ip) - check for changes to the instruction 'ip'
 */

static	short
ipeep1(BP bp, IP ip)
{
	IDATA *id;
	short p0, reg, am1, op1, areg;

	p0 = ipeep0(bp, ip);			/* context free transformations */
	if (p0)
		return p0;

	if (ip->arg)
		am1  = ip->arg->amode,
		areg = ip->arg->areg;
	else
		am1  = NONE,
		areg = -1;

	op1 = ip->opcode;
	id = &idata[op1];
	reg = ip->reg;

	/* voor testen met eem test assemblerfiletje of kleine C filetjes
	is dit niet erg handig, dit maakt nogal wat test instructies weg
	        voor we aan andere optmizations toe zijn   */

	/*	The compiler does not generate constructs that leave parts of
	 *	registers alive
	 *
	 *	op.x    Rn   X
	 *
	 *	Delete if Rn is set and Rn is dead.
	 *  inst not followed by Bcc. and no side effects
	 *  and no INC|DEC in the argument
	 *  unless the inst itself uses reg
	 */

	if (    (id->regf  & SET ) ne 0
		and (id->iflag & SIDE) eq 0
	    and (am1 & (INC|DEC)) eq 0
		and not_cc(ip, bp)
	   )
		if ((ip->live & RM(reg)) eq 0)
			if (!any_number(ip))		/* 04'09 HR IO memory */
			{
#if OPTBUG
				IP np, pp = ip->prior;
	
				np = delinst(bp, ip);
			    if (np)
					PDBG(np, p1_0)
				elif (pp)
					PDBG(pp, p1_0)
				else
					peepcnt.p1_0++;
#else
				delinst(bp, ip);
#endif
			    return 1;
		    }

	if (    (op1 eq LKX or op1 eq ULX)
	    and (anywhere_used & RM(FRAMEP)) eq 0
	   )
	{
		s_lnk++;
		delinst(bp, ip);
		return 1;
	}

	if (ip->arg eq nil)
		return 0;

	/* if LDX is turned into load same reg
	 * delete if not followed by Bcc.
	 */
	if (    op1 eq LDX
	    and am1 eq REG
	    and reg eq areg
	    and not_cc(ip, bp)
	   )
	{
	#if OPTBUG
		IP np, pp = ip->prior;

		np = delinst(bp, ip);
	    if (np)
			PDBG(np, p1_3)
		elif (pp)
			PDBG(pp, p1_3)
		else
			peepcnt.p1_3++;
	#else
		delinst(bp, ip);
	#endif
		return 1;
	}

	if (	op1 eq SVA
		and am1 eq REG
		)
	{
		if (  (ip->live&RM(areg)) eq 0		/* the register var itself is dead */
		    or reg eq areg					/* or the register var has been downed */
		   )
		{
			if (not_cc(ip, bp))
			{
	#if OPTBUG
				IP np, pp = ip->prior;

				np = delinst(bp, ip);
			    if (np)
					PDBG(np, p1_2)
				elif (pp)
					PDBG(pp, p1_2)
				else
					peepcnt.p1_2++;
	#else
				delinst(bp, ip);
	#endif
			othw				/* change sva to tsx */
				if (!ISA(reg))
				{
					ip->opcode = TSX;
					ip->arg = nil;
					uprefs(ip);
					PDBG(ip, p1_4)
				}
			}
		    return 1;
		}
	}

#if 1
	/* field shift not followed by comparison but with Z cc check can be removed.
	   NB: This instruction is ALWAYS precede by a AND.
	*/
	if (op1 eq FLX)
	{
		if (    ip->next eq nil
		    and (ip->live & RM(reg)) eq 0
		    and bp->cond
		    and (bp->opcode eq BEQ or bp->opcode eq BNE)
		   )
		{
#if OPTBUG
			IP np, pp = ip->prior;

			np = delinst(bp, ip);
		    if (np)
				PDBG(np, p1_5)
			elif (pp)
				PDBG(pp, p1_5)
			else
				peepcnt.p1_5++;
#else
			delinst(bp, ip);
#endif
			return 1;
		}
	}
#endif

#if COLDFIRE
	if (G.Coldfire)
	{
		if (op1 eq MOV)
		{
			OPND *arg = ip->arg,
			     *dst = ip->arg->next;
			if (!cf(arg, dst))
			{
				bool can_3q(long val);
				if (!(    !G.i2_68020
				      and ip->arg->amode eq IMM
			          and can_3q(ip->arg->disp) ) )
					if (split(bp, ip))
					{
						PDBG(ip, p1_split);
						return 1;
					}
			}
		}
	}
#endif

	if (op1 eq REGL)
	{

		RMASK m = loclist & anywhere_used;

		if (loclist ne m)
		{
			loclist = m;	/* !! The no regs dumped is reduced !! */
#if REGLIST
			ip->arg->astr = str_alloc(mask_to_s(loclist, true));
			ip->arg->amode = RLST;
#else
			ip->arg->disp  = loclist;
			ip->arg->amode = IMM;
#endif
			PDBG(ip, p1_1)
			uprefs(ip);
			return 1;
		}

#if 1
		{
			RMASK u = anywhere_used;
			if ((m&DM) ne 0 and (u&WDM) ne WDM)
			{
				if (regdown(bp, (u&WDM)
									  |MSKD, /* mark not applicable works as used */
								m&DM, 5))
					return 2;
			}
			elif ((m&AM) ne 0 and (u&WAM) ne WAM)
			{
				if (regdown(bp, (u&WAM)|MSKA, m&AM, 6))
					return 2;
			}
#if FLOAT
			elif ((m&FM) ne 0 and (u&WFM) ne WFM)
			{
				if (regdown(bp, (u&WFM)|MSKF, m&FM, 7))
					return 2;
			}
#endif
		}
#endif
	}

	return 0;
}

/*
 * peep1(bp) - peephole optimizations with a window size of 1
 */

static bool
peep1(BP bp)
{
	BP rp = bp;
	IP ip, next_ip;
	bool  changed = false;
	short regdown = 0;

	while (bp)
	{
		ip = bp->first;
		while (ip)
		{
			next_ip = ip->next;

			if (ip->opcode eq REGL)
				loclist = get_locs(ip);

			regdown = ipeep1(bp, ip);

			if (regdown)
			{
				s_peep1++;

				if (regdown eq 2)	/* downing of regs can reduce movem's or movem time */
				{
					rhealth(rp, 1);	/* because all regs after this instr are downed */
					return true;		/* return here!!!! */
				}
				changed = true;
			}
			ip = next_ip;
		}
		bp = bp->next;
	}
	return changed;
}

global void
peep(BP bp)
{
	short pp = 1;
	/*
	 * Loop until no more changes are made. After each change, do
	 * live/dead analysis or the data gets old. In each loop, make
	 * at most one change.
	 */
#if 1
	do
	{
		rhealth(bp, pp);
		pp = 0;

	#if OPTBUG
		if break_in break;	/* Getting trapped in a loop is easy here */
	#endif
	}
	while (    peep3(bp)
			or peep2(bp)
			or peep1(bp)
		  );
#else
	/* If you cant trust your compiler
		whether it evaluates 'or' terms
		 allways left to right, you must use
		  the following sequence:	*/
	{
		bool changed;
		do
		{
			rhealth(bp, pp);
			pp = 0;
	#if OPTBUG
			if break_in break;
	#endif
			    changed = peep3(bp);
			if (!changed)
				changed = peep2(bp);
			if (!changed)
				changed = peep1(bp);

		} while (changed);
	}
#endif
}
