/*  Copyright (c) 1993 - 2008 by Henk Robbers Amsterdam.
 *
 * This file is part of CALC.
 *
 * CALC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CALC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CALC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *		PARSE.H
 *
 */

#define noDIAG 1

#define has_LEFT 1
#define need_LEFT 0

typedef double Tmode;

enum
{
	PRIMARY=-1,		/* priorities */
	UNARY,
	BINARY,
	RPAR=100,		/* terminators */
	SEMI,
	ASSN,
	EOLN=-100,
	BAD=-1,			/* primaries */
	NAKS,
	NUM,
	IDE,
	LHELM,						/* bip helmholtz giving length */
	FHELM,						/*  "      "        "   Fb	   */
	LPAR,

	/* The above names cannot be changed without recompilation
		of the parser (parse.c) itself.
		The following names are used in the table only (parsetab.c) and can be changed
		in any way as long as you change parsetab.c accordingly,
		well keeping the whole thing consistent.
	*/

	SQRT,			/* unaries  */
	SQR,
	ABS,
	SIN,
	COS,
	TAN,
	ASIN,
	ACOS,
	ATAN,
	ATANH,
	SINH,
	COSH,
	TANH,
	LOG10,
	LOG2,
	LN,
	EXP,
	INT,
	TORAD,
	TODEG,
	DEREF,
	DIAGN,

	LESS,			/* binaries	*/
	LTEQ,
	GREAT,
	GTEQ,
	EQ,
	NEQ,
	OR,
	AND,
	QUEST,
	ELSE,
	PLUS,			/* PLUS & MIN can also be unary	*/
	MIN,
	TIM,
	DIV,
	POW,
	MAX,
	RANGE
};

typedef struct
{
	int   t,p,col,row;
	char * nam;
	Tmode v;
	int step;		/* for ':' */
	bool truth;
} T;

#define is_bad(x) (x.t eq BAD)
#define is_op(x) (x.p >= UNARY)
#define is_un(x) (x.p eq UNARY)
#define is_bin(x) (x.p > UNARY)
#define is_prim(x) (x.p eq PRIMARY)

typedef T PARSE_BINOP(T o, T l, T r);
typedef T PARSE_UNOP(T o, T r);
typedef T PARSE_NEXT(void);
typedef double PARSE_RANGE(T o, T l, T r);
typedef double PARSE_DEREF(T r, int *attr);
#define primary (*parsepar.tok)
#define DO_BINOP (*parsepar.binop)
#define DO_UNOP (*parsepar.unop)
#define BADSTR {BAD,PRIMARY-10,0,0,"???",HUGE_VAL}
typedef struct parseinfo
{
	PARSE_NEXT *tok;
	void *ides;
	T c;
	char *str;
	PARSE_BINOP *binop;
	PARSE_UNOP *unop;
	PARSE_DEREF *deref;
	PARSE_RANGE *range;
	T (*tab)[];
} PARSE;

#define C parsepar.c
#define STR parsepar.str

char *parselook(char *s);
extern T parsetab[],eoln,BADTOK;
extern PARSE parsepar;
T parse_op(int o, Tmode l, Tmode r);

extern PARSE parsepar;

PARSE_NEXT parsenext;
PARSE_BINOP parse_binop;
PARSE_UNOP parse_unop;
T parse(void),   /* binary(T l, bool noleft, int lvl), */
  bad_tok(char *s);
void parsedef(PARSE_NEXT *token,
				void *ides,
				char *s,
				T (*tab)[],
				PARSE_BINOP *binop,
				PARSE_UNOP *unop,
				PARSE_RANGE *range,
				PARSE_DEREF *deref);
bool can_un(int p);
int get_int(char *, int *);		/* returns characters read :-) */
