/*  Copyright (c) 1993 - 2008 by Henk Robbers Amsterdam.
 *
 * This file is part of CALC.
 *
 * CALC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CALC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CALC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *		PARSETAB.C
 *
 */

#define __PARSE__
#include <stdio.h>			/* for scanf */
#include <math.h>
#include <prelude.h>

#include "parse.h"

#ifdef DIAG
extern bool diagnostics=true;
#endif

void tabs(int lvl);

T parsetab[]=
{
	{NUM,	PRIMARY,0,0,"pi",M_PI},
	{NUM,	PRIMARY,0,0,"e", M_E},
	{NUM,	PRIMARY,0,0,"r", 180/M_PI},
	{LHELM,	PRIMARY,0,0,"lhelm"},
	{FHELM,	PRIMARY,0,0,"fhelm"},
	{LPAR,	PRIMARY,0,0,"("	},

	{SQRT,	UNARY,0,0,"V"	},
	{SQRT,  UNARY,0,0,"sqrt"},
	{SQR,	UNARY,0,0,"sqr"	},
	{ABS,	UNARY,0,0,"abs"	},
	{SINH,	UNARY,0,0,"sinh"},
	{COSH,	UNARY,0,0,"cosh"},
	{TANH,	UNARY,0,0,"tanh"},
	{ATANH,	UNARY,0,0,"atanh"},
	{SIN,	UNARY,0,0,"sin"	},
	{COS, 	UNARY,0,0,"cos"	},
	{TAN,	UNARY,0,0,"tan"	},
	{ASIN,	UNARY,0,0,"asin"},
	{ACOS,	UNARY,0,0,"acos"},
	{ATAN,	UNARY,0,0,"atan"},
	{LOG10,	UNARY,0,0,"log10"},
	{LOG2,	UNARY,0,0,"log2"},
	{LN,	UNARY,0,0,"log"	},
	{LN,	UNARY,0,0,"ln"	},
	{EXP,	UNARY,0,0,"exp"	},
	{INT,	UNARY,0,0,"int" },
	{TORAD,	UNARY,0,0,"tor"	},
	{TODEG,	UNARY,0,0,"tod"	},
	{DEREF, UNARY,0,0,"<-"	},
#ifdef DIAG
	{DIAGN,	UNARY,0,0,"diag"},
#endif

	{MAX,	BINARY+8,0,0,"max"},
	{ELSE,	BINARY+10,0,0,"!"},
	{QUEST,	BINARY+12,0,0,"?"},
	{OR,	BINARY+14,0,0,"|"},
	{OR,	BINARY+14,0,0,"or"},
	{AND,	BINARY+16,0,0,"&"},
	{AND,	BINARY+16,0,0,"and"},
	{EQ,	BINARY+18,0,0,"="},
	{NEQ,	BINARY+18,0,0,"<>"},
	{LTEQ,	BINARY+20,0,0,"<="},
	{LESS,	BINARY+20,0,0,"<"},
	{GTEQ,	BINARY+20,0,0,">="},
	{GREAT,	BINARY+20,0,0,">"},

	{PLUS,	BINARY+23,0,0,"+"},		/* priority even: can also be unary */
	{MIN,	BINARY+23,0,0,"-"},		/* BINARY itself must be uneven!!	*/
	{TIM,	BINARY+26,0,0,"*"},
	{DIV,	BINARY+26,0,0,"/"},
	{POW,	BINARY+30,0,0,"^"},
	{RANGE, BINARY+32,0,0,":"},

	{RPAR,	PRIMARY-2,0,0,")"},		/* stoppers */
/*	{SEMI,  PRIMARY-4,0,0,";"},
	(ASSN,	PRIMARY-6,0,0,"="},
*/
	BADSTR							/* also table terminator */
};

/*       -1 -100	*/
T eoln={BAD,EOLN,0,0,"eoln",HUGE_VAL};	/* dont put this one in the table */
T BADTOK=BADSTR;

bool can_un(int p)
{
	return p >= 0 and (p&1) eq 0;
}

int get_int(char *s, int *i)
{
	int l = 0;
	*i = 0;
	sscanf(s, "%d%n", i, &l);
	return l;
}

char *parselook(char *s)
{
	char *save;

	C.truth = 0;

	if ( (*s >= '0' and *s <= '9') or *s eq '.')
	{
		int l;
		sscanf(s, "%lg%n", &C.v, &l);
		s += l;
		C.t = NUM;
		C.p = PRIMARY;
		* C.nam   ='N';
		*(C.nam+1)= 0 ;
	othw
		T *z=*parsepar.tab;
		while (z->t ne BAD)
		{
			char *cz=z->nam;
			save=s;
			while (*cz)
			{
				if (*s eq 0  ) break;
				if (*s ne *cz) break;
				s++,cz++;
			}
			if (*cz eq 0)		/* must have been equal */
			{
				C=*z;			/* make a copy */
				break;
			}
			else
				s=save;
			z++;
		}

		if (z->t eq BAD)			/* token not found (the real BAD from the table */
		{
			s = save;
			if (*s >= 'a' and *s <= 'z')
			{
				C.t = IDE;
				C.p = PRIMARY;
				C.nam = s;
				while (*s >= 'a' and *s <= 'z')
					s++;
			othw
				char *e="' ': bad token";
				s = save;
				*(e + 1) = *s++;
				C = bad_tok(e);
			}
		othw
			if (    C.t eq RANGE
			    and *s eq '%'
			   )
			{
				s++;
				s += get_int(s, &C.step);
			}
		}
	}

	return s;
}

PARSE_UNOP parse_unop		/* (T o, T r) */
{
	if (is_bad(r))
		return r;
	switch(o.t)
	{
		case MIN:
			r.v=-r.v;
		esac
		case PLUS:
			r.v=+r.v;
		esac
/*		case DIV:		unary '/'	could be: take square root */
		case SQRT:
			r.v=sqrt(r.v);
		esac
/*		case TIM:       unary '*'    could be: make square */
		case SQR:
			r.v=r.v*r.v;
		esac
		case ABS:
			if (r.v < 0)
				r.v=-r.v;
		esac
		case SIN:
			r.v=sin(r.v);
		esac
		case COS:
			r.v=cos(r.v);
		esac
		case TAN:
			r.v=tan(r.v);
		esac
		case ASIN:
			r.v=asin(r.v);
		esac
		case ACOS:
			r.v=acos(r.v);
		esac
		case ATAN:
			r.v=atan(r.v);
		esac
		case SINH:
			r.v=sinh(r.v);
		esac
		case COSH:
			r.v=cosh(r.v);
		esac
		case TANH:
			r.v=tanh(r.v);
		esac
		case ATANH:
			r.v=atanh(r.v);
		esac
		case LOG10:
			r.v=log10(r.v);
		esac
		case LN:
			r.v=log(r.v);
		esac
		case LOG2:
			r.v=log2(r.v);
		esac
		case INT:
			r.v=floor(r.v);
		esac
		case EXP:
			r.v=exp(r.v);
		esac
		case TORAD:
			r.v=(r.v*M_PI)/180;
		esac
		case TODEG:
			r.v=(r.v*180)/M_PI;
		esac
		case DEREF:
		{
			int attr;
			if (parsepar.deref)
			{
				r.v = parsepar.deref(r, &attr);
				if (attr eq BAD)
					return bad_tok("deref");
			}
			else
				return bad_tok("deref");
		}
		esac
#ifdef DIAG
		case DIAGN:
			diagnostics=r.v;
		esac
#endif
		default:
			return bad_tok("bad unary op");
	}
	o.t=NUM;
	o.p=PRIMARY;
	o.v=r.v;
	o.nam="un_res";
	return o;
}

/* T parse_binop(T o, T l, T r) */
PARSE_BINOP parse_binop
{
	double lv = l.v, rv = r.v;

	if (is_bad(l))
		return l;
	if (is_bad(r))
		return r;

	switch(o.t)
	{
		case MAX:
			if (lv < rv)
				lv = rv;
		esac
		case MIN:
			lv-=rv;
		esac
		case PLUS:
			lv+=rv;
		esac
		case TIM:
			lv*=rv;
		esac
		case DIV:
			if (rv eq 0.0)
				return bad_tok("zero_div");
			lv/=rv;
		esac
		case POW:
			lv=pow(lv,rv);
		esac
		case RANGE:
			if (parsepar.range)
				lv=parsepar.range(o,l,r);
			else
				return bad_tok("range");
		esac
		case EQ:
			lv=lv eq rv;
		esac
		case NEQ:
			lv=lv ne rv;
		esac
		case LESS:
			lv=lv < rv;
		esac
		case LTEQ:
			lv=lv <= rv;
		esac
		case GREAT:
			lv=lv > rv;
		esac
		case GTEQ:
			lv=lv >= rv;
		esac
		case OR:
			lv=lv or rv;
		esac
		case AND:
			lv=lv and rv;
		esac
		case QUEST:
			if (lv)
				l.truth=2,
				lv=rv;
			else
				l.truth=1,
				lv=0;
			o.truth=l.truth;
		esac
		case ELSE:
			if (l.truth eq 0)
				return bad_tok("bad triadic op");
			else
			if (l.truth eq 1)	/* ? yielded false */
				lv = rv;
			l.truth=0;
			o.truth=l.truth;
		esac
		default:
			return bad_tok("bad binary op");
	}
	o.t=NUM;
	o.p=PRIMARY;
	o.v=lv;
	o.nam="bin_res";
	l.v = lv;
	return o;
}
