/*  Copyright (c) 1993 - 2008 by Henk Robbers Amsterdam.
 *
 * This file is part of CALC.
 *
 * CALC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CALC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CALC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* 	SHEET.H
 *	=======
 */

#ifndef SHEET_H
#define SHEET_H

#include <stddef.h>

#define MAXCOLS 52   /* WARNING: MAXCOLS*MAXROWS*4 < 32767 !!! */
#define MAXROWS 99
#define DEFCOLW 12
#define TOPMARGIN deskw.h
#define LEFTMARGIN (4*deskw.w)

#define MAXINPUT 128
#define NAML     12
typedef
enum
{
	TXT,VAL,FORM,FUN,LAB
} SH_ATTR;

typedef struct
{
	char name[NAML];
	int cols,rows,colwsize;
	unsigned char colw[MAXCOLS];
#if sizeof(colw)&1
	char vul;
#endif
} SH_HDR;

typedef struct
{
	int size,ty,col,row;
	unsigned char attr,flags;
	double val;
	char text[MAXINPUT+1];
} SH_CELL;										/* 1 cell */

typedef struct identifier
{
	struct identifier *next;
	int ty, col, row;
	char name[32];
} IDES;

typedef SH_CELL  *CELL;							/* ptr to 1 cell */
typedef    CELL   SH_TAB[MAXCOLS] [MAXROWS];	/* table of ptrs to cell */
typedef SH_TAB   *SH_SHEET;						/* ptr to table of ptrs to cell */

CELL get_c(int col, int row);
double shparse(SH_SHEET c, IDES *ides, char *s, uchar *att);
int denotation_space(int big, int root);
bool cellname(char **input, int *col, int *row);
char * is_label(char *s, int *ty);

typedef bool SHEET_ACT(struct it *w, CELL c);

#define get_cell(w,i,j) (*(w)->wks.tab)[(i)][(j)]
#define pget_c(c,i,j)   (*(c))[(i)][(j)]			/* voor parser */

	#ifndef SHEET_C
	extern int sh_col,sh_row;
	#endif

#endif
