/*  (c) 1987 - 1991 by Han  Driesen Leiden.
 *  (c) 1996 - 2008 by Henk Robbers Amsterdam.
 *
 * This file is part of Atari Digger.
 *
 * Digger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Digger is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Digger; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * COPRO_2.C
 * =========
 */


#include <string.h>
#include <stdio.h>
#include <ctype.h>

#include "common/aaaa_lib.h"
#include "../aa_intro.h"
#include "common/config.h"
#include "ttd_kit.h"
#include "ttd_cfg.h"
#include "ttdisass.h"

void send_msg_n(char *text, ...);

#include "group.h"

group copro_2
{
	if (z mach < MC040 and ! z coldfire)
		return 780;
	/* coprocessor id 2 = on chip 040/060 pmmu & caches */
	if (i.m1 <= 3 and (i.m&3) ne 0)
	{
		if (z coldfire)
		{
			if ((i.m&3) ne 1)
				return 781;
			if (i.m1 eq 0 and i.m eq 5)
			{
				oc0(dw, "intouch", 0);
				return ea2(dw, indir|i.r);
			}
		}
		oc0(dw, i.m >= 4 ? "cpush" : "cinv", 0);
		*pos++ = (i.m&3)["?lpa"]; /* "?lpa"[i.m&3]; */
		tab(dw, z t2);
		*pos++ = "NDIB"[i.m1];
		*pos++ = 'C';
		if ((i.m&3) ne 3)
			return ea2(dw, indir|i.r);
		if (i.r ne 0)
			return 795;
	}
	elif (i.m1 eq 4 and i.m < 4)
	{
		oc0(dw, "pflush", 0);
		switch (i.m)
		{
		case 0: *pos++ = 'n'; /* break? */
		case 1: return ea_t(dw, indir|i.r);
		case 2: print("an"); break;
		case 3: *pos++ = 'a'; break;
		}
		if (i.r ne 0)
			return 794;
	othw
		if ((z mach&MC060) ne 0 and i.m1 >= 6 and i.m eq 1)		/* 060 only */
		{
			oc0(dw, "plpa", 0);
			*pos++ = (i.m1&1) ? 'i.r' : 'w';
			return ea_t(dw, indir|i.r);
		}
		elif ((z mach&MC040) ne 0 and i.m1 eq 5 and (i.m&3) eq 1)  /* 040 only */
		{
			oc0(dw, "ptest", 0);
			*pos++ = (i.m&4) ? 'i.r' : 'w';
			return ea_t(dw, indir|i.r);
		}
		else
			return 793;
	}

	return eafail;
}
