/* Copyright (c) 1990 - 2008 by H. Robbers Amsterdam.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * BIP_IO.C		for internal IO in AHCC.PRG (GEM integration)
 *
 */

#include <stdlib.h>
#include "common/mallocs.h"
#include "common/aaaa_lib.h"
#include "common/hierarch.h"

#include "aaaa.h"
#include "common/cursor.h"
#include "common/config.h"
#include "text/cursor.h"
#include "text/text.h"
#include "common/wdial.h"
#include "common/journal.h"
#include "shlcfg.h"
#include "xref.h"

extern XA_memory XA_CC_fbase;

void mklower(char *s);			/* ex shells.c */
bool clean(long size);
short src_type(char *fn);

char *CC_load(char *name, short *fh, long *l, char *opm, short key);

/* Used by the compiler */
char *Cload(char *name, short *fh, long *l, char *opm)
{
	IT *w = get_fn_it(name);

	if (!w)
		return CC_load(name, fh, l, opm, AH_CLOAD);

	*fh = w->fl;
	return condense(w, l, &XA_CC_fbase);
}

global string out_goes;
global long out_l;
global string out_buf;

extern void add_out(char *);
extern bool ARGREGS;

static
ANTEVNT rom_evm		/* IT *w; bool w_on, short evmask */
{
#ifdef WINDIAL
	set_dialinfs(w);
#endif
	return evmask|MU_KEYBD|MU_M1;
}

static
RECT rom_margin={0,0,0,0};

global
IT *open_S(char *name)
{
	IT *w = nil;

	rom_margin.x = deskw.w/2;

	w = create_IT(
				false,				/* no window */
				name,
				1,					/* fl must be positive */
				" ",				/* info */
				nil,
				KIND,
				SRC_S,
				nil,					/* OB */
				nil,					/* ob_place */
				0,					/* item */
				txt_winit,
				nil,					/* dial exit */
				nil,					/* antedraw */
				display,			/* draw */
				nil,					/* postdraw */
				rom_evm,			/* only keybd & MU_M1 */
				text_lines,
				disp_nosel,
				nil,					/* ante disp */
				nil,					/* post disp */
				close_text,
				close_textfile,
				nil,					/* no special topper */
				text_full,
				slidewindow,
				v_slider,
				arrowwindow,
				sizewindow,
				movewindow,
				nil,					/* no clicking */
				do_keybd,			/* only for arrowing */
				nil,					/* no editing */
				nil,					/* no cursor no timer */
				nil,					/* no window menu */
				nil,
				nil,
				nil,
				nil,nil,nil,			/* no window; no selection */
				nil,					/* no cursor  no form */
				m_kader,
				nil,					/* no bitmap */
				nil,
				deskw.w,
				deskw.h,
				deskw.points,
				txt_margin,
				rom_margin
				);

		if (w)
			w->wm = MAXL;			/* max line length (excl \0) */

	return w;
}

long combine_areas(void);

short close_S(IT *w)
{
	if (w)					/* 09'10 HR */

#if DEBUG
	if (SHL_cfg.an_IXC)
	{
		if (!SHL_cfg.show_IXC)
		{
			void savefile(IT *w,char *fn,bool force);
			w->mapl = combine_areas();
			w->map = out_buf;
			if (w->mapl)
			{
				send_msg("IXC to %s\n", w->title);
				savefile(w, w->title, true);		/* true: force */
			}
			via (w->close_file)(w, true);
		}
		else
		if (w->wh <= 0)
		{
			w->mapl = combine_areas();
			w->map = out_buf;
			w->wh = wind_create(w->wkind, win.x, win.y, win.w, win.h);
			if (w->wh < 0)
			{
				alertwindow("compiler output");
				return -1;
			}
			txtfreebase = stminit(&w->text, txtfreebase, STMMODE, 0, MSGS);
			w->base  = &w->text;
			w->old = nil;
			*(w->map + w->mapl) = 0;
			dosource(w);
			open_w(w);	/* put window on screen (includes get_work() & sliders()) */
		}
	}
	else
#endif
	{
		via (w->close_file)(w, true);
	}

	return 0;				/* OK same as fclose */
}
