/* Copyright (c) 1990 - 2008 by H. Robbers Amsterdam.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *	SHLCFG.C
 *
 */

#include <string.h>
#include "common/aaaa_lib.h"
#include "common/hierarch.h"

#include "aaaa.h"
#include "sheldefs.h"
#include "shell.h"
#include "common/kit.h"
#include "common/config.h"
#include "shlcfg.h"

global
OBJECT *db2;		/*	b2 debug options dialogue */

global
TEDINFO *b2xoptstr,
		*b2yoptstr;

extern
SHEL_CONFIG SHL_cfg;


#if GEMSHELL
global
OpEntry shel_tab[]=
{
	{"SHEL= {\n",0,nil},			/* nil stops recursion */
	{"UDIR=%s\n",DIR_MAX,idir.s	,0,0},			/* locations */
	{"MAKN=%s\n",DIR_MAX,mkfn.s	,0,0},
#ifdef CONDBG
	{"NBUG=%d\n",6,&SHL_cfg.no_xy_debugging,0,0,CONDBG,AMENU},
#else
	{"NBUG=%d\n",6,&dum,0,0},
#endif

#ifdef KIT								/* options ex options dialogue */
	{"CMPT=%d\n",6,&SHL_cfg.c_nested_comments,	COC,KIT},	/* nested comments			*/
	{"VOPT=%d\n",6,&SHL_cfg.v, COV0,KIT},		/* 4 levels of verbosity				*/
	{"V1PT=%d\n",6,&SHL_cfg.v1,COV1,KIT},
	{"V2PT=%d\n",6,&SHL_cfg.v2,COV2,KIT},
	{"V3PT=%d\n",6,&SHL_cfg.v3,COV3,KIT},
	{"COPT=%d\n",6,&SHL_cfg.ac_cache_headers,	COH,KIT},	/* cache headers			*/
	{"KOPT=%d\n",6,&SHL_cfg.k_char_is_unsigned,	COK,KIT},	/* default char is unsigned	*/
	{"OPT2=%d\n",6,&SHL_cfg.i2_68020,			CO2,KIT},	/* >= 68020					*/
	{"FOPT=%d\n",6,&SHL_cfg.use_FPU,			CO8,KIT},	/* 68881/2					*/
	{"FOP1=%d\n",6,&SHL_cfg.Coldfire,			CO1,KIT},	/* double is 64 bits		*/
	{"PHOP=%d\n",6,&SHL_cfg.ah_project_help,	COPH,KIT},	/* Project database (HELP)	*/
	{"PDOM=%d\n",6,&SHL_cfg.am_match,			CODM,KIT},  /* Use extra wildcare for make */
	{"APOP=%d\n",6,&SHL_cfg.aj_auto_depend,		COAP,KIT},	/* Autodependencies			*/
	{"COIH=%d\n",6,&SHL_cfg.opt_inherit,		COINH,KIT},	/* Inherit options from parent project */
	{"XOPT=%d\n",6,&SHL_cfg.h_cdecl_calling,	CORP,KIT},	/* standard calling, not Pure C calling */
	{"LOPT=%d\n",6,&SHL_cfg.ai_int32,			CO32,KIT},	/* default int is 32 bits	*/
	{"SUPT=%d\n",6,&SHL_cfg.au_supervisor,		COSUP,KIT},	/* default .super in assembly */
	{"XOPL=%d\n",6,&SHL_cfg.aw_Xnl,				COXNL,KIT},	/* default Xn is long (EmuTos) */
	{"TOPN=%d\n",6,&SHL_cfg.ln_nm_list,			COSY,KIT},	/* 'nm' symbol list			*/
	{"TOPT=%d\n",6,&SHL_cfg.lt_load_map,		COT,KIT},	/* load map					*/
	{"JOPT=%d\n",6,&SHL_cfg.lj_make_object,		COJ,KIT},	/* make object file			*/
	{"GSOP=%d\n",6,&SHL_cfg.lg_global_symbols,	COG,KIT},	/* global symbols			*/
	{"LSOP=%d\n",6,&SHL_cfg.ll_local_symbols,	COL,KIT},	/* local symbols			*/
	{"GTPT=%d\n",6,&SHL_cfg.ag_nogoto,			COGO,KIT},	/* warn goto's				*/

	{"ERFT=%d\n",6,&SHL_cfg.max_errors,0,KIT},
	{"ERPT=%d\n",6,&SHL_cfg.e_max_errors,COE,KIT},

	{"WOFT=%d\n",6,&SHL_cfg.max_warnings,0,KIT},
	{"WOPT=%d\n",6,&SHL_cfg.f_max_warnings,COF,KIT},

	{"DEFT=%s\n",DIR_MAX,SHL_cfg.definestr     [0],0,    KIT},
	{"DEPT=%d\n",6,     &SHL_cfg.d_define_macro[0],COD,  KIT},
	{"DEF1=%s\n",DIR_MAX,SHL_cfg.definestr     [1],0,    KIT},
	{"DEP1=%d\n",6,     &SHL_cfg.d_define_macro[1],COD1, KIT},
	{"DEF2=%s\n",DIR_MAX,SHL_cfg.definestr     [2],0,    KIT},
	{"DEP2=%d\n",6,     &SHL_cfg.d_define_macro[2],COD2, KIT},
	{"DEF3=%s\n",DIR_MAX,SHL_cfg.definestr     [3],0,    KIT},
	{"DEP3=%d\n",6,     &SHL_cfg.d_define_macro[3],COD3, KIT},
	{"DEF4=%s\n",DIR_MAX,SHL_cfg.definestr     [4],0,    KIT},
	{"DEP4=%d\n",6,     &SHL_cfg.d_define_macro[4],COD4, KIT},

	{"IOFT=%s\n",DIR_MAX,SHL_cfg.inclstr      [0],0,   KIT},
	{"IOPT=%d\n",6,     &SHL_cfg.i_include_dir[0],COI ,KIT},
	{"IOF1=%s\n",DIR_MAX,SHL_cfg.inclstr      [1],0,   KIT},
	{"IOP1=%d\n",6,     &SHL_cfg.i_include_dir[1],COI1,KIT},
	{"IOF2=%s\n",DIR_MAX,SHL_cfg.inclstr      [2],0,   KIT},
	{"IOP2=%d\n",6,     &SHL_cfg.i_include_dir[2],COI2,KIT},
	{"IOF3=%s\n",DIR_MAX,SHL_cfg.inclstr      [3],0,   KIT},
	{"IOP3=%d\n",6,     &SHL_cfg.i_include_dir[3],COI3,KIT},
	{"IOF4=%s\n",DIR_MAX,SHL_cfg.inclstr      [4],0,   KIT},
	{"IOP4=%d\n",6,     &SHL_cfg.i_include_dir[4],COI4,KIT},

	{"DOMT=%s\n",DIR_MAX,SHL_cfg.matchstr,0,KIT},
	{"DOFT=%s\n",DIR_MAX,SHL_cfg.libstr,  0,KIT},
	{"DOPT=%d\n",6,     &SHL_cfg.d_lib_dir,COLIB,KIT},
#endif

#ifdef BUGGER
	{"LNOB=%d\n",6,&SHL_cfg.al_list_stats,	COLN,BUGGER},		/* node stats */
	{"LOPB=%d\n",6,&SHL_cfg.no_link,		COSL,BUGGER},		/* suppress linker */
	{"PHPB=%d\n",6,&SHL_cfg.ap_no_peep,		CON,BUGGER},		/* suppress peep */
	{"PHPD=%d\n",6,&SHL_cfg.ad_new_peep,	CONN,BUGGER},		/* do newest peep */
	{"POPB=%d\n",6,&SHL_cfg.an_IXC,			COIXC,BUGGER},		/* IXC only */
	{"SOPB=%d\n",6,&SHL_cfg.show_IXC,		COSHIXC,BUGGER},	/* show IXC */
	{"BOPQ=%d\n",6,&SHL_cfg.ar_no_registerization,COR,BUGGER},	/* dont registerize */
	{"BOPE=%d\n",6,&SHL_cfg.ae_no_extracodes,COBE,BUGGER},		/* suppress extracodes (ahcc_rt.h) */
	{"TOPB=%d\n",6,&SHL_cfg.at_token_list,	COTL,BUGGER},		/* print token list */
	{"AOPB=%d\n",6,&SHL_cfg.aa_debugging,	COA,BUGGER},
	{"ZOPB=%d\n",6,&SHL_cfg.az_debugging,	COZ,BUGGER},

	{"XDFB=%s\n",DIR_MAX,SHL_cfg.xoptstr,0,BUGGER},
	{"XDPB=%d\n",6,&SHL_cfg.ax_debugging,COX,BUGGER},

	{"YDFB=%s\n",DIR_MAX,SHL_cfg.yoptstr,0,BUGGER},
	{"YDPB=%d\n",6,&SHL_cfg.ay_debugging,COY,BUGGER},

#else
	{"LNOB=%d\n",6,&dum,0,0},
	{"LOPB=%d\n",6,&dum,0,0},
	{"PHPB=%d\n",6,&dum,0,0},
	{"POPB=%d\n",6,&dum,0,0},
	{"SOPB=%d\n",6,&dum,0,0},
	{"BOPQ=%d\n",6,&dum,0,0},
	{"BOPE=%d\n",6,&dum,0,0},
	{"TOPB=%d\n",6,&dum,0,0},
	{"AOPB=%d\n",6,&dum,0,0},
	{"ZOPB=%d\n",6,&dum,0,0},

	{"XDFB=%s\n",DIR_MAX,SHL_cfg.xoptstr,0,0},
	{"XDPB=%d\n",6,&dum,0,0},

	{"YDFB=%s\n",DIR_MAX,SHL_cfg.yoptstr,0,0},
	{"YDPB=%d\n",6,&dum,0,0},
#endif
	{"}      \n"},
	{"\0"}
};
#endif

#if defined BUGGER && DEBUG && MTDEBUG
global
void dial_b2(void)
{
	char *d;  short obno;
	SHEL_CONFIG savefl=SHL_cfg;

	keusaf(db2[B2OK]);
	keusaf(db2[B2CANC]);
	strcpy( b2xoptstr ->text,SHL_cfg.xoptstr);
	strcpy( b2yoptstr ->text,SHL_cfg.yoptstr);
	options(shel_tab,OSET);
	d=form_save(db2,0,v_hl);
	do
	{
		obno=form_move(db2,v_hl,d,TRUE,0,B2MOVER,B2CANC,&scr_grect);
		if (findopt(shel_tab,obno,BUGGER) ne nil)
		{
			opt_to_cfg(shel_tab, obno, BUGGER, db2, menu);
			draw_ob(db2,obno,scr_grect);
		}
	} while ( obno ne B2OK and obno ne B2CANC);
	if (obno ne B2CANC )
	{
		strcpy(SHL_cfg.xoptstr,  b2xoptstr ->text);
		strcpy(SHL_cfg.yoptstr,  b2yoptstr ->text);
	othw
		SHL_cfg=savefl;
	}
	form_rest(db2,0,v_hl,d);
}
#endif

void dbg_to_rsc(void)
{
	KIT_REFS *k = &pkit;
	short i;

	loop(i, 5)
		strcpy( k->definestr[i]->text, SHL_cfg.definestr[i]);
	loop(i, 5)
		strcpy( k->inclstr  [i]->text, SHL_cfg.inclstr  [i]);
	strcpy( k->matchstr     ->text, SHL_cfg.matchstr);
	strcpy( k->libstr       ->text, SHL_cfg.libstr);
	sprintf(k->max_errors   ->text, "%d",SHL_cfg.max_errors);
	sprintf(k->max_warnings ->text, "%d",SHL_cfg.max_warnings);
	options(shel_tab, OSET);	/* put options in rsc */
}

void rsc_to_dbg(void)
{
	KIT_REFS *k = &pkit;
	short i;

	options(shel_tab, OGET);	/* get options in cfg for output */
	loop(i, 5)
		strcpy(SHL_cfg.definestr[i], k->definestr[i]->text);
	loop(i, 5)
		strcpy(SHL_cfg.inclstr  [i], k->inclstr[i]  ->text);
	strcpy(SHL_cfg.matchstr, 	k->matchstr    ->text);
	strcpy(SHL_cfg.libstr,      k->libstr      ->text);
	SHL_cfg.max_errors   = cdbv(k->max_errors  ->text);
	SHL_cfg.max_warnings = cdbv(k->max_warnings->text);
}

void *subst_objects( OBJECT  *obs, bool menu );
void  subst_free   ( USERBLK *ublks );

USERBLK *ubdb2 = nil;

global
void kit_for_shell(void)
{
	KIT_REFS *k = &pkit;

#if defined BUGGER && DEBUG && MTDEBUG
	rsrc_gaddr(0,BUGGER,&db2);
	ubdb2 = subst_objects(db2,false);
	form_align(db2,TRUE,menu[MTDEBUG].x+3*scr.wchar,20,&scr_grect);
	b2xoptstr =get_tedinfo(db2,COXL);
	b2yoptstr =get_tedinfo(db2,COYL);
#endif
	k->definestr[0] = get_tedinfo(k->tree,CODEF);
	k->definestr[1] = get_tedinfo(k->tree,CODEF1);
	k->definestr[2] = get_tedinfo(k->tree,CODEF2);
	k->definestr[3] = get_tedinfo(k->tree,CODEF3);
	k->definestr[4] = get_tedinfo(k->tree,CODEF4);
	k->inclstr  [0] = get_tedinfo(k->tree,COINCL);
	k->inclstr  [1] = get_tedinfo(k->tree,COINCL1);
	k->inclstr  [2] = get_tedinfo(k->tree,COINCL2);
	k->inclstr  [3] = get_tedinfo(k->tree,COINCL3);
	k->inclstr  [4] = get_tedinfo(k->tree,COINCL4);
	k->matchstr     = get_tedinfo(k->tree,COMATCH);
	k->libstr       = get_tedinfo(k->tree,COLIBDIR);
	k->max_errors   = get_tedinfo(k->tree,COEN);
	k->max_warnings = get_tedinfo(k->tree,COWN);
}

global string get_definestr(short i)
{
	return pkit.definestr[i]->text;
}
global string get_inclstr(short i)
{
	return pkit.inclstr[i]->text;
}
global string get_matchstr(void)
{
	return pkit.matchstr->text;
}
global string get_libstr(void)
{
	return pkit.libstr->text;
}
global short get_max_errors(void)
{
	return cdbv(pkit.max_errors->text);
}
global short get_max_warnings(void)
{
	return cdbv(pkit.max_warnings->text);
}

CFGNEST shell_cfg		/* FILE *fp, OpEntry **tab, short lvl, short io */
{
	if (io eq 1)
		saveconfig(fp, shel_tab, lvl+1, nil);
	else
		loadconfig(fp, shel_tab, lvl+1, nil);
}

void end_shlcfg(void)
{
 	#if defined BUGGER && DEBUG && MTDEBUG
	subst_free(ubdb2);
	#endif
}