/* Copyright (c) 2004 - 2008 by H. Robbers Amsterdam.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * xref.h			defines for the projects cross reference
 *                  database.
 */

#ifndef XREF_H
#define XREF_H

#include <prelude.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "common/ahcm.h"

/* 04'09 xref now also used for filenames :-) */
typedef struct xref
{
	struct xref *next, *less, *great;
	long line_number;
	short scope, file_number;
	short n;
	char name[0];
} XREF;

typedef struct xref_base
{
	XREF *cur, *first, *last;
} XREF_BASE;

#define SEPT '\\'
#define SEPU '/'

/* 04'09 normalized DB structure */
typedef struct depdat
{
	struct depdat *next;
	short depfileno;
	char depname[0];
} DEPDATA;

typedef struct dep
{
	struct dep *next, *depend;
	XREF *data;
/*	short depfileno;
	char depname[0]; */
} DEP;

typedef struct
{
	long bytes, lines,
	     cbytes, clines,
	     start, end, time;
} STATS;

extern DEP *auto_dependencies, *prj_dependencies;
extern XREF_BASE identifiers;
extern XREF_BASE filenames;
extern bool dep_changed;
extern short filecount, high_prj;
extern STATS stats;

void	xref_init			(void);
void	xref_list_files		(FILE *fp, DEP *dp, short lvl);
DEP *	xref_find_file		(DEP *root, char *name, bool deep);
DEP *	xref_new_file		(DEP **in, char *name, short count);
char *	xref_file_by_number	(DEP *root, short number);
void	xref_free_dep		(void);
void	xref_write_dep		(void);
DEP *	xref_read_dep		(void);
XREF *	xref_find_ide		(XREF_BASE *ides, char *n);
XREF *	xref_new_ide		(short which, XREF_BASE *ides, char *ide, short file, long line, short ty);
short 	xref_scope			(short scope);
void	xref_list_ides		(FILE *fp, XREF *x);
void	xref_list_ordered	(FILE *fp, XREF *x, char arrow, short lvl);

#endif
