/* Copyright (c) 1990 - 2008 by H. Robbers Amsterdam.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* 	CURSOR.C
 *	========
 */

#include <ctype.h>
#include "common/aaaa_lib.h"
#include "common/hierarch.h"

#include "aaaa.h"
#include "common/kit.h"
#include "cursor.h"
#include "text.h"
#include "text_sel.h"
#include "editor.h"
#include "common/cursor.h"

/*  table of character classes, each ch translates to a class.  */
/*  STP		= mostly punctuation */
/*  WSP		= white space */
/*  > WSP	= 'word' --> value */
/* other values: special characters; see <cursor.h> for TRANS_CH */

/*	string tbv AHCX test: })]>{([< */

TRANS_CH chcl[]=
{
	WSP,										/* hex(00) end string */
	STP,STP,STP,STP,STP,STP,STP,				/* hex(01) tm hex(07) */
	WSP,										/* hex(08) tab		 */
	WSP,										/* hex(09) HT		 */
	WSP,										/* hex(0A) LF		 */
	WSP,										/* hex(0B) VT		 */
	WSP,										/* hex(0C) FF		 */
	WSP,										/* hex(0D) CR		 */
	STP,STP,									/* hex(0E) en hex(0F) */
	STP,STP,STP,STP,STP,STP,STP,STP,
	STP,STP,STP,STP,STP,STP,STP,STP,			/* hex(10) tm hex(1F) */
	WSP,										/* hex(20) space	  */
	STP,										/* hex(21)			  */
	QUO,										/* hex(22) quote	  */
	'#',STP,STP,STP,							/* hex(23) tm hex(26) */
	APOS,										/* hex(27)            */
	L_P,R_P,									/* hex(28) en hex(29) () */
	STP,STP,STP,STP,STP,STP,					/* hex(2A) tm hex(2F) */
	'0','1','2','3','4','5','6','7','8','9',	/* hex(30) tm hex(39) */
	STP,STP,									/* hex(3A) en hex(3B) */
	L_H,										/* hex(3C)   < */
	STP,										/* hex(3D) 	 = */
	R_H,										/* hex(3E)   > */
	STP,STP,									/* hex (3F) en hex(40) */
	'A','B','C','D','E','F','G','H',
	'I','J','K','L','M','N',					/* hex(41) tm hex(4E) */
	'O','P','Q','R','S','T','U','V',
	'W','X','Y','Z', 							/* hex(4F) tm hex(5A) */
	L_I,										/* hex(5B)  [ */
	STP,										/* hex(5C)    */
	R_I,										/* hex(5D)  ] */
	STP,										/* hex(5C) */
	'_',										/* hex(5F) */
	STP,										/* hex(60) */
	'a','b','c','d','e','f','g','h',
	'i','j','k','l','m','n',					/* hex(61) tm hex(6E) */
	'o','p','q','r','s','t','u','v',
	'w','x','y','z',							/* hex(6F) tm hex(7A) */
	L_C,										/* hex(7B) { */
	STP,										/* hex(7C)   */
	R_C,										/* hex(7D) } */
	STP,STP,									/* hex(7E) en hex(7F) */

	'','','','','','','','','','','','','','','','',
	'','','','','','','','','','','',STP,STP,STP,STP,STP,
	'','','','','','','','',STP,STP,STP,STP,STP,STP,STP,STP,
	'','','','','','','','','',STP,STP,STP,STP,STP,STP,STP,
	/* hebrew translates to lower case alpha and is then displayed bold */
	'','',STP,'a','b','c','d','e','f','g','h','i','j','k','l','m',
	'n','o','p','q','r','s','t','u','v','w','x','y','z',STP,STP,STP,
	STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,
	STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP,STP
	/* hex(80) tm hex(FF) */
};

#define T (unsigned char)

static
bool cur_vis(IT *w)
{
	if (	w->cu.l         >= w->top
		and w->cu.l         <  w->top + w->hw
		and w->cu.s         >  w->left
		and w->cu.s-w->left <= w->ww
	   )
		return true;
	return false;
}

global
bool write_cur(IT *w, CINF cu)		/* top left pos: 1,1 */
{
	if (	cu.l         >= w->top
		and cu.l         <  w->top + w->hw
		and cu.s         >  w->left
		and cu.s-w->left <= w->ww
	   )
	{
		short c[10];	
	
		c[0] = w->ma.x;
		c[0]+=(cu.s-w->left-1)*w->w;
		c[1] = w->ma.y;
		c[1]+=(cu.l-w->top   )*w->h;
		c[2] = c[0]+w->w-1;
		c[3] = c[1]+w->h-1;
	#ifdef CURLINE
		c[0]-=1;
		c[2]+=1;
		c[1]+=w->h-1;
		c[3]+=1;
	#endif
		write_curect(w->hl, c);
		return true;
	}
	else
		return false;
}

global
CURSOR win_cursor		/*	(IT *w, CURST to) */
{
	if (to eq OFF)
	{
		if (w->cup eq OFF) return;			/* cursor already off */
		w->cup=OFF;							/* converge */
		if ( w->ss.l) return;				/* not if selection on */
		write_cur(w,w->cu);					/* if visible, unwrite */
	othw
		if ( w->cup eq ON) return;			/* cursor already on */
		if ( w->ss.l) return;				/* not if selection on */
		if (write_cur(w,w->cu))					/* if visible, write */
			w->cup=ON;
	}
}

global
TIMER txt_timer		/* IT *w */	/* for cursor */
{
	if (w->cup eq ON)
		cur_off(w);
	else
		cur_on(w);
}

global
void f_to_s_t(IT *w, CINF *ci)
{
	if (ci->l > w->n)
		ci->l = w->n;

#if WINTEXT
	if (is_text(w))
	{
		char *pm,*ps;

		find_line(w,ci->l);		/* sets w->line */
	
		pm=w->line;
		ps=pm;
		
		ci->s=1;
	
		while (pm < ps+ci->f)
		{
			if (*pm eq '\t' and w->loc.tabs)
				ci->s=totab(ci->s-1,w->loc.tabs)+1;
			else
				ci->s++;
			pm++;
		}
	}
	else
#endif
		ci->s=ci->f+1;
	ci->t=ci->s;
}

global
bool t_to_s_f(IT *w, STMNR cul, short target, CINF *ci, CUR_TO rich)
{								/* rich = HIGH : CUR_RIGHT */
								/*   "    LOW  : all other */
	if (target <= 0)
		return false;			/* scroll! */

	ci->t=target;
	ci->l=cul;

#if WINTEXT
	if (is_text(w))
	{
		short p, c=1;
		char *pm, *ps;

		find_line(w,cul);
		pm = w->line;
		ps = pm;
		
		while (    c < target
		       and c <= w->wm
		       and (p=*pm) ne 0
		      )
		{
			if ( p eq '\t' and w->loc.tabs )
			{
				short t = totab(c-1,w->loc.tabs)+1;
	
				if ( t > target )
				{
					if (rich eq HIGH)
					{
						c = t;		 /* skip over tab */
						ci->t = t;
						pm++;
					}
					break;			 /* stay  on  tab */ 
				}
				c = t;
			}
			else
				c++;
			pm++;
		}
		ci->s = c;
		ci->f = pm-ps;				/* physical pos in bitmap */
		return (p ne 0);			/* false for scrolling */
	}
	else
#endif
	{
		ci->s = target;		/* no text: no weird tabulate thing */
		ci->f = target-1;
		return (ci->f < w->wm);
	}
}

NEXT_CH next_ch			/*	IT *w,CINF *ci	*/
{
	short c;
	STMC *nx;
	STMDEF *d;
	char *p = w->line+ci->f;
	if (ci->l <= 0)				/* only when prev_ch was beyond first char */
	{
		*ci=c1st;				/* t,s,f,l = 1,1,0,1 */
		c = *w->line;
	othw
		if ( !*p )
		{
			d=w->base;
			if ((nx=stmfinext(d)) eq 0L)
				return FBOUND;			/* allways translates to stopchar */
			ci->l++;
			ci->f=0;
			p = nx->xtx;
			w->line=p;
			c = *p;
		othw
			ci->f++;
			c = *(p+1);
		}
	}
	if (!c)
		c = '\n';
	return c;
}

static
NEXT_CH forw_ch		/* stay within line */
{
	short c = *(w->line+ ++ci->f);
	if (!c)
		return FBOUND;
	return c;
}

NEXT_CH prev_ch
{
	STMC *nx;
	STMDEF *d;

	if (ci->f-1 >= 0)
		return *(w->line + --ci->f);

	d=w->base;
	ci->l--;
	if ((nx=stmfiprior(d)) eq 0L)
		return ci->l = 1, FBOUND;	/* allways translates to stopchar */
	ci->f=nx->xl;
	w->line=nx->xtx;
	return '\n';
}

static
NEXT_CH back_ch		/* stay within line */
{
	if (ci->f-1 >= 0)
		return *(w->line + --ci->f);
	return FBOUND;
}

global
short hook,hooklevel;

global
short is_hook(char *f)
{
	short hook = 0;
	uchar c;

	if   mcmp_lcom(f)
		hook = L_COM;
	elif mcmp_rcom(f)
		hook = R_COM;
	else
	{
		c=chcl[T*f];
		if (c >= L_C and c <= R_C)	/* {([<>])} */
			hook = c;
	}
	return hook;
}

global
bool str_any(IT *w, CINF *cf, SEL_CMP *cmp, NEXT_CH *nxt)
{
	if (   !(*cmp)(w->line+cf->f) )
		return false;
	do
		if ( (*nxt)(w,cf) eq FBOUND)
			return FBOUND;
	while ( (*cmp)(w->line+cf->f) );

	return true;
}

/*
static
bool is_eof(IT *w,CINF *f)
{
	STMC *sf;
	if (f->l eq 1 and f->f eq 0)
		return true;
	if (f->l eq w->n and f->f eq  ????)
		return true;
}
*/

global
void str_surr(IT *w, CINF *fs, CINF *fe, SEL_CMP *cmp)
{
	find_line(w,fs->l);
	str_any(w,fs,cmp,prev_ch);			/* left surround */
	next_ch(w,fs);						/* skip the one not true at left */
	if (fs->l ne fe->l)
		find_line(w,fe->l);
	str_any(w,fe,cmp,next_ch);			/* right surround	*/
}

global
void cat_hash(IT *w, CINF *fs)
{
	CINF tfs;

	if (chcl[T*(w->line+fs->f)] eq '#')
		return;

	tfs = *fs;
	back_ch(w,&tfs);
	str_any(w,&tfs,cmp_space,back_ch);
	if (chcl[T*(w->line+tfs.f)] eq '#')
		*fs = tfs;
}

static
bool str_hash(IT *w, CINF *fs)
{
	bool ok;
	CINF tfs;

	if (chcl[T*(w->line+fs->f)] eq '#')
	{
		ok = forw_ch(w,fs);
		if (ok eq FBOUND)
			return true;
		tfs = *fs;
		str_any(w,&tfs,cmp_space,forw_ch);
		*fs = tfs;
	}
	ok = str_any(w,fs,cmp_word,next_ch);
/*	alert_msg("str_hash | ok %d ", ok);
*/	return ok;
}

global
NEXT_WD next_word	/*	IT *w; CINF *fs,*fe	*/
{
	bool ok;

	str_hash(w,fs);
	ok = str_any (w,fs,cmp_nonw,next_ch);	/* ok for FBOUND */
	if (ok ne FBOUND)
	{
		find_line(w,fs->l);
		*fe=*fs;
		ok = str_hash(w,fe);
	}
	return ok;
}

global
NEXT_WD prev_word	/*	IT *w; CINF *fs,*fe	*/
{
	bool ok = true;

	ok = prev_ch(w,fs);
	if (ok ne FBOUND)
	{
		if ( !str_any(w,fs,cmp_word,prev_ch) )	/* to start of word if not on */
		{
			str_any(w,fs,cmp_nonw,prev_ch);
			ok=str_any(w,fs,cmp_word,prev_ch);
		}
		if (ok)
		{
			next_ch(w,fs);
			find_line(w,fs->l);
			*fe=*fs;
			ok = str_any(w,fe,cmp_word,next_ch);
			if (ok) cat_hash(w,fs);
		}
	}
	return ok;
}

bool do_key(IT *w,short kcode)		/* we know w is open and on top */
{
#ifdef MTEDITOR
	if (w->edit)
	{
		if (w->edit(w,kcode))
			return true;
	}
	else
		alertm(frstr(ROMW));
#endif

	return false;
}

/* txtsel_cursor is in TXT_SEL.C */
/* This function also used by CALC (sheet.c) */
bool do_cursor(IT *w,short kcode)		/* kcode is < 0 !! */
{
	short k = kcode&0xff;

	if (kcode&NKF_SHIFT)
		if (kcode&NKF_CTRL)
			switch (k)
			{
				case NK_DOWN:
					(*w->arrowd)(w,WA_DNLINE,true);
					return true;
				case NK_UP:
					(*w->arrowd)(w,WA_UPLINE,true);
					return true;
				case NK_LEFT:
					(*w->arrowd)(w,WA_LFLINE,true);
					return true;
				case NK_RIGHT:
					(*w->arrowd)(w,WA_RTLINE,true);
					return true;
			}
		else
			switch (k)
			{
				case NK_DOWN:
				case NK_UP:
				{
					short disp;
					cur_off(w);
					make_vis_top(w);				/* also sets top */
					disp = w->cu.l - w->top;
					(*w->arrowd)(w,k eq NK_DOWN ? WA_DNPAGE : WA_UPPAGE,true);
					t_to_s_f(w,w->top+disp,w->cu.t,&w->cu,LOW);
				}
				return true;
				case NK_LEFT:
					cur_off(w);
					w->cu.s=1;
					w->cu.t=1;
					w->cu.f=0;
					make_vis_top(w);
				return true;
				case NK_RIGHT:
					cur_off(w);
					t_to_s_f(w,w->cu.l,w->wm,&w->cu,HIGH);
					make_vis_top(w);
				return true;
				case NK_CLRHOME:
				{
					cur_off(w);
					if (w->base)
						stmfilast(w->base);		/* snel */
					w->cu.l=w->n;
					t_to_s_f(w,w->cu.l,w->wm,&w->cu,HIGH);
					make_vis_top(w);
				}
				return true;
			}
	else
	switch (k)
	{
	case NK_LEFT:
		cur_off(w);
		w->cu.s--;
		if (t_to_s_f(w,w->cu.l,w->cu.s,&w->cu,LOW))
		{
			make_vis_top(w);
			return true;
		}
		w->cu.s=1;
		if (w->cu.l > 1)
			w->cu.t=w->wm;
		else
			w->cu.t=1;
	fall_thru  						/* if scoll */
	case NK_UP:
		if (w->cu.l > 1 )
		{
			cur_off(w);
			if (w->cu.l-- eq w->top)
				(*w->arrowd)(w,WA_UPLINE,true);
			cur_off(w);
			t_to_s_f(w,w->cu.l,w->cu.t,&w->cu,LOW);
			make_vis_top(w);
		}
		return true;

	case NK_RIGHT:
		cur_off(w);
		w->cu.s++;

		if (t_to_s_f(w,w->cu.l,w->cu.s,&w->cu,HIGH) )
		{
			make_vis_top(w);
			return true;
		}
		w->cu.t=1;
	fall_thru 						/* if scroll */
	case NK_DOWN:
		if (w->cu.l < w->n )
		{
			cur_off(w);
			if (w->cu.l++ eq w->top+w->hw-1)
				(*w->arrowd)(w,WA_DNLINE,true);
			cur_off(w);
			t_to_s_f(w,w->cu.l,w->cu.t,&w->cu,LOW);
			make_vis_top(w);
		}
		return true;

	case NK_CLRHOME:
		cur_off(w);
		w->cu=c1st;
		if (w->base)
			stmfifirst(w->base);		/* snel */
		make_vis_top(w);
		return true;
	}

	return false;			/* not processed */
}

/* txtsel_button is in TXT_SEL.C */
/* also called by CALC (sheet.c) */
BUTTON txt_click		/* w,button,kstate,bclicks,mx,my */
{
	STMNR top = w->top;
	short by,bx;

	bx=mx-w->ma.x+w->w;
	bx=bx/w->w+w->left;

	by=(my-w->ma.y)/w->h+top;

#if WINTEXT
	if (w->base)
	{
		STMC *curs=find_line(w,by);
		by=curs->xn;		/* if beyond last line in small files */
	}
#endif
	cur_off(w);
	t_to_s_f(w,by,bx,&w->cu,LOW);
	cur_on(w);

	if (kstate&CONTRL)		/* make line top line */
	{
		w->top=by;
		w->top=bounce(w,by);
		via (w->slider)(w);
		cur_off(w);
		do_redraw(w,w->wa);
	}
}

KEYBD do_keybd 			/*	w,kcode		*/
{
	cur_off(w);
	if (kcode > 0 or !do_cursor(w,kcode))	/* cursor handling */
		 do_key(w,kcode);	/* other keys */
	cur_on(w);
}

char *compare(char **zmm, char *zoek, bool kast)
{
	char *zm = *zmm;
	if (kast)
		while (*zoek)
			if ( *zm eq *zoek )
				zm++,zoek++;
			else
				break;	/* while *zoek */
	else
		while (*zoek)
			if ( tolower(*zm) eq tolower(*zoek) )
				zm++,zoek++;
			else
				break;	/* while *zoek */
	*zmm = zm;
	return zoek;
}

/* general find */
global
bool Find(IT *w,						/* window info									*/
			char *z,					/* primary string    	(OR relations)			*/
			char *zz[],					/* secondary strings	  "      "				*/
			CINF cu,					/* in:  start position of search				*/
			CINF *ss, CINF *se,			/* out: start & end of found					*/
			bool word,					/* letters & digits, but starting with a letter */
			bool kast,					/* case sensitive								*/
			bool forw					/* direction: false = backward					*/
		)
{
	STMC *s;
	bool selected,first = true;
	char *zm,*zoek,*l,*zocht;
	STMDEF *d;
	CINF ze,zs;

	if (*z eq 0)
		return false;

	selected = false;
	zs = cu;
	d = w->base;

	find_line(w,zs.l);
	l=w->line+zs.f;

	if (forw)
		do
		{
			if (word)
			{
				if (zs.l <= 0)
					zs=c1st,l=w->line;
				while ( *l and mcmp_word(l) )
					l++,zs.f++;

				do				/* now *l is either 0 or non_word */
					if (!*l)
					{
						if ( (s=stmfinext(d)) eq 0L)
							break;
						zs.l++;
						zs.f=0;
						l=w->line=s->xtx;
					othw
						if (!first)
							l++, zs.f++;
						else
							first = false;
					}
				while ( mcmp_nonw(l) );
			othw
				if (!*l)
				{
					if ( (s=stmfinext(d)) eq 0L)
						break;
					zs.l++;
					zs.f=0;
					l=w->line=s->xtx;
				othw
					if (!first)
						l++, zs.f++;
					else
						first = false;
				}
			}

			zm = l;
			zocht = z;
			zoek = compare(&zm,z,kast);
			if (*zoek)	/* z not found */
			{
				if (zz eq nil)
					continue;
				else			/* secondary strings */
				{
					short i = 0;
					while (zz[i])
					{
						zm = l;
						zocht = zz[i++];
						zoek = compare(&zm,zocht,kast);
						if (!*zoek)
							break;		/* found one */
					}
					if (*zoek)
						continue;		/* nothing found */
				}
			}

			if (    !word
				or ( word and mcmp_nonw(zm))
			   )
			{
				selected = true;
				break;		/* do ... while stmnext ... */
			}
		} while (stmnext(*d) ne (d->cyclic ? stmfirst(*d) : 0L) );
	else			/* BACKWRD */
		do
		{
			if (word)
			{
				while ( mcmp_word(l) )
					if (zs.f > 0)
						l--,zs.f--;
					else
						break;

				do
					if (zs.f eq 0)
					{
						zs.l--;
						if ( (s=stmfiprior(d)) eq 0L)
							break;
						zs.f=s->xl;
						l=w->line=s->xtx;
						l+=zs.f;
					othw
						l--;
						zs.f--;
					}
				while ( mcmp_nonw(l) );

				while ( mcmp_word(l) )
					if (zs.f > 0)
						l--,zs.f--;
					else
						break;
				if ( mcmp_nonw(l) )
					l++,zs.f++;
			othw
				if (zs.f eq 0)
				{
					zs.l--;
					if ( (s=stmfiprior(d)) eq 0L)
						break;
					zs.f=s->xl;
					l=w->line=s->xtx;
					l+=zs.f;
				othw
					l--;
					zs.f--;
				}
			}

			zm = l;
			zocht = z;
			zoek = compare(&zm,z,kast);
			if (*zoek)	/* z not found */
			{
				if (zz eq nil)
					continue;
				else			/* secondary strings */
				{
					short i = 0;
					while (zz[i])
					{
						zm = l;
						zocht = zz[i++];
						zoek = compare(&zm,zocht,kast);
						if (!*zoek)
							break;		/* found one */
					}
					if (*zoek)
						continue;		/* nothing found */
				}
			}

			if (    !word
				or ( word and mcmp_nonw(zm))
			   )
			{
				selected = true;
				break;		/* do ... while stmnext ... */
			}
		} while (stmprior(*d) ne (d->cyclic ? stmlast(*d) : 0L));

	if (selected)
	{
		ze=zs;
		ze.f=zs.f+(zoek-zocht);
		f_to_s_t(w,&zs);
		f_to_s_t(w,&ze);
		*ss=zs;
		*se=ze;
	}
	return selected;
}


/*  find & select
    forw:
    1 = forward and reverse if not found
   -1 = forward and dont reverse (for repair usage)
    0 = backward and reverse 						*/
bool do_find(IT *w,char *z,char *zz[],
			bool word, bool kast, bool surr, short forw)
{
	CINF ss,se;
	CINF cu = w->ss.l
				? (forw eq 0
					? w->ss
					: w->se)
				: w->cu;

	if  (Find(w, z, zz, cu, &ss, &se, word, kast, forw ne 0))
	{
		via (w->deselect)(w,forw ne 0);	/* incl actual writing (reverse mode) */
		if ( surr )
		{
			prev_ch(w,&ss);
			str_surr(w,&ss,&se,cmp_space);
			f_to_s_t(w,&ss);
			f_to_s_t(w,&se);
		}
		w->ss=ss;
		w->se=se;
		w->cu = forw ne 0 ? se : ss;
		if (!make_vis_cur(w))
			via (w->select)(w);
		return true;
	othw
		ping;
		if (forw >= 0)
			reverse_rich();
		return false;
	}
}

#if WINTEXT
/* find & select using find-dialogue options */
bool dial_find(IT *w, char *zoek)
{
	return do_find(w, zoek, nil,
		cfg.wrd, cfg.csens, cfg.surr, cfg.forw);
}
#endif

void invoke_cursor(OBJECT *m)
{
#ifdef KIT
	invoke_kit();
#endif

#ifdef MTEDITOR
	invoke_editor(m);
#endif
}
