/* Copyright (c) 1990 - 2008 by H. Robbers Amsterdam.
 *
 * This file is part of AHCC.
 *
 * AHCC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AHCC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AHCC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* 	WI_TYPES.H
 *	==========
 */

#ifndef WI_TYPES_H
#define WI_TYPES_H

#if WKS
#include "calc/sheet.h"		/* contains IT types for worksheets */
#endif

#ifdef JOURNAL
#define alertm alert_jrnl    /* alerts with 1 button (OK) */
short alert_jrnl(char *,...);
#else
#define alertm alert_msg
#endif

/* declarations needed before storeman.h and winfo.h */

typedef enum {LOW,HIGH} CUR_TO;
typedef enum {OFF,ON} CURST;
typedef enum {REUNDONE = -1,ALT,UNDONE} UDO;
typedef void DRAW   (struct it *w,RECT t2);
typedef void LINES  (struct it *w, short arrow);
typedef void MARGIN (struct it *w, struct stmcell *s, short y);
typedef short  ANTEVNT(struct it *w, bool w_on, short evmask);
typedef char MAP;
typedef DRAW REDRAW;
typedef void OB_PLACE(struct it *w);
typedef void CLOSED (struct it *w);
typedef void TOPPED (struct it *nw, struct it *ow);
typedef void FULLED (struct it *w);
typedef void SLIDE  (struct it *w, short hslp, short vslp, bool topw);
typedef void SLIDER (struct it *w);
typedef void ARROWD (struct it *w, short arrow, bool topw);
typedef void SIZED  (struct it *w, RECT *to);
typedef void MOVED  (struct it *w, RECT *to);
typedef void WINFO  (struct it *w);
typedef void BUTTON (struct it *w, short button, short kstate,
                                           short bclicks,
                                           short mx, short my);
typedef void KEYBD  (struct it *w, short kcode);
typedef void TIMER  (struct it *w);
typedef void CURSOR (struct it *w, CURST to);
typedef void WINIT  (struct it *w);
typedef void DEXIT  (struct it *w, short obno);
typedef bool WSELECT(struct it *w);
typedef bool EDIT	(struct it *w,short kcode);
typedef void MUIS   (struct it *w);
typedef bool DIALFI (struct it *w, char *zoek);
typedef void DIALREP (struct it *w);
typedef bool DRAG_SEL (struct it *w, short button, short kstate,
                                           short bclicks,
                                           short mx, short my);
typedef void CON_RET (struct it *w,char *line,short prompt,short curtask,short curstage);

#define DIALM	100		/* max for dialogue windows;
						   OBJECT number is dialogue windows type */
#define TEXTM   200		/* max for various text type windows */
#define WKSM    300		/* max for worksheet type windows */
#define GRAPHM  400		/* max for screen bitmaps */
#define OBJM    500		/* max for Digger */
#define BINM    600		/* max for binary files */

typedef enum
{
	BUFF = DIALM,
	JRNL,

	SRCE,
	SRC_C,
	SRC_H,
	SRC_A,
	SRC_S,
	SRC_P,

	CALC   = TEXTM,
	MAND   = WKSM,
	OBJ    = GRAPHM,
	BIN    = OBJM,		/* must be the last before anything thats like DROP */
	DMA    = OBJM+1,
	DROP   = 999		/* If MagX, fixed litle window for dropping things into.
				Very usefull when no other windows are open. */
} INFO_T;

typedef long STMNR;

typedef struct
{
	STMNR	nr;		/* sequence number (allways first) */
	char	*text;	/* data pointer    (allways second) */
	STMNR	un;		/* old sequence number at UNDO point */
	uchar   ty,		/* type of data in s->user (not used yet) */
			l,		/* length of info excl terminators */
			rem,	/* remainder of cell left for ch insertion */
			flags;	/* misc flags pe, is_modified */
} XSTM;

typedef struct
{
	STMNR      nr;			/* sequence number (allways first) */
	struct it *w;			/* data pointer    (allways second) */
} WSTM;

#define xn  user.txt.nr
#define xun user.txt.un
#define xty user.txt.ty
#define xl  user.txt.l
#define xrm user.txt.rem
#define xfg user.txt.flags
#define xtx user.txt.text
#define wit user.winfo.w

typedef struct stmcell
{
	struct stmcell *nx;
	struct stmcell *pr;
	union
	{
		XSTM	txt;
		WSTM    winfo;
	} user;
} STMC;

typedef struct
{
	bool st_guide,		/* if true, words must be preceded by '@' */
	     a68,			/* if true, display uppercase words in bold lower case */
	     upper;			/* if true, treat upper case as lower */
	char *match,
	     **tags,
	     **at  [26];
} BOLDCAT;

typedef struct
{
	uint magic,he;
	long limage,
	     lfixup,
	     lnames,
	     res0,
	     res1,
	     res2,
	     hekp;
} PC_H;

typedef struct
{
	uint magic;
	long ltext,			/* image if PC */
	     ldata,			/* fixup if PC */
	     lbss,			/* names if PC */
	     lsym,
	     res1,
	     res2;
	short  norelo;
} DRI_H;

typedef union
{
	PC_H pch;
	DRI_H drih;
} FHD;

#endif
