/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.formats.CartridgeBankedByMaskedRange;
import org.javatari.atari.cartridge.formats.CartridgeFormatOptionHinted;
import org.javatari.atari.controls.ConsoleControls;

public class Cartridge10K_DPC
extends CartridgeBankedByMaskedRange {
    private byte randomNumber = 0;
    private int[] fetcherPointer = new int[8];
    private byte[] fetcherStart = new byte[8];
    private byte[] fetcherEnd = new byte[8];
    private byte[] fetcherMask = new byte[8];
    private boolean[] audioMode = new boolean[8];
    private int audioClockDivider = 60;
    private int audioClockCounter = 0;
    protected boolean audioChanged = true;
    protected byte audioOutput = 0;
    private static final int AUDIO_CLOCK_DEFAULT_DIVIDER = 60;
    private static final byte[] AUDIO_MIXED_OUTPUT;
    protected static final int ROM_SIZE = 10240;
    protected static final int DPC_ROM_END = 10239;
    protected static final int SIZE_TOLERANCE = 256;
    protected static final int BASE_BANKSW_ADDRESS = 4088;
    public static final CartridgeFormat FORMAT;
    public static final long serialVersionUID = 1L;

    static {
        byte[] byArray = new byte[8];
        byArray[1] = 5;
        byArray[2] = 5;
        byArray[3] = 10;
        byArray[4] = 5;
        byArray[5] = 10;
        byArray[6] = 10;
        byArray[7] = 15;
        AUDIO_MIXED_OUTPUT = byArray;
        FORMAT = new CartridgeFormat("DPC", "10K DPC (Pitfall 2)"){
            private static final long serialVersionUID = 1L;

            @Override
            public Cartridge create(byte[] content, String contentName) {
                return new Cartridge10K_DPC(content, contentName, this);
            }

            @Override
            public CartridgeFormatOption getOption(byte[] content, String contentName) {
                if (content.length < 10240 || content.length > 10496) {
                    return null;
                }
                return new CartridgeFormatOptionHinted(101, this, contentName);
            }
        };
    }

    protected Cartridge10K_DPC(byte[] content, String contentName, CartridgeFormat format) {
        super(content, contentName, format, 4088, false, 0);
    }

    @Override
    public boolean needsClock() {
        return true;
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        if (this.maskedAddress <= 63 || this.maskedAddress >= 2048 && this.maskedAddress <= 2111) {
            return this.readDPCRegister(this.maskedAddress & 0xFF);
        }
        return this.bytes[this.bankAddressOffset + this.maskedAddress];
    }

    @Override
    public void writeByte(int address, byte b) {
        this.maskAddress(address);
        if (this.maskedAddress >= 64 && this.maskedAddress <= 127 || this.maskedAddress >= 2112 && this.maskedAddress <= 2175) {
            this.writeDPCRegister(this.maskedAddress & 0xFF, b);
        }
    }

    @Override
    public void clockPulse() {
        if (this.audioClockCounter-- > 0) {
            return;
        }
        this.audioClockCounter = this.audioClockDivider;
        int f = 5;
        while (f <= 7) {
            if (this.audioMode[f]) {
                int n = f;
                this.fetcherPointer[n] = this.fetcherPointer[n] - 1;
                if ((this.fetcherPointer[f] & 0xFF) == 255) {
                    this.setFetcherPointer(f, this.fetcherPointer[f] & 0xFF00 | this.fetcherStart[f]);
                }
                this.updateFetcherMask(f);
                if (!this.audioChanged) {
                    this.audioChanged = true;
                }
            }
            ++f;
        }
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, boolean state) {
        if (!state) {
            return;
        }
        switch (control) {
            case CARTRIDGE_CLOCK_DEC: {
                if (this.audioClockDivider < 150) {
                    ++this.audioClockDivider;
                }
                this.showClockOSD();
                break;
            }
            case CARTRIDGE_CLOCK_INC: {
                if (this.audioClockDivider > 1) {
                    --this.audioClockDivider;
                }
                this.showClockOSD();
            }
        }
    }

    private byte readDPCRegister(int reg) {
        if (reg >= 0 && reg <= 3) {
            this.clockRandomNumber();
            return this.randomNumber;
        }
        if (reg >= 4 && reg <= 7) {
            if (this.audioChanged) {
                this.updateAudioOutput();
            }
            return this.audioOutput;
        }
        if (reg >= 8 && reg <= 15) {
            byte res = this.bytes[10239 - this.fetcherPointer[reg - 8]];
            this.clockFetcher(reg - 8);
            return res;
        }
        if (reg >= 16 && reg <= 23) {
            byte res = (byte)(this.bytes[10239 - this.fetcherPointer[reg - 16]] & this.fetcherMask[reg - 16]);
            this.clockFetcher(reg - 16);
            return res;
        }
        if (reg >= 24 && reg <= 31) {
            byte res = (byte)(this.bytes[10239 - this.fetcherPointer[reg - 24]] & this.fetcherMask[reg - 24]);
            this.clockFetcher(reg - 24);
            res = (byte)(res & 0xF0 | res & 0xF);
            return res;
        }
        if (reg >= 32 && reg <= 39) {
            byte res = (byte)(this.bytes[10239 - this.fetcherPointer[reg - 32]] & this.fetcherMask[reg - 32]);
            this.clockFetcher(reg - 32);
            res = (byte)(Integer.reverse(res) >>> 24);
            return res;
        }
        if (reg >= 40 && reg <= 47) {
            byte res = (byte)(this.bytes[10239 - this.fetcherPointer[reg - 40]] & this.fetcherMask[reg - 40]);
            this.clockFetcher(reg - 40);
            res = (byte)((res >>> 1 | res << 7) & 0xFF);
            return res;
        }
        if (reg >= 48 && reg <= 55) {
            byte res = (byte)(this.bytes[10239 - this.fetcherPointer[reg - 48]] & this.fetcherMask[reg - 48]);
            this.clockFetcher(reg - 48);
            res = (byte)((res << 1 | res >> 7 & 1) & 0xFF);
            return res;
        }
        if (reg >= 56 && reg <= 63) {
            return this.fetcherMask[reg - 56];
        }
        return 0;
    }

    private void writeDPCRegister(int reg, byte b) {
        if (reg >= 64 && reg <= 71) {
            int f = reg - 64;
            this.fetcherStart[f] = b;
            if ((byte)(this.fetcherPointer[f] & 0xFF) == this.fetcherStart[f]) {
                this.fetcherMask[f] = -1;
            }
            return;
        }
        if (reg >= 72 && reg <= 79) {
            this.fetcherEnd[reg - 72] = b;
            this.fetcherMask[reg - 72] = 0;
            return;
        }
        if (reg >= 80 && reg <= 87) {
            this.setFetcherPointer(reg - 80, this.fetcherPointer[reg - 80] & 0xFF00 | b & 0xFF);
            return;
        }
        if (reg >= 88 && reg <= 91) {
            this.setFetcherPointer(reg - 88, this.fetcherPointer[reg - 88] & 0xFF | (b & 7) << 8);
            return;
        }
        if (reg == 92) {
            this.setFetcherPointer(4, this.fetcherPointer[4] & 0xFF | (b & 7) << 8);
            return;
        }
        if (reg >= 93 && reg <= 95) {
            this.setFetcherPointer(reg - 88, (this.fetcherPointer[reg - 88] & 0xFF) + ((b & 7) << 8));
            this.audioMode[reg - 88] = (b & 0x10) != 0;
            return;
        }
        if (reg >= 96 && reg <= 103) {
            return;
        }
        if (reg >= 112 && reg <= 119) {
            this.randomNumber = 0;
            return;
        }
    }

    private void setFetcherPointer(int f, int pointer) {
        this.fetcherPointer[f] = pointer;
    }

    private void clockFetcher(int f) {
        int newPointer = this.fetcherPointer[f] - 1;
        if (newPointer < 0) {
            newPointer = 2047;
        }
        this.setFetcherPointer(f, newPointer);
        this.updateFetcherMask(f);
    }

    private void updateFetcherMask(int f) {
        byte lsb = (byte)(this.fetcherPointer[f] & 0xFF);
        if (lsb == this.fetcherStart[f]) {
            this.fetcherMask[f] = -1;
        } else if (lsb == this.fetcherEnd[f]) {
            this.fetcherMask[f] = 0;
        }
    }

    private void clockRandomNumber() {
        this.randomNumber = (byte)(this.randomNumber << 1 | ~(this.randomNumber >> 7 ^ this.randomNumber >> 5 ^ this.randomNumber >> 4 ^ this.randomNumber >> 3) & 1);
        if (this.randomNumber == -1) {
            this.randomNumber = 0;
        }
    }

    protected void updateAudioOutput() {
        this.audioOutput = AUDIO_MIXED_OUTPUT[(this.audioMode[5] ? this.fetcherMask[5] & 4 : 0) | (this.audioMode[6] ? this.fetcherMask[6] & 2 : 0) | (this.audioMode[7] ? this.fetcherMask[7] & 1 : 0)];
        this.audioChanged = false;
    }

    private void showClockOSD() {
        this.bus.tia.videoOutput().showOSD(String.format("DPC Audio Clock: ~%.1f kHz", Float.valueOf(1194720.0f / (float)this.audioClockDivider / 1000.0f)), true);
    }

    @Override
    public Cartridge10K_DPC clone() {
        Cartridge10K_DPC clone = (Cartridge10K_DPC)super.clone();
        clone.fetcherPointer = (int[])this.fetcherPointer.clone();
        clone.fetcherStart = (byte[])this.fetcherStart.clone();
        clone.fetcherEnd = (byte[])this.fetcherEnd.clone();
        clone.fetcherMask = (byte[])this.fetcherMask.clone();
        clone.audioMode = (boolean[])this.audioMode.clone();
        return clone;
    }
}

