/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.formats.CartridgeBankedByBusMonitoring;
import org.javatari.atari.cartridge.formats.CartridgeFormatOptionHinted;

public class Cartridge8K_0840
extends CartridgeBankedByBusMonitoring {
    protected static final int BANK_SIZE = 4096;
    protected static final int SIZE = 8192;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("0840", "8K Econobanking"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge create(byte[] content, String contentName) {
            return new Cartridge8K_0840(content, contentName);
        }

        @Override
        public CartridgeFormatOption getOption(byte[] content, String contentName) {
            if (content.length != 8192) {
                return null;
            }
            return new CartridgeFormatOptionHinted(116, this, contentName);
        }
    };
    public static final long serialVersionUID = 1L;

    protected Cartridge8K_0840(byte[] content, String contentName) {
        super(content, contentName, FORMAT);
    }

    @Override
    protected void performBankSwitchOnMonitoredAccess(int address) {
        int addrBank = address & 0x1840;
        if (addrBank == 2048) {
            if (this.bankAddressOffset != 0) {
                this.bankAddressOffset = 0;
            }
        } else if (addrBank == 2112 && this.bankAddressOffset != 4096) {
            this.bankAddressOffset = 4096;
        }
    }
}

