/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.general.m6502.instructions;

import org.javatari.general.m6502.Instruction;
import org.javatari.general.m6502.M6502;

public final class STx
extends Instruction {
    private final int reg;
    private final int type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public STx(M6502 cpu, int reg, int type) {
        super(cpu);
        this.reg = reg;
        this.type = type;
    }

    @Override
    public int fetch() {
        if (this.type == 20) {
            this.ea = this.cpu.fetchZeroPageAddress();
            return 3;
        }
        if (this.type == 21) {
            this.ea = this.cpu.fetchZeroPageXAddress();
            return 4;
        }
        if (this.type == 22) {
            this.ea = this.cpu.fetchZeroPageYAddress();
            return 4;
        }
        if (this.type == 10) {
            this.ea = this.cpu.fetchAbsoluteAddress();
            return 4;
        }
        if (this.type == 11) {
            this.ea = this.cpu.fetchAbsoluteXAddress();
            return 5;
        }
        if (this.type == 12) {
            this.ea = this.cpu.fetchAbsoluteYAddress();
            return 5;
        }
        if (this.type == 31) {
            this.ea = this.cpu.fetchIndirectXAddress();
            return 6;
        }
        if (this.type == 32) {
            this.ea = this.cpu.fetchIndirectYAddress();
            return 6;
        }
        throw new IllegalStateException("STx Invalid Operand Type: " + this.type);
    }

    @Override
    public void execute() {
        if (this.reg == 0) {
            this.cpu.bus.writeByte(this.ea, this.cpu.A);
        } else if (this.reg == 5) {
            this.cpu.bus.writeByte(this.ea, this.cpu.X);
        } else if (this.reg == 6) {
            this.cpu.bus.writeByte(this.ea, this.cpu.Y);
        } else {
            throw new IllegalStateException("STx Invalid Register: " + this.reg);
        }
    }
}

