/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.parameters;

import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.javatari.utils.Terminator;

public final class Parameters {
    public static final String VERSION = "version 3.10";
    public static String mainArg = null;
    public static double TIA_FORCED_CLOCK = 0.0;
    public static boolean TIA_SYNC_WITH_AUDIO_MONITOR = false;
    public static boolean TIA_SYNC_WITH_VIDEO_MONITOR = false;
    public static int TIA_AUDIO_SAMPLE_RATE = 31430;
    public static float TIA_AUDIO_MAX_AMPLITUDE = 0.5f;
    public static double VIDEO_NTSC_FPS = 60.0;
    public static double VIDEO_PAL_FPS = 50.384615;
    public static int RAM_FRY_ZERO_BITS = 100;
    public static int RAM_FRY_ONE_BITS = 25;
    public static float RAM_FRY_VARIANCE = 0.3f;
    public static boolean BUS_DATA_RETENTION = true;
    public static int CONSOLE_FAST_SPEED_FACTOR = 8;
    public static double SCREEN_DEFAULT_FPS = -1.0;
    public static int SCREEN_DEFAULT_ORIGIN_X = 10;
    public static double SCREEN_DEFAULT_ORIGIN_Y_PCT = 12.0;
    public static int SCREEN_DEFAULT_WIDTH = 160;
    public static double SCREEN_DEFAULT_HEIGHT_PCT = 81.5;
    public static float SCREEN_DEFAULT_SCALE_X = 4.0f;
    public static float SCREEN_DEFAULT_SCALE_Y = 2.0f;
    public static float SCREEN_DEFAULT_SCALE_ASPECT_X = 2.0f;
    public static int SCREEN_BORDER_SIZE = 3;
    public static int SCREEN_OSD_FRAMES = 160;
    public static int SCREEN_VSYNC_TOLERANCE = 10;
    public static boolean SCREEN_QUALITY_RENDERING = false;
    public static int SCREEN_CRT_MODE = 0;
    public static float SCREEN_CRT_RETENTION_ALPHA = 0.75f;
    public static float SCREEN_SCANLINES_STRENGTH = 0.5f;
    public static int SCREEN_MULTI_BUFFERING = 2;
    public static boolean SCREEN_PAGE_FLIPPING = true;
    public static int SCREEN_BUFFER_VSYNC = -1;
    public static float SCREEN_FRAME_ACCELERATION = 0.0f;
    public static float SCREEN_INTERM_FRAME_ACCELERATION = -1.0f;
    public static float SCREEN_SCANLINES_ACCELERATION = -1.0f;
    public static boolean SCREEN_CARTRIDGE_CHANGE = true;
    public static boolean SCREEN_CONSOLE_PANEL = true;
    public static boolean SCREEN_FIXED_SIZE = false;
    public static boolean SCREEN_FULLSCREEN = false;
    public static double SPEAKER_DEFAULT_FPS = -1.0;
    public static int SPEAKER_INPUT_BUFFER_SIZE = 1536;
    public static int SPEAKER_OUTPUT_BUFFER_SIZE = 768;
    public static int SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME = 5;
    public static int SPEAKER_NO_DATA_SLEEP_TIME = 20;
    public static int SPEAKER_ADDED_THREAD_PRIORITY = 0;
    public static boolean MULTIPLAYER_UI = true;
    public static int SERVER_SERVICE_PORT = 9998;
    public static int SERVER_MAX_UPDATES_PENDING = 20;
    public static int CLIENT_MAX_UPDATES_PENDING = 20;
    public static int JOYSTICK_UPDATE_RATE = 120;
    public static String OFFICIAL_WEBSITE = "http://javatari.org";
    public static String TWITTER_WEBPAGE = "http://twitter.com/ppeccin";
    private static Properties props = new Properties();
    private static Preferences userPreferences;
    private static boolean userPreferencesAsked;
    public static final int DEFAULT_KEY_P0_LEFT = 37;
    public static final int DEFAULT_KEY_P0_UP = 38;
    public static final int DEFAULT_KEY_P0_RIGHT = 39;
    public static final int DEFAULT_KEY_P0_DOWN = 40;
    public static final int DEFAULT_KEY_P0_BUTTON = 32;
    public static final int DEFAULT_KEY_P0_BUTTON2 = 127;
    public static final int DEFAULT_KEY_P1_LEFT = 70;
    public static final int DEFAULT_KEY_P1_UP = 84;
    public static final int DEFAULT_KEY_P1_RIGHT = 72;
    public static final int DEFAULT_KEY_P1_DOWN = 71;
    public static final int DEFAULT_KEY_P1_BUTTON = 65;
    public static final int DEFAULT_KEY_P1_BUTTON2 = 46;
    public static final int CONTROL_UNSET = -1;
    public static final int JOY_DEVICE_NONE = -1;
    public static final int JOY_DEVICE_AUTO = -99;
    public static final int DEFAULT_JOY_P0_DEVICE = -99;
    public static final int DEFAULT_JOY_P1_DEVICE = -99;
    public static final int DEFAULT_JOY_XAXIS = 0;
    public static final int DEFAULT_JOY_YAXIS = 1;
    public static final int DEFAULT_JOY_PAD_AXIS = 0;
    public static final int DEFAULT_JOY_AXIS_SIGNAL = 1;
    public static final int DEFAULT_JOY_BUTTON = 0;
    public static final int DEFAULT_JOY_BUTTON2 = 1;
    public static final int DEFAULT_JOY_SELECT = 6;
    public static final int DEFAULT_JOY_RESET = 7;
    public static final int DEFAULT_JOY_FAST_SPPED = 4;
    public static final int DEFAULT_JOY_PAUSE = 5;
    public static final int DEFAULT_JOY_DEADZONE = 30;
    public static final int DEFAULT_JOY_PADDLE_CENTER = 30;
    public static final int DEFAULT_JOY_PADDLE_SENS = 45;
    public static int KEY_P0_LEFT;
    public static int KEY_P0_UP;
    public static int KEY_P0_RIGHT;
    public static int KEY_P0_DOWN;
    public static int KEY_P0_BUTTON;
    public static int KEY_P0_BUTTON2;
    public static int KEY_P1_LEFT;
    public static int KEY_P1_UP;
    public static int KEY_P1_RIGHT;
    public static int KEY_P1_DOWN;
    public static int KEY_P1_BUTTON;
    public static int KEY_P1_BUTTON2;
    public static int JOY_P0_DEVICE;
    public static int JOY_P0_XAXIS;
    public static int JOY_P0_XAXIS_SIGNAL;
    public static int JOY_P0_YAXIS;
    public static int JOY_P0_YAXIS_SIGNAL;
    public static int JOY_P0_PAD_AXIS;
    public static int JOY_P0_PAD_AXIS_SIGNAL;
    public static int JOY_P0_BUTTON;
    public static int JOY_P0_BUTTON2;
    public static int JOY_P0_SELECT;
    public static int JOY_P0_RESET;
    public static int JOY_P0_PAUSE;
    public static int JOY_P0_FAST_SPPED;
    public static int JOY_P0_DEADZONE;
    public static int JOY_P0_PADDLE_CENTER;
    public static int JOY_P0_PADDLE_SENS;
    public static int JOY_P1_DEVICE;
    public static int JOY_P1_XAXIS;
    public static int JOY_P1_XAXIS_SIGNAL;
    public static int JOY_P1_YAXIS;
    public static int JOY_P1_YAXIS_SIGNAL;
    public static int JOY_P1_PAD_AXIS;
    public static int JOY_P1_PAD_AXIS_SIGNAL;
    public static int JOY_P1_BUTTON;
    public static int JOY_P1_BUTTON2;
    public static int JOY_P1_SELECT;
    public static int JOY_P1_RESET;
    public static int JOY_P1_PAUSE;
    public static int JOY_P1_FAST_SPPED;
    public static int JOY_P1_DEADZONE;
    public static int JOY_P1_PADDLE_CENTER;
    public static int JOY_P1_PADDLE_SENS;
    public static String LAST_ROM_FILE_CHOSEN;
    public static String LAST_ROM_URL_CHOSEN;

    static {
        userPreferencesAsked = false;
        KEY_P0_LEFT = 37;
        KEY_P0_UP = 38;
        KEY_P0_RIGHT = 39;
        KEY_P0_DOWN = 40;
        KEY_P0_BUTTON = 32;
        KEY_P0_BUTTON2 = 127;
        KEY_P1_LEFT = 70;
        KEY_P1_UP = 84;
        KEY_P1_RIGHT = 72;
        KEY_P1_DOWN = 71;
        KEY_P1_BUTTON = 65;
        KEY_P1_BUTTON2 = 46;
        JOY_P0_DEVICE = -99;
        JOY_P0_XAXIS = 0;
        JOY_P0_XAXIS_SIGNAL = 1;
        JOY_P0_YAXIS = 1;
        JOY_P0_YAXIS_SIGNAL = 1;
        JOY_P0_PAD_AXIS = 0;
        JOY_P0_PAD_AXIS_SIGNAL = 1;
        JOY_P0_BUTTON = 0;
        JOY_P0_BUTTON2 = 1;
        JOY_P0_SELECT = 6;
        JOY_P0_RESET = 7;
        JOY_P0_PAUSE = 5;
        JOY_P0_FAST_SPPED = 4;
        JOY_P0_DEADZONE = 30;
        JOY_P0_PADDLE_CENTER = 30;
        JOY_P0_PADDLE_SENS = 45;
        JOY_P1_DEVICE = -99;
        JOY_P1_XAXIS = 0;
        JOY_P1_XAXIS_SIGNAL = 1;
        JOY_P1_YAXIS = 1;
        JOY_P1_YAXIS_SIGNAL = 1;
        JOY_P1_PAD_AXIS = 0;
        JOY_P1_PAD_AXIS_SIGNAL = 1;
        JOY_P1_BUTTON = 0;
        JOY_P1_BUTTON2 = 1;
        JOY_P1_SELECT = 6;
        JOY_P1_RESET = 7;
        JOY_P1_PAUSE = 5;
        JOY_P1_FAST_SPPED = 4;
        JOY_P1_DEADZONE = 30;
        JOY_P1_PADDLE_CENTER = 30;
        JOY_P1_PADDLE_SENS = 45;
        LAST_ROM_FILE_CHOSEN = "";
        LAST_ROM_URL_CHOSEN = "";
    }

    public static void init(String[] args) {
        Parameters.parseMainArg(args);
        Parameters.loadPropertiesFile();
        Parameters.parseOptions(args);
        Parameters.processProperties();
        Parameters.loadPreferences();
    }

    public static void setDefaultKeysPreferences() {
        KEY_P0_LEFT = 37;
        KEY_P0_UP = 38;
        KEY_P0_RIGHT = 39;
        KEY_P0_DOWN = 40;
        KEY_P0_BUTTON = 32;
        KEY_P0_BUTTON2 = 127;
        KEY_P1_LEFT = 70;
        KEY_P1_UP = 84;
        KEY_P1_RIGHT = 72;
        KEY_P1_DOWN = 71;
        KEY_P1_BUTTON = 65;
        KEY_P1_BUTTON2 = 46;
    }

    public static void setDefaultJoystickPreferences() {
        JOY_P0_DEVICE = -99;
        JOY_P0_XAXIS = 0;
        JOY_P0_XAXIS_SIGNAL = 1;
        JOY_P0_YAXIS = 1;
        JOY_P0_YAXIS_SIGNAL = 1;
        JOY_P0_PAD_AXIS = 0;
        JOY_P0_PAD_AXIS_SIGNAL = 1;
        JOY_P0_BUTTON = 0;
        JOY_P0_BUTTON2 = 1;
        JOY_P0_SELECT = 6;
        JOY_P0_RESET = 7;
        JOY_P0_PAUSE = 5;
        JOY_P0_FAST_SPPED = 4;
        JOY_P0_DEADZONE = 30;
        JOY_P0_PADDLE_CENTER = 30;
        JOY_P0_PADDLE_SENS = 45;
        JOY_P1_DEVICE = -99;
        JOY_P1_XAXIS = 0;
        JOY_P1_XAXIS_SIGNAL = 1;
        JOY_P1_YAXIS = 1;
        JOY_P1_YAXIS_SIGNAL = 1;
        JOY_P1_PAD_AXIS = 0;
        JOY_P1_PAD_AXIS_SIGNAL = 1;
        JOY_P1_BUTTON = 0;
        JOY_P1_BUTTON2 = 1;
        JOY_P1_SELECT = 6;
        JOY_P1_RESET = 7;
        JOY_P1_PAUSE = 5;
        JOY_P1_FAST_SPPED = 4;
        JOY_P1_DEADZONE = 30;
        JOY_P1_PADDLE_CENTER = 30;
        JOY_P1_PADDLE_SENS = 45;
    }

    private static void parseMainArg(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (!arg.startsWith("-")) {
                mainArg = arg;
                return;
            }
            ++n2;
        }
    }

    private static void parseOptions(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("-")) {
                String opt = arg.substring(1);
                Pattern p = Pattern.compile("=");
                String[] params = p.split(opt);
                if (params == null || params.length != 2 || params[0].isEmpty() || params[1].isEmpty()) {
                    System.out.println("Invalid option format: " + arg);
                    Terminator.terminate();
                }
                props.put(params[0].toUpperCase(), params[1]);
            }
            ++n2;
        }
    }

    private static void loadPropertiesFile() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/javatari/parameters/javatari.properties");
        try {
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (Exception ex) {
            System.out.println("parameters/javatari.properties not found, using defaults");
        }
        try {
            props.putAll((Map<?, ?>)System.getProperties());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private static void loadPreferences() {
        Parameters.setDefaultJoystickPreferences();
        Preferences prefs = Parameters.getUserPreferences();
        if (prefs == null) {
            return;
        }
        try {
            String val = prefs.get("keyP0Left", null);
            if (val != null) {
                KEY_P0_LEFT = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP0Up", null)) != null) {
                KEY_P0_UP = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP0Right", null)) != null) {
                KEY_P0_RIGHT = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP0Down", null)) != null) {
                KEY_P0_DOWN = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP0Button", null)) != null) {
                KEY_P0_BUTTON = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP0Button2", null)) != null) {
                KEY_P0_BUTTON2 = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Left", null)) != null) {
                KEY_P1_LEFT = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Up", null)) != null) {
                KEY_P1_UP = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Right", null)) != null) {
                KEY_P1_RIGHT = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Down", null)) != null) {
                KEY_P1_DOWN = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Button", null)) != null) {
                KEY_P1_BUTTON = Integer.parseInt(val);
            }
            if ((val = prefs.get("keyP1Button2", null)) != null) {
                KEY_P1_BUTTON2 = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0Device", null)) != null) {
                JOY_P0_DEVICE = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0XAxis", null)) != null) {
                JOY_P0_XAXIS = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0XAxisSignal", null)) != null) {
                JOY_P0_XAXIS_SIGNAL = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0YAxis", null)) != null) {
                JOY_P0_YAXIS = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0YAxisSignal", null)) != null) {
                JOY_P0_YAXIS_SIGNAL = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0Button", null)) != null) {
                JOY_P0_BUTTON = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0Button2", null)) != null) {
                JOY_P0_BUTTON2 = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0Reset", null)) != null) {
                JOY_P0_RESET = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0Select", null)) != null) {
                JOY_P0_SELECT = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0Pause", null)) != null) {
                JOY_P0_PAUSE = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0FastSpeed", null)) != null) {
                JOY_P0_FAST_SPPED = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0Deadzone", null)) != null) {
                JOY_P0_DEADZONE = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0PaddleCenter", null)) != null) {
                JOY_P0_PADDLE_CENTER = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP0PaddleSens", null)) != null) {
                JOY_P0_PADDLE_SENS = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1Device", null)) != null) {
                JOY_P1_DEVICE = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1XAxis", null)) != null) {
                JOY_P1_XAXIS = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1XAxisSignal", null)) != null) {
                JOY_P1_XAXIS_SIGNAL = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1YAxis", null)) != null) {
                JOY_P1_YAXIS = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1YAxisSignal", null)) != null) {
                JOY_P1_YAXIS_SIGNAL = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1Button", null)) != null) {
                JOY_P1_BUTTON = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1Button2", null)) != null) {
                JOY_P1_BUTTON2 = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1Reset", null)) != null) {
                JOY_P1_RESET = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1Select", null)) != null) {
                JOY_P1_SELECT = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1Pause", null)) != null) {
                JOY_P1_PAUSE = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1FastSpeed", null)) != null) {
                JOY_P1_FAST_SPPED = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1Deadzone", null)) != null) {
                JOY_P1_DEADZONE = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1PaddleCenter", null)) != null) {
                JOY_P1_PADDLE_CENTER = Integer.parseInt(val);
            }
            if ((val = prefs.get("joyP1PaddleSens", null)) != null) {
                JOY_P1_PADDLE_SENS = Integer.parseInt(val);
            }
            if ((val = prefs.get("lastROMFileChosen", null)) != null) {
                LAST_ROM_FILE_CHOSEN = val;
            }
            if ((val = prefs.get("lastROMURLChosen", null)) != null) {
                LAST_ROM_URL_CHOSEN = val;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void savePreferences() {
        Preferences prefs = Parameters.getUserPreferences();
        if (prefs == null) {
            return;
        }
        try {
            prefs.put("keyP0Left", String.valueOf(KEY_P0_LEFT));
            prefs.put("keyP0Up", String.valueOf(KEY_P0_UP));
            prefs.put("keyP0Right", String.valueOf(KEY_P0_RIGHT));
            prefs.put("keyP0Down", String.valueOf(KEY_P0_DOWN));
            prefs.put("keyP0Button", String.valueOf(KEY_P0_BUTTON));
            prefs.put("keyP0Button2", String.valueOf(KEY_P0_BUTTON2));
            prefs.put("keyP1Left", String.valueOf(KEY_P1_LEFT));
            prefs.put("keyP1Up", String.valueOf(KEY_P1_UP));
            prefs.put("keyP1Right", String.valueOf(KEY_P1_RIGHT));
            prefs.put("keyP1Down", String.valueOf(KEY_P1_DOWN));
            prefs.put("keyP1Button", String.valueOf(KEY_P1_BUTTON));
            prefs.put("keyP1Button2", String.valueOf(KEY_P1_BUTTON2));
            prefs.put("joyP0Device", String.valueOf(JOY_P0_DEVICE));
            prefs.put("joyP0XAxis", String.valueOf(JOY_P0_XAXIS));
            prefs.put("joyP0XAxisSignal", String.valueOf(JOY_P0_XAXIS_SIGNAL));
            prefs.put("joyP0YAxis", String.valueOf(JOY_P0_YAXIS));
            prefs.put("joyP0YAxisSignal", String.valueOf(JOY_P0_YAXIS_SIGNAL));
            prefs.put("joyP0PaddleAxis", String.valueOf(JOY_P0_PAD_AXIS));
            prefs.put("joyP0PaddleAxisSignal", String.valueOf(JOY_P0_PAD_AXIS_SIGNAL));
            prefs.put("joyP0Button", String.valueOf(JOY_P0_BUTTON));
            prefs.put("joyP0Button2", String.valueOf(JOY_P0_BUTTON2));
            prefs.put("joyP0Reset", String.valueOf(JOY_P0_RESET));
            prefs.put("joyP0Select", String.valueOf(JOY_P0_SELECT));
            prefs.put("joyP0Pause", String.valueOf(JOY_P0_PAUSE));
            prefs.put("joyP0FastSpeed", String.valueOf(JOY_P0_FAST_SPPED));
            prefs.put("joyP0Deadzone", String.valueOf(JOY_P0_DEADZONE));
            prefs.put("joyP0PaddleCenter", String.valueOf(JOY_P0_PADDLE_CENTER));
            prefs.put("joyP0PaddleSens", String.valueOf(JOY_P0_PADDLE_SENS));
            prefs.put("joyP1Device", String.valueOf(JOY_P1_DEVICE));
            prefs.put("joyP1XAxis", String.valueOf(JOY_P1_XAXIS));
            prefs.put("joyP1XAxisSignal", String.valueOf(JOY_P1_XAXIS_SIGNAL));
            prefs.put("joyP1YAxis", String.valueOf(JOY_P1_YAXIS));
            prefs.put("joyP10YAxisSignal", String.valueOf(JOY_P1_YAXIS_SIGNAL));
            prefs.put("joyP1PaddleAxis", String.valueOf(JOY_P1_PAD_AXIS));
            prefs.put("joyP1PaddleAxisSignal", String.valueOf(JOY_P1_PAD_AXIS_SIGNAL));
            prefs.put("joyP1Button", String.valueOf(JOY_P1_BUTTON));
            prefs.put("joyP1Button2", String.valueOf(JOY_P1_BUTTON2));
            prefs.put("joyP1Reset", String.valueOf(JOY_P1_RESET));
            prefs.put("joyP1Select", String.valueOf(JOY_P1_SELECT));
            prefs.put("joyP1Pause", String.valueOf(JOY_P1_PAUSE));
            prefs.put("joyP1FastSpeed", String.valueOf(JOY_P1_FAST_SPPED));
            prefs.put("joyP1Deadzone", String.valueOf(JOY_P1_DEADZONE));
            prefs.put("joyP1PaddleCenter", String.valueOf(JOY_P1_PADDLE_CENTER));
            prefs.put("joyP1PaddleSens", String.valueOf(JOY_P1_PADDLE_SENS));
            prefs.put("lastROMFileChosen", LAST_ROM_FILE_CHOSEN);
            prefs.put("lastROMURLChosen", LAST_ROM_URL_CHOSEN);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Preferences getUserPreferences() {
        if (!userPreferencesAsked) {
            try {
                userPreferencesAsked = true;
                userPreferences = Preferences.userRoot().node("javatari");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return userPreferences;
    }

    private static void processProperties() {
        try {
            String val = props.getProperty("TIA_FORCED_CLOCK");
            if (val != null) {
                TIA_FORCED_CLOCK = Double.valueOf(val);
            }
            if ((val = props.getProperty("TIA_SYNC_WITH_AUDIO_MONITOR")) != null) {
                TIA_SYNC_WITH_AUDIO_MONITOR = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("TIA_SYNC_WITH_VIDEO_MONITOR")) != null) {
                TIA_SYNC_WITH_VIDEO_MONITOR = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("VIDEO_NTSC_FPS")) != null) {
                VIDEO_NTSC_FPS = Double.valueOf(val);
            }
            if ((val = props.getProperty("VIDEO_PAL_FPS")) != null) {
                VIDEO_PAL_FPS = Double.valueOf(val);
            }
            if ((val = props.getProperty("TIA_AUDIO_SAMPLE_RATE")) != null) {
                TIA_AUDIO_SAMPLE_RATE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("TIA_AUDIO_MAX_AMPLITUDE")) != null) {
                TIA_AUDIO_MAX_AMPLITUDE = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("RAM_FRY_ZERO_BITS")) != null) {
                RAM_FRY_ZERO_BITS = Integer.valueOf(val);
            }
            if ((val = props.getProperty("RAM_FRY_ONE_BITS")) != null) {
                RAM_FRY_ONE_BITS = Integer.valueOf(val);
            }
            if ((val = props.getProperty("RAM_FRY_VARIANCE")) != null) {
                RAM_FRY_VARIANCE = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("BUS_DATA_RETENTION")) != null) {
                BUS_DATA_RETENTION = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("CONSOLE_FAST_SPEED_FACTOR")) != null) {
                CONSOLE_FAST_SPEED_FACTOR = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_FPS")) != null) {
                SCREEN_DEFAULT_FPS = Double.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_ORIGIN_X")) != null) {
                SCREEN_DEFAULT_ORIGIN_X = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_ORIGIN_Y_PCT")) != null) {
                SCREEN_DEFAULT_ORIGIN_Y_PCT = Double.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_WIDTH")) != null) {
                SCREEN_DEFAULT_WIDTH = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_HEIGHT_PCT")) != null) {
                SCREEN_DEFAULT_HEIGHT_PCT = Double.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_SCALE_X")) != null) {
                SCREEN_DEFAULT_SCALE_X = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_SCALE_Y")) != null) {
                SCREEN_DEFAULT_SCALE_Y = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_SCALE_ASPECT_X")) != null) {
                SCREEN_DEFAULT_SCALE_ASPECT_X = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_BORDER_SIZE")) != null) {
                SCREEN_BORDER_SIZE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_OSD_FRAMES")) != null) {
                SCREEN_OSD_FRAMES = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_VSYNC_TOLERANCE")) != null) {
                SCREEN_VSYNC_TOLERANCE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_QUALITY_RENDERING")) != null) {
                SCREEN_QUALITY_RENDERING = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_CRT_MODE")) != null) {
                SCREEN_CRT_MODE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_CRT_RETENTION_ALPHA")) != null) {
                SCREEN_CRT_RETENTION_ALPHA = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_SCANLINES_STRENGTH")) != null) {
                SCREEN_SCANLINES_STRENGTH = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_MULTI_BUFFERING")) != null) {
                SCREEN_MULTI_BUFFERING = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_PAGE_FLIPPING")) != null) {
                SCREEN_PAGE_FLIPPING = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_BUFFER_VSYNC")) != null) {
                SCREEN_BUFFER_VSYNC = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_FRAME_ACCELERATION")) != null) {
                SCREEN_FRAME_ACCELERATION = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_INTERM_FRAME_ACCELERATION")) != null) {
                SCREEN_INTERM_FRAME_ACCELERATION = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_SCANLINES_ACCELERATION")) != null) {
                SCREEN_SCANLINES_ACCELERATION = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_CARTRIDGE_CHANGE")) != null) {
                SCREEN_CARTRIDGE_CHANGE = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_CONSOLE_PANEL")) != null) {
                SCREEN_CONSOLE_PANEL = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_FIXED_SIZE")) != null) {
                SCREEN_FIXED_SIZE = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_FULLSCREEN")) != null) {
                SCREEN_FULLSCREEN = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_DEFAULT_FPS")) != null) {
                SPEAKER_DEFAULT_FPS = Double.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_INPUT_BUFFER_SIZE")) != null) {
                SPEAKER_INPUT_BUFFER_SIZE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_OUTPUT_BUFFER_SIZE")) != null) {
                SPEAKER_OUTPUT_BUFFER_SIZE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME")) != null) {
                SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_NO_DATA_SLEEP_TIME")) != null) {
                SPEAKER_NO_DATA_SLEEP_TIME = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_ADDED_THREAD_PRIORITY")) != null) {
                SPEAKER_ADDED_THREAD_PRIORITY = Integer.valueOf(val);
            }
            if ((val = props.getProperty("MULTIPLAYER_UI")) != null) {
                MULTIPLAYER_UI = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SERVER_SERVICE_PORT")) != null) {
                SERVER_SERVICE_PORT = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SERVER_MAX_UPDATES_PENDING")) != null) {
                SERVER_MAX_UPDATES_PENDING = Integer.valueOf(val);
            }
            if ((val = props.getProperty("CLIENT_MAX_UPDATES_PENDING")) != null) {
                CLIENT_MAX_UPDATES_PENDING = Integer.valueOf(val);
            }
            if ((val = props.getProperty("JOYSTICK_UPDATE_RATE")) != null) {
                JOYSTICK_UPDATE_RATE = Integer.valueOf(val);
            }
        }
        catch (Exception ex) {
            System.out.println("Error processing properties:\n" + ex);
            Terminator.terminate();
        }
    }
}

