/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.controls;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import org.javatari.atari.controls.ConsoleControls;
import org.javatari.atari.controls.ConsoleControlsInput;
import org.javatari.general.av.video.VideoMonitor;
import org.javatari.parameters.Parameters;
import org.javatari.pc.controls.JoystickConsoleControls;
import org.javatari.utils.KeyFilteredRepeatsAdapter;

public final class AWTConsoleControls
extends KeyFilteredRepeatsAdapter
implements ConsoleControls {
    public boolean p1ControlsMode = false;
    public boolean paddleMode = false;
    private ConsoleControlsInput consoleControlsInput;
    private final VideoMonitor videoMonitor;
    private final JoystickConsoleControls joystickControls;
    private int paddle0Position = 0;
    private int paddle0Speed = 2;
    private boolean paddle0MovingLeft = false;
    private boolean paddle0MovingRight = false;
    private int paddle1Position = 0;
    private int paddle1Speed = 2;
    private boolean paddle1MovingLeft = false;
    private boolean paddle1MovingRight = false;
    private PaddlesPositionUpdater paddlePositionUpdater;
    private final Map<Integer, ConsoleControls.Control> joysticksCodeMap = new HashMap<Integer, ConsoleControls.Control>();
    private final Map<Integer, ConsoleControls.Control> normalCodeMap = new HashMap<Integer, ConsoleControls.Control>();
    private final Map<Integer, ConsoleControls.Control> withCTRLCodeMap = new HashMap<Integer, ConsoleControls.Control>();
    private final Map<Integer, ConsoleControls.Control> withALTCodeMap = new HashMap<Integer, ConsoleControls.Control>();
    private final Map<ConsoleControls.Control, Boolean> controlStateMap = new HashMap<ConsoleControls.Control, Boolean>();
    public static final int KEY_TOGGLE_JOYSTICK = 74;
    public static final int KEY_TOGGLE_P1_MODE = 75;
    public static final int KEY_TOGGLE_PADDLE = 76;
    public static final int KEY_CARTRIDGE_FORMAT = 66;
    public static final int KEY_SELECT = 122;
    public static final int KEY_RESET = 123;
    public static final int KEY_FAST_SPEED = 9;
    public static final int KEY_PAUSE = 80;
    private static final int KEY_POWER = 112;
    private static final int KEY_BLACK_WHITE = 113;
    private static final int KEY_DIFFICULTY0 = 115;
    private static final int KEY_DIFFICULTY1 = 120;
    private static final int KEY_FRAME = 70;
    private static final int KEY_TRACE = 84;
    private static final int KEY_DEBUG = 68;
    private static final int KEY_NO_COLLISIONS = 67;
    private static final int KEY_VIDEO_STANDARD = 86;
    private static final int KEY_STATE_0 = 222;
    private static final int KEY_STATE_1 = 49;
    private static final int KEY_STATE_2 = 50;
    private static final int KEY_STATE_3 = 51;
    private static final int KEY_STATE_4 = 52;
    private static final int KEY_STATE_5 = 53;
    private static final int KEY_STATE_6 = 54;
    private static final int KEY_STATE_7 = 55;
    private static final int KEY_STATE_8 = 56;
    private static final int KEY_STATE_9 = 57;
    private static final int KEY_STATE_10 = 48;
    private static final int KEY_STATE_11 = 45;
    private static final int KEY_STATE_12 = 61;
    private static final int KEY_CARTRIDGE_CLOCK_DEC = 35;
    private static final int KEY_CARTRIDGE_CLOCK_INC = 36;

    public AWTConsoleControls(VideoMonitor monitor) {
        this.videoMonitor = monitor;
        this.joystickControls = new JoystickConsoleControls(monitor, this);
        this.initKeys();
    }

    public void connect(ConsoleControlsInput input) {
        this.consoleControlsInput = input;
        this.joystickControls.connect(input);
    }

    public void addInputComponents(Component ... inputs) {
        int i = 0;
        while (i < inputs.length) {
            inputs[i].setFocusTraversalKeysEnabled(false);
            inputs[i].addKeyListener(this);
            ++i;
        }
    }

    public void powerOn() {
        this.joystickControls.powerOn();
    }

    public void powerOff() {
        this.joystickControls.powerOff();
    }

    public void toggleP1ControlsMode() {
        this.p1ControlsMode(!this.p1ControlsMode);
        this.showModeOSD();
    }

    public void p1ControlsMode(boolean state) {
        this.p1ControlsMode = state;
        this.initPreferences();
    }

    public void togglePaddleMode() {
        this.paddleMode = !this.paddleMode;
        this.paddle1MovingRight = false;
        this.paddle1MovingLeft = false;
        this.paddle0MovingRight = false;
        this.paddle0MovingLeft = false;
        this.paddle1Speed = 2;
        this.paddle0Speed = 2;
        this.paddle1Position = this.paddleMode ? 190 : -1;
        this.paddle0Position = this.paddle1Position;
        ConsoleControls.Control[] controlArray = playerDigitalControls;
        int n = playerDigitalControls.length;
        int n2 = 0;
        while (n2 < n) {
            ConsoleControls.Control control = controlArray[n2];
            this.consoleControlsInput.controlStateChanged(control, false);
            ++n2;
        }
        this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE0_POSITION, this.paddle0Position);
        this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE1_POSITION, this.paddle1Position);
        this.joystickControls.paddleMode(this.paddleMode);
        this.showModeOSD();
        if (this.paddleMode) {
            this.paddlesUpdateActive();
        } else {
            this.paddlesUpdateInactive();
        }
    }

    public JoystickConsoleControls joystickControls() {
        return this.joystickControls;
    }

    @Override
    public void filteredKeyPressed(KeyEvent e) {
        this.processKeyEvent(e.getKeyCode(), e.getModifiersEx(), true);
    }

    @Override
    public void filteredKeyReleased(KeyEvent e) {
        this.processKeyEvent(e.getKeyCode(), e.getModifiersEx(), false);
    }

    public void processKeyEvent(int keyCode, int modifiers, boolean press) {
        Boolean state;
        if (this.checkLocalControlKey(keyCode, modifiers, press)) {
            return;
        }
        ConsoleControls.Control control = this.controlForEvent(keyCode, modifiers);
        if (control == null) {
            return;
        }
        if (this.paddleMode) {
            control = this.translatePaddleModeButtons(control);
        }
        if ((state = this.controlStateMap.get((Object)control)) == null || state != press) {
            this.controlStateMap.put(control, press);
            this.consoleControlsInput.controlStateChanged(control, press);
        }
    }

    private void showModeOSD() {
        this.videoMonitor.showOSD("Controllers: " + (this.paddleMode ? "Paddles" : "Joysticks") + (this.p1ControlsMode ? ", Swapped" : ""), true);
    }

    private boolean checkLocalControlKey(int keyCode, int modif, boolean press) {
        if (press) {
            if (modif == 512) {
                switch (keyCode) {
                    case 75: {
                        this.toggleP1ControlsMode();
                        return true;
                    }
                    case 74: {
                        this.joystickControls.toggleMode();
                        return true;
                    }
                    case 76: {
                        this.togglePaddleMode();
                        return true;
                    }
                }
            }
            if (this.paddleMode) {
                ConsoleControls.Control control = this.controlForEvent(keyCode, modif);
                if (control == null) {
                    return false;
                }
                switch (control) {
                    case JOY0_LEFT: {
                        this.paddle0MovingLeft = true;
                        return true;
                    }
                    case JOY0_RIGHT: {
                        this.paddle0MovingRight = true;
                        return true;
                    }
                    case JOY0_UP: {
                        if (this.paddle0Speed < 10) {
                            ++this.paddle0Speed;
                        }
                        this.videoMonitor.showOSD("P1 Paddle speed: " + this.paddle0Speed, true);
                        return true;
                    }
                    case JOY0_DOWN: {
                        if (this.paddle0Speed > 1) {
                            --this.paddle0Speed;
                        }
                        this.videoMonitor.showOSD("P1 Paddle speed: " + this.paddle0Speed, true);
                        return true;
                    }
                    case JOY1_LEFT: {
                        this.paddle1MovingLeft = true;
                        return true;
                    }
                    case JOY1_RIGHT: {
                        this.paddle1MovingRight = true;
                        return true;
                    }
                    case JOY1_UP: {
                        if (this.paddle1Speed < 10) {
                            ++this.paddle1Speed;
                        }
                        this.videoMonitor.showOSD("P2 Paddle speed: " + this.paddle1Speed, true);
                        return true;
                    }
                    case JOY1_DOWN: {
                        if (this.paddle1Speed > 1) {
                            --this.paddle1Speed;
                        }
                        this.videoMonitor.showOSD("P2 Paddle speed: " + this.paddle1Speed, true);
                        return true;
                    }
                }
            }
        } else if (this.paddleMode) {
            ConsoleControls.Control control = this.controlForEvent(keyCode, modif);
            if (control == null) {
                return false;
            }
            switch (control) {
                case JOY0_LEFT: {
                    this.paddle0MovingLeft = false;
                    return true;
                }
                case JOY0_RIGHT: {
                    this.paddle0MovingRight = false;
                    return true;
                }
                case JOY1_LEFT: {
                    this.paddle1MovingLeft = false;
                    return true;
                }
                case JOY1_RIGHT: {
                    this.paddle1MovingRight = false;
                    return true;
                }
            }
        }
        return false;
    }

    private ConsoleControls.Control controlForEvent(int keyCode, int modif) {
        switch (modif) {
            case 0: {
                ConsoleControls.Control joy = this.joysticksCodeMap.get(keyCode);
                if (joy != null) {
                    return joy;
                }
                return this.normalCodeMap.get(keyCode);
            }
            case 128: {
                return this.withCTRLCodeMap.get(keyCode);
            }
            case 512: {
                return this.withALTCodeMap.get(keyCode);
            }
        }
        return null;
    }

    private ConsoleControls.Control translatePaddleModeButtons(ConsoleControls.Control control) {
        switch (control) {
            case JOY0_BUTTON: {
                return ConsoleControls.Control.PADDLE0_BUTTON;
            }
            case JOY1_BUTTON: {
                return ConsoleControls.Control.PADDLE1_BUTTON;
            }
        }
        return control;
    }

    private void paddlesUpdatePosition() {
        if (this.paddle0MovingRight) {
            if (!this.paddle0MovingLeft) {
                this.paddle0Position -= this.paddle0Speed;
                if (this.paddle0Position < 0) {
                    this.paddle0Position = 0;
                }
                this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE0_POSITION, this.paddle0Position);
            }
        } else if (this.paddle0MovingLeft) {
            this.paddle0Position += this.paddle0Speed;
            if (this.paddle0Position > 380) {
                this.paddle0Position = 380;
            }
            this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE0_POSITION, this.paddle0Position);
        }
        if (this.paddle1MovingRight) {
            if (!this.paddle1MovingLeft) {
                this.paddle1Position -= this.paddle1Speed;
                if (this.paddle1Position < 0) {
                    this.paddle1Position = 0;
                }
                this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE1_POSITION, this.paddle1Position);
            }
        } else if (this.paddle1MovingLeft) {
            this.paddle1Position += this.paddle1Speed;
            if (this.paddle1Position > 380) {
                this.paddle1Position = 380;
            }
            this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE1_POSITION, this.paddle1Position);
        }
    }

    private void paddlesUpdateActive() {
        if (this.paddlePositionUpdater != null && this.paddlePositionUpdater.isAlive()) {
            return;
        }
        this.paddlePositionUpdater = new PaddlesPositionUpdater();
        this.paddlePositionUpdater.start();
    }

    private void paddlesUpdateInactive() {
        if (this.paddlePositionUpdater == null) {
            return;
        }
        if (this.paddlePositionUpdater.isAlive()) {
            try {
                this.paddlePositionUpdater.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.paddlePositionUpdater = null;
    }

    private void initKeys() {
        this.initPreferences();
        this.normalCodeMap.put(112, ConsoleControls.Control.POWER);
        this.normalCodeMap.put(113, ConsoleControls.Control.BLACK_WHITE);
        this.normalCodeMap.put(115, ConsoleControls.Control.DIFFICULTY0);
        this.normalCodeMap.put(120, ConsoleControls.Control.DIFFICULTY1);
        this.normalCodeMap.put(122, ConsoleControls.Control.SELECT);
        this.normalCodeMap.put(123, ConsoleControls.Control.RESET);
        this.normalCodeMap.put(9, ConsoleControls.Control.FAST_SPEED);
        this.withALTCodeMap.put(112, ConsoleControls.Control.POWER_FRY);
        this.withALTCodeMap.put(80, ConsoleControls.Control.PAUSE);
        this.withALTCodeMap.put(70, ConsoleControls.Control.FRAME);
        this.withALTCodeMap.put(84, ConsoleControls.Control.TRACE);
        this.withALTCodeMap.put(68, ConsoleControls.Control.DEBUG);
        this.withALTCodeMap.put(67, ConsoleControls.Control.NO_COLLISIONS);
        this.withALTCodeMap.put(86, ConsoleControls.Control.VIDEO_STANDARD);
        this.withCTRLCodeMap.put(222, ConsoleControls.Control.SAVE_STATE_0);
        this.withCTRLCodeMap.put(49, ConsoleControls.Control.SAVE_STATE_1);
        this.withCTRLCodeMap.put(50, ConsoleControls.Control.SAVE_STATE_2);
        this.withCTRLCodeMap.put(51, ConsoleControls.Control.SAVE_STATE_3);
        this.withCTRLCodeMap.put(52, ConsoleControls.Control.SAVE_STATE_4);
        this.withCTRLCodeMap.put(53, ConsoleControls.Control.SAVE_STATE_5);
        this.withCTRLCodeMap.put(54, ConsoleControls.Control.SAVE_STATE_6);
        this.withCTRLCodeMap.put(55, ConsoleControls.Control.SAVE_STATE_7);
        this.withCTRLCodeMap.put(56, ConsoleControls.Control.SAVE_STATE_8);
        this.withCTRLCodeMap.put(57, ConsoleControls.Control.SAVE_STATE_9);
        this.withCTRLCodeMap.put(48, ConsoleControls.Control.SAVE_STATE_10);
        this.withCTRLCodeMap.put(45, ConsoleControls.Control.SAVE_STATE_11);
        this.withCTRLCodeMap.put(61, ConsoleControls.Control.SAVE_STATE_12);
        this.withALTCodeMap.put(222, ConsoleControls.Control.LOAD_STATE_0);
        this.withALTCodeMap.put(49, ConsoleControls.Control.LOAD_STATE_1);
        this.withALTCodeMap.put(50, ConsoleControls.Control.LOAD_STATE_2);
        this.withALTCodeMap.put(51, ConsoleControls.Control.LOAD_STATE_3);
        this.withALTCodeMap.put(52, ConsoleControls.Control.LOAD_STATE_4);
        this.withALTCodeMap.put(53, ConsoleControls.Control.LOAD_STATE_5);
        this.withALTCodeMap.put(54, ConsoleControls.Control.LOAD_STATE_6);
        this.withALTCodeMap.put(55, ConsoleControls.Control.LOAD_STATE_7);
        this.withALTCodeMap.put(56, ConsoleControls.Control.LOAD_STATE_8);
        this.withALTCodeMap.put(57, ConsoleControls.Control.LOAD_STATE_9);
        this.withALTCodeMap.put(48, ConsoleControls.Control.LOAD_STATE_10);
        this.withALTCodeMap.put(45, ConsoleControls.Control.LOAD_STATE_11);
        this.withALTCodeMap.put(61, ConsoleControls.Control.LOAD_STATE_12);
        this.withALTCodeMap.put(66, ConsoleControls.Control.CARTRIDGE_FORMAT);
        this.withALTCodeMap.put(35, ConsoleControls.Control.CARTRIDGE_CLOCK_DEC);
        this.withALTCodeMap.put(36, ConsoleControls.Control.CARTRIDGE_CLOCK_INC);
    }

    public void initPreferences() {
        this.joysticksCodeMap.clear();
        if (!this.p1ControlsMode) {
            this.joysticksCodeMap.put(Parameters.KEY_P0_LEFT, ConsoleControls.Control.JOY0_LEFT);
            this.joysticksCodeMap.put(Parameters.KEY_P0_UP, ConsoleControls.Control.JOY0_UP);
            this.joysticksCodeMap.put(Parameters.KEY_P0_RIGHT, ConsoleControls.Control.JOY0_RIGHT);
            this.joysticksCodeMap.put(Parameters.KEY_P0_DOWN, ConsoleControls.Control.JOY0_DOWN);
            this.joysticksCodeMap.put(Parameters.KEY_P0_BUTTON, ConsoleControls.Control.JOY0_BUTTON);
            this.joysticksCodeMap.put(Parameters.KEY_P0_BUTTON2, ConsoleControls.Control.JOY0_BUTTON);
            this.joysticksCodeMap.put(Parameters.KEY_P1_LEFT, ConsoleControls.Control.JOY1_LEFT);
            this.joysticksCodeMap.put(Parameters.KEY_P1_UP, ConsoleControls.Control.JOY1_UP);
            this.joysticksCodeMap.put(Parameters.KEY_P1_RIGHT, ConsoleControls.Control.JOY1_RIGHT);
            this.joysticksCodeMap.put(Parameters.KEY_P1_DOWN, ConsoleControls.Control.JOY1_DOWN);
            this.joysticksCodeMap.put(Parameters.KEY_P1_BUTTON, ConsoleControls.Control.JOY1_BUTTON);
            this.joysticksCodeMap.put(Parameters.KEY_P1_BUTTON2, ConsoleControls.Control.JOY1_BUTTON);
        } else {
            this.joysticksCodeMap.put(Parameters.KEY_P0_LEFT, ConsoleControls.Control.JOY1_LEFT);
            this.joysticksCodeMap.put(Parameters.KEY_P0_UP, ConsoleControls.Control.JOY1_UP);
            this.joysticksCodeMap.put(Parameters.KEY_P0_RIGHT, ConsoleControls.Control.JOY1_RIGHT);
            this.joysticksCodeMap.put(Parameters.KEY_P0_DOWN, ConsoleControls.Control.JOY1_DOWN);
            this.joysticksCodeMap.put(Parameters.KEY_P0_BUTTON, ConsoleControls.Control.JOY1_BUTTON);
            this.joysticksCodeMap.put(Parameters.KEY_P0_BUTTON2, ConsoleControls.Control.JOY1_BUTTON);
            this.joysticksCodeMap.put(Parameters.KEY_P1_LEFT, ConsoleControls.Control.JOY0_LEFT);
            this.joysticksCodeMap.put(Parameters.KEY_P1_UP, ConsoleControls.Control.JOY0_UP);
            this.joysticksCodeMap.put(Parameters.KEY_P1_RIGHT, ConsoleControls.Control.JOY0_RIGHT);
            this.joysticksCodeMap.put(Parameters.KEY_P1_DOWN, ConsoleControls.Control.JOY0_DOWN);
            this.joysticksCodeMap.put(Parameters.KEY_P1_BUTTON, ConsoleControls.Control.JOY0_BUTTON);
            this.joysticksCodeMap.put(Parameters.KEY_P1_BUTTON2, ConsoleControls.Control.JOY0_BUTTON);
        }
    }

    private class PaddlesPositionUpdater
    extends Thread {
        public PaddlesPositionUpdater() {
            super("AWTControls Paddles Updater");
        }

        @Override
        public void run() {
            while (AWTConsoleControls.this.paddleMode) {
                AWTConsoleControls.this.paddlesUpdatePosition();
                try {
                    PaddlesPositionUpdater.sleep(16L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

