/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.room;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.console.Console;
import org.javatari.atari.network.ClientConsole;
import org.javatari.atari.network.RemoteReceiver;
import org.javatari.atari.network.RemoteTransmitter;
import org.javatari.atari.network.ServerConsole;
import org.javatari.parameters.Parameters;
import org.javatari.pc.cartridge.ROMLoader;
import org.javatari.pc.controls.AWTConsoleControls;
import org.javatari.pc.controls.JoystickConsoleControls;
import org.javatari.pc.room.AppletRoom;
import org.javatari.pc.room.settings.SettingsDialog;
import org.javatari.pc.savestate.FileSaveStateMedia;
import org.javatari.pc.screen.DesktopScreenWindow;
import org.javatari.pc.screen.Screen;
import org.javatari.pc.speaker.Speaker;
import org.javatari.utils.Terminator;

public class Room {
    private Console currentConsole;
    private Console standaloneConsole;
    private ServerConsole serverConsole;
    private ClientConsole clientConsole;
    private Screen screen;
    private Speaker speaker;
    private AWTConsoleControls awtControls;
    private FileSaveStateMedia stateMedia;
    private Cartridge cartridgeProvided;
    private boolean triedToLoadCartridgeProvided = false;
    private SettingsDialog settingsDialog;
    private static Room currentRoom;

    protected Room() {
    }

    public void powerOn() {
        this.screen.powerOn();
        this.speaker.powerOn();
        this.awtControls.powerOn();
        this.insertCartridgeProvidedIfNoneInserted();
        if (this.currentConsole.cartridgeSocket().inserted() != null) {
            this.currentConsole.powerOn();
        }
    }

    public void powerOff() {
        this.currentConsole.powerOff();
        this.awtControls.powerOff();
        this.speaker.powerOff();
        this.screen.powerOff();
    }

    public Console currentConsole() {
        return this.currentConsole;
    }

    public Console standaloneCurrentConsole() {
        if (this.currentConsole != this.standaloneConsole) {
            throw new IllegalStateException("Not a Standalone Room");
        }
        return this.standaloneConsole;
    }

    public ServerConsole serverCurrentConsole() {
        if (this.currentConsole != this.serverConsole) {
            throw new IllegalStateException("Not a Server Room");
        }
        return this.serverConsole;
    }

    public ClientConsole clientCurrentConsole() {
        if (this.currentConsole != this.clientConsole) {
            throw new IllegalStateException("Not a Client Room");
        }
        return this.clientConsole;
    }

    public Screen screen() {
        return this.screen;
    }

    public Speaker speaker() {
        return this.speaker;
    }

    public AWTConsoleControls awtControls() {
        return this.awtControls;
    }

    public JoystickConsoleControls joystickControls() {
        return this.awtControls.joystickControls();
    }

    public FileSaveStateMedia stateMedia() {
        return this.stateMedia;
    }

    public boolean isStandaloneMode() {
        return this.currentConsole == this.standaloneConsole;
    }

    public boolean isServerMode() {
        return this.currentConsole == this.serverConsole;
    }

    public boolean isClientMode() {
        return this.currentConsole == this.clientConsole;
    }

    public void morphToStandaloneMode() {
        Cartridge lastCartridge;
        if (this.isStandaloneMode()) {
            return;
        }
        this.powerOff();
        Cartridge cartridge = lastCartridge = this.isClientMode() ? null : this.currentConsole.cartridgeSocket().inserted();
        if (this.standaloneConsole == null) {
            this.buildAndPlugStandaloneConsole();
        } else {
            this.plugConsole(this.standaloneConsole);
        }
        this.adjustPeripheralsToStandaloneOrServerOperation();
        if (lastCartridge != null) {
            this.currentConsole.cartridgeSocket().insert(lastCartridge, false);
        }
        this.powerOn();
    }

    public void morphToServerMode() {
        Cartridge lastCartridge;
        if (this.isServerMode()) {
            return;
        }
        this.powerOff();
        Cartridge cartridge = lastCartridge = this.isClientMode() ? null : this.currentConsole.cartridgeSocket().inserted();
        if (this.serverConsole == null) {
            this.buildAndPlugServerConsole();
        } else {
            this.plugConsole(this.serverConsole);
        }
        this.adjustPeripheralsToStandaloneOrServerOperation();
        if (lastCartridge != null) {
            this.currentConsole.cartridgeSocket().insert(lastCartridge, false);
        }
        this.powerOn();
    }

    public void morphToClientMode() {
        if (this.isClientMode()) {
            return;
        }
        this.powerOff();
        if (this.clientConsole == null) {
            this.buildAndPlugClientConsole();
        } else {
            this.plugConsole(this.clientConsole);
        }
        this.adjustPeripheralsToClientOperation();
        this.powerOn();
    }

    public void openSettings() {
        if (this.settingsDialog == null) {
            this.settingsDialog = new SettingsDialog(this);
        }
        this.settingsDialog.open();
    }

    public void destroy() {
        this.powerOff();
        if (this.standaloneConsole != null) {
            this.standaloneConsole.destroy();
        }
        if (this.serverConsole != null) {
            this.serverConsole.destroy();
        }
        if (this.clientConsole != null) {
            this.clientConsole.destroy();
        }
        this.screen.destroy();
        this.speaker.destroy();
        if (this.settingsDialog != null) {
            this.settingsDialog.setVisible(false);
            this.settingsDialog.dispose();
        }
        currentRoom = null;
    }

    protected void buildPeripherals() {
        if (this.screen != null) {
            throw new IllegalStateException();
        }
        this.screen = this.buildScreenPeripheral();
        this.speaker = new Speaker();
        this.awtControls = new AWTConsoleControls(this.screen.monitor());
        this.awtControls.addInputComponents(this.screen.controlsInputComponents());
        this.stateMedia = new FileSaveStateMedia();
    }

    protected Screen buildScreenPeripheral() {
        return new DesktopScreenWindow();
    }

    private void plugConsole(Console console) {
        if (this.currentConsole == console) {
            return;
        }
        this.currentConsole = console;
        this.screen.connect(this.currentConsole.videoOutput(), this.currentConsole.controlsSocket(), this.currentConsole.cartridgeSocket());
        this.speaker.connect(this.currentConsole.audioOutput());
        this.awtControls.connect(this.currentConsole.controlsSocket());
        this.stateMedia.connect(this.currentConsole.saveStateSocket());
    }

    private void insertCartridgeProvidedIfNoneInserted() {
        if (this.currentConsole.cartridgeSocket().inserted() != null) {
            return;
        }
        this.loadCartridgeProvided();
        if (this.cartridgeProvided != null) {
            this.currentConsole.cartridgeSocket().insert(this.cartridgeProvided, false);
        }
    }

    private void loadCartridgeProvided() {
        if (this.triedToLoadCartridgeProvided) {
            return;
        }
        this.triedToLoadCartridgeProvided = true;
        if (this.isClientMode() || Parameters.mainArg == null) {
            return;
        }
        this.cartridgeProvided = ROMLoader.load(Parameters.mainArg);
        if (this.cartridgeProvided == null) {
            Terminator.terminate();
        }
    }

    private Console buildAndPlugStandaloneConsole() {
        if (this.standaloneConsole != null) {
            throw new IllegalStateException();
        }
        this.standaloneConsole = new Console();
        this.plugConsole(this.standaloneConsole);
        return this.standaloneConsole;
    }

    private ServerConsole buildAndPlugServerConsole() {
        if (this.serverConsole != null) {
            throw new IllegalStateException();
        }
        RemoteTransmitter remoteTransmitter = new RemoteTransmitter();
        this.serverConsole = new ServerConsole(remoteTransmitter);
        this.plugConsole(this.serverConsole);
        return this.serverConsole;
    }

    private ClientConsole buildAndPlugClientConsole() {
        RemoteReceiver remoteReceiver = new RemoteReceiver();
        this.clientConsole = new ClientConsole(remoteReceiver);
        this.plugConsole(this.clientConsole);
        return this.clientConsole;
    }

    private void adjustPeripheralsToStandaloneOrServerOperation() {
        currentRoom.awtControls().p1ControlsMode(false);
        currentRoom.screen().monitor().setCartridgeChangeEnabled(Parameters.SCREEN_CARTRIDGE_CHANGE);
    }

    private void adjustPeripheralsToClientOperation() {
        currentRoom.awtControls().p1ControlsMode(true);
        currentRoom.screen().monitor().setCartridgeChangeEnabled(false);
    }

    public static Room currentRoom() {
        return currentRoom;
    }

    public static Room buildStandaloneRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new Room();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToStandaloneOrServerOperation();
        currentRoom.buildAndPlugStandaloneConsole();
        return currentRoom;
    }

    public static Room buildServerRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new Room();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToStandaloneOrServerOperation();
        currentRoom.buildAndPlugServerConsole();
        return currentRoom;
    }

    public static Room buildClientRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new Room();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToClientOperation();
        currentRoom.buildAndPlugClientConsole();
        return currentRoom;
    }

    public static Room buildAppletStandaloneRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new AppletRoom();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToStandaloneOrServerOperation();
        currentRoom.buildAndPlugStandaloneConsole();
        return currentRoom;
    }

    public static Room buildAppletServerRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new AppletRoom();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToStandaloneOrServerOperation();
        currentRoom.buildAndPlugServerConsole();
        return currentRoom;
    }

    public static Room buildAppletClientRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new AppletRoom();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToClientOperation();
        currentRoom.buildAndPlugClientConsole();
        return currentRoom;
    }
}

