/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.room.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.formats.CartridgeDatabase;
import org.javatari.atari.console.Console;
import org.javatari.atari.controls.ConsoleControls;
import org.javatari.atari.network.ConnectionStatusListener;
import org.javatari.atari.network.RemoteReceiver;
import org.javatari.atari.network.RemoteTransmitter;
import org.javatari.parameters.Parameters;
import org.javatari.pc.controls.JoystickConsoleControls;
import org.javatari.pc.room.Room;
import org.javatari.pc.room.settings.DeepBorder;
import org.javatari.pc.room.settings.JComboBoxNim;
import org.javatari.pc.room.settings.JTextFieldNim;
import org.javatari.pc.room.settings.KeyNames;
import org.javatari.utils.Environment;
import org.javatari.utils.GraphicsDeviceHelper;

public final class SettingsDialog
extends JDialog
implements ConnectionStatusListener,
JoystickConsoleControls.JoystickButtonDetectionListener {
    private final Room room;
    private boolean buildFinished = false;
    private final JPanel contentPanel = new JPanel();
    private JTabbedPane mainTabbedPane;
    private JPanel keyboardPanel;
    private JPanel joysticksPanel;
    private JTextField keyP0Up;
    private JTextField keyP0Down;
    private JTextField keyP0Left;
    private JTextField keyP0Right;
    private JTextField keyP0Button;
    private JTextField keyP0Button2;
    private JTextField keyP1Up;
    private JTextField keyP1Down;
    private JTextField keyP1Left;
    private JTextField keyP1Right;
    private JTextField keyP1Button;
    private JTextField keyP1Button2;
    private List<JTextField> keyboardFieldsList;
    private Object keyboardEditField;
    private JLabel keyboardPlayer1Lb;
    private JLabel keyP0UpL;
    private JLabel keyP0DownL;
    private JLabel keyboardPlayer2Lb;
    private JLabel keyP1UpL;
    private JLabel keyP1DownL;
    private JLabel keyboardMessageL;
    private JLabel keyboardEdittingL;
    private JLabel keyboard0Icon;
    private JLabel keyboard1Icon;
    private JTextField joyP0Button;
    private JTextField joyP0Button2;
    private JTextField joyP0Reset;
    private JTextField joyP0Select;
    private JTextField joyP0Pause;
    private JTextField joyP0FastSpeed;
    private JTextField joyP1Button;
    private JTextField joyP1Button2;
    private JTextField joyP1Reset;
    private JTextField joyP1Select;
    private JTextField joyP1Pause;
    private JTextField joyP1FastSpeed;
    private JComboBox joyP0Device;
    private JComboBox joyP0Deadzone;
    private JComboBox joyP0Sensitivity;
    private JComboBox joyP0XAxis;
    private JComboBox joyP0YAxis;
    private JComboBox joyP1Device;
    private JComboBox joyP1Deadzone;
    private JComboBox joyP1Sensitivity;
    private JComboBox joyP1XAxis;
    private JComboBox joyP1YAxis;
    private List<JTextField> joystick0FieldsList;
    private List<JTextField> joystick1FieldsList;
    private List<JTextField> joysticksFieldsList;
    private Object joystickEditField;
    private JLabel joyP0XAxisL;
    private JLabel joyP0DeadzoneL;
    private JLabel joyP1XAxisL;
    private JLabel joyP1DeadzoneL;
    private JLabel joysticksPlayer1Lb;
    private JLabel joysticksPlayer2Lb;
    private JLabel joysticksMessageL;
    private JLabel joysticksEdittingL;
    private JLabel joystick0Icon;
    private JLabel joystick1Icon;
    private ImageIcon joystickIcon;
    private ImageIcon joystickIconGrayed;
    private ImageIcon paddleIcon;
    private ImageIcon paddleIconGrayed;
    private JLabel multiplayerModeL;
    private JLabel standaloneConsoleL;
    private JLabel serverConsoleL;
    private JLabel clientConsoleL;
    private JLabel networkL;
    private JTextField serverPortTf;
    private JTextField clientServerAddressTf;
    private JButton serverStartB;
    private JButton clientConnectB;
    private JTextField romNameTf;
    private JList romFormatLb;
    private JButton defaultsB;
    private JButton closeB;
    private boolean refreshInProgress = false;
    private static final int CONTROL_UNSET = -1;
    private static final Color UNMAPPED = new Color(255, 255, 150);
    private static final Color EDDITING = new Color(130, 150, 255);
    private static final String PADDLE_CENTER_ZERO = "<0>";
    private static final String PADDLE_SENS_DIGITAL = "Digital";
    private static final String[] JOY_AXIS_OPTIONS = new String[]{"X", "Y", "Z", "R", "U", "V", "-X", "-Y", "-Z", "-R", "-U", "-V"};
    private static final int[] JOY_AXIS_NUMBERS;
    private static final int[] JOY_AXIS_SIGNALS;
    private static final String[] JOY_DEADZONE_OPTIONS;
    private static final String[] PADDLE_CENTER_OPTIONS;
    private static final String[] PADDLE_SENS_OPTIONS;
    private static final Dimension INTERNAL_TAB_SIZE;
    private static final long serialVersionUID = 1L;
    private JLabel vmInfo;

    static {
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 3;
        nArray[10] = 4;
        nArray[11] = 5;
        JOY_AXIS_NUMBERS = nArray;
        JOY_AXIS_SIGNALS = new int[]{1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1};
        JOY_DEADZONE_OPTIONS = new String[]{"0%", "5%", "10%", "15%", "20%", "25%", "30%", "35%", "40%", "45%", "50%", "60%", "70%"};
        PADDLE_CENTER_OPTIONS = new String[]{"-60", "-50", "-40", "-30", "-20", "-10", PADDLE_CENTER_ZERO, "+10", "+20", "+30", "+40", "+50", "+60"};
        PADDLE_SENS_OPTIONS = new String[]{PADDLE_SENS_DIGITAL, "30%", "35%", "40%", "45%", "50%", "55%", "60%", "65%", "70%", "75%", "80%", "90%", "100%"};
        INTERNAL_TAB_SIZE = new Dimension(472, 258 + (Environment.NIMBUS_LAF ? 0 : 5));
    }

    public SettingsDialog(Room room) {
        this.room = room;
        this.loadImages();
        this.buildGUI();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setEscActionListener();
        this.buildControlsFieldsLists();
        this.setControlsFieldsKeyListeners();
        this.setMultiplayerDefaults();
        this.vmInfo.setText(Environment.vmInfo());
        this.mainTabbedPane.setSelectedIndex(5);
        this.mainTabbedPane.setEnabledAt(0, Parameters.MULTIPLAYER_UI);
    }

    public void open() {
        this.setupConnectionStatusListeners();
        this.mainTabbedPaneChanged();
        this.setVisible(true);
    }

    @Override
    public void connectionStatusChanged() {
        if (this.isVisible()) {
            this.refreshMultiplayerImages();
        }
    }

    private void refreshKeyboard() {
        String message;
        if (this.refreshInProgress) {
            return;
        }
        this.refreshInProgress = true;
        this.keyP0Up.setText(KeyNames.get(Parameters.KEY_P0_UP));
        this.keyP0Down.setText(KeyNames.get(Parameters.KEY_P0_DOWN));
        this.keyP0Left.setText(KeyNames.get(Parameters.KEY_P0_LEFT));
        this.keyP0Right.setText(KeyNames.get(Parameters.KEY_P0_RIGHT));
        this.keyP0Button.setText(KeyNames.get(Parameters.KEY_P0_BUTTON));
        this.keyP0Button2.setText(KeyNames.get(Parameters.KEY_P0_BUTTON2));
        this.keyP1Up.setText(KeyNames.get(Parameters.KEY_P1_UP));
        this.keyP1Down.setText(KeyNames.get(Parameters.KEY_P1_DOWN));
        this.keyP1Left.setText(KeyNames.get(Parameters.KEY_P1_LEFT));
        this.keyP1Right.setText(KeyNames.get(Parameters.KEY_P1_RIGHT));
        this.keyP1Button.setText(KeyNames.get(Parameters.KEY_P1_BUTTON));
        this.keyP1Button2.setText(KeyNames.get(Parameters.KEY_P1_BUTTON2));
        for (JTextField field : this.keyboardFieldsList) {
            if (field == this.keyboardEditField) {
                field.setBackground(EDDITING);
                field.setSelectionStart(0);
                field.setSelectionEnd(0);
                continue;
            }
            field.setBackground(field.getText().trim().isEmpty() ? UNMAPPED : Color.WHITE);
        }
        this.keyboardEdittingL.setText(this.keyboardEditField != null ? "- press key -" : "");
        this.defaultsB.setText("Defaults");
        this.defaultsB.setVisible(true);
        if (this.room.awtControls().paddleMode) {
            this.keyP0UpL.setText("+ Speed ");
            this.keyP0DownL.setText("- Speed ");
            this.keyP1UpL.setText("+ Speed ");
            this.keyP1DownL.setText("- Speed ");
            this.keyboard0Icon.setIcon(this.paddleIcon);
            this.keyboard1Icon.setIcon(this.paddleIcon);
        } else {
            this.keyP0UpL.setText("Up");
            this.keyP0DownL.setText("Down");
            this.keyP1UpL.setText("Up");
            this.keyP1DownL.setText("Down");
            this.keyboard0Icon.setIcon(this.joystickIcon);
            this.keyboard1Icon.setIcon(this.joystickIcon);
        }
        if (this.room.awtControls().p1ControlsMode) {
            this.keyboardPlayer1Lb.setText("Player 2");
            this.keyboardPlayer2Lb.setText("Player 1");
            message = "Swapped";
        } else {
            this.keyboardPlayer1Lb.setText("Player 1");
            this.keyboardPlayer2Lb.setText("Player 2");
            message = "";
        }
        this.keyboardMessageL.setText(message);
        this.refreshInProgress = false;
    }

    private void refreshJoysticks() {
        String message;
        if (this.refreshInProgress) {
            return;
        }
        this.refreshInProgress = true;
        String pre = "But ";
        String empty = "     ";
        Vector<JoystickConsoleControls.DeviceOption> joyP0Opts = this.room.joystickControls().getJoystick0DeviceOptions();
        if (!joyP0Opts.isEmpty()) {
            this.joyP0Device.setModel(new DefaultComboBoxModel<JoystickConsoleControls.DeviceOption>(joyP0Opts));
            this.joyP0Device.setSelectedItem(this.room.joystickControls().getJoystick0DeviceOption());
            this.joyP0Device.setEnabled(true);
        } else {
            this.joyP0Device.setModel(new DefaultComboBoxModel<String>(new Vector<String>(Arrays.asList("Not Supported"))));
            this.joyP0Device.setSelectedIndex(0);
            this.joyP0Device.setEnabled(false);
        }
        Vector<JoystickConsoleControls.DeviceOption> joyP1Opts = this.room.joystickControls().getJoystick1DeviceOptions();
        if (!joyP1Opts.isEmpty()) {
            this.joyP1Device.setModel(new DefaultComboBoxModel<JoystickConsoleControls.DeviceOption>(this.room.joystickControls().getJoystick1DeviceOptions()));
            this.joyP1Device.setSelectedItem(this.room.joystickControls().getJoystick1DeviceOption());
            this.joyP1Device.setEnabled(true);
        } else {
            this.joyP1Device.setModel(new DefaultComboBoxModel<String>(new Vector<String>(Arrays.asList("Not Supported"))));
            this.joyP1Device.setSelectedIndex(0);
            this.joyP1Device.setEnabled(false);
        }
        boolean joy0Present = this.room.joystickControls().isStarted() && this.room.joystickControls().getJoystick0() != null;
        boolean joy1Present = this.room.joystickControls().isStarted() && this.room.joystickControls().getJoystick1() != null;
        this.joyP0Button.setText(Parameters.JOY_P0_BUTTON == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P0_BUTTON + 1));
        this.joyP0Button2.setText(Parameters.JOY_P0_BUTTON2 == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P0_BUTTON2 + 1));
        this.joyP0Reset.setText(Parameters.JOY_P0_RESET == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P0_RESET + 1));
        this.joyP0Select.setText(Parameters.JOY_P0_SELECT == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P0_SELECT + 1));
        this.joyP0Pause.setText(Parameters.JOY_P0_PAUSE == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P0_PAUSE + 1));
        this.joyP0FastSpeed.setText(Parameters.JOY_P0_FAST_SPPED == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P0_FAST_SPPED + 1));
        this.joyP1Button.setText(Parameters.JOY_P1_BUTTON == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P1_BUTTON + 1));
        this.joyP1Button2.setText(Parameters.JOY_P1_BUTTON2 == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P1_BUTTON2 + 1));
        this.joyP1Reset.setText(Parameters.JOY_P1_RESET == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P1_RESET + 1));
        this.joyP1Select.setText(Parameters.JOY_P1_SELECT == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P1_SELECT + 1));
        this.joyP1Pause.setText(Parameters.JOY_P1_PAUSE == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P1_PAUSE + 1));
        this.joyP1FastSpeed.setText(Parameters.JOY_P1_FAST_SPPED == -1 ? empty : String.valueOf(pre) + (Parameters.JOY_P1_FAST_SPPED + 1));
        this.joyP0Deadzone.setEnabled(joy0Present);
        this.joyP1Deadzone.setEnabled(joy1Present);
        this.joyP0XAxis.setEnabled(joy0Present);
        this.joyP1XAxis.setEnabled(joy1Present);
        if (this.room.joystickControls().paddleMode) {
            this.joyP0DeadzoneL.setText("Center");
            this.joyP0Deadzone.setModel(new DefaultComboBoxModel<String>(PADDLE_CENTER_OPTIONS));
            this.joyP0Deadzone.setSelectedItem(Parameters.JOY_P0_PADDLE_CENTER == 0 ? PADDLE_CENTER_ZERO : String.format("%+d", Parameters.JOY_P0_PADDLE_CENTER));
            this.joyP0Sensitivity.setEnabled(joy0Present);
            this.joyP0Sensitivity.setSelectedItem(Parameters.JOY_P0_PADDLE_SENS == 0 ? PADDLE_SENS_DIGITAL : Parameters.JOY_P0_PADDLE_SENS + "%");
            this.joyP0XAxisL.setText("Axis");
            this.joyP0XAxis.setSelectedIndex(Parameters.JOY_P0_PAD_AXIS + (Parameters.JOY_P0_PAD_AXIS_SIGNAL == -1 ? 6 : 0));
            this.joyP0YAxis.setEnabled(false);
            this.joyP0YAxis.setSelectedIndex(1);
            this.joyP1DeadzoneL.setText("Center");
            this.joyP1Deadzone.setModel(new DefaultComboBoxModel<String>(PADDLE_CENTER_OPTIONS));
            this.joyP1Deadzone.setSelectedItem(Parameters.JOY_P1_PADDLE_CENTER == 0 ? PADDLE_CENTER_ZERO : String.format("%+d", Parameters.JOY_P1_PADDLE_CENTER));
            this.joyP1Sensitivity.setEnabled(joy1Present);
            this.joyP1Sensitivity.setSelectedItem(Parameters.JOY_P1_PADDLE_SENS == 0 ? PADDLE_SENS_DIGITAL : Parameters.JOY_P1_PADDLE_SENS + "%");
            this.joyP1XAxisL.setText("Axis");
            this.joyP1XAxis.setSelectedIndex(Parameters.JOY_P1_PAD_AXIS + (Parameters.JOY_P1_PAD_AXIS_SIGNAL == -1 ? 6 : 0));
            this.joyP1YAxis.setEnabled(false);
            this.joyP1YAxis.setSelectedIndex(1);
            this.joystick0Icon.setIcon(joy0Present ? this.paddleIcon : this.paddleIconGrayed);
            this.joystick1Icon.setIcon(joy1Present ? this.paddleIcon : this.paddleIconGrayed);
        } else {
            this.joyP0DeadzoneL.setText("Dead zone");
            this.joyP0Deadzone.setModel(new DefaultComboBoxModel<String>(JOY_DEADZONE_OPTIONS));
            this.joyP0Deadzone.setSelectedItem(Parameters.JOY_P0_DEADZONE + "%");
            this.joyP0Sensitivity.setEnabled(false);
            this.joyP0Sensitivity.setSelectedIndex(0);
            this.joyP0XAxisL.setText("X Axis");
            this.joyP0XAxis.setSelectedIndex(Parameters.JOY_P0_XAXIS + (Parameters.JOY_P0_XAXIS_SIGNAL == -1 ? 6 : 0));
            this.joyP0YAxis.setEnabled(joy0Present);
            this.joyP0YAxis.setSelectedIndex(Parameters.JOY_P0_YAXIS + (Parameters.JOY_P0_YAXIS_SIGNAL == -1 ? 6 : 0));
            this.joyP1DeadzoneL.setText("Dead zone");
            this.joyP1Deadzone.setModel(new DefaultComboBoxModel<String>(JOY_DEADZONE_OPTIONS));
            this.joyP1Deadzone.setSelectedItem(Parameters.JOY_P1_DEADZONE + "%");
            this.joyP1Sensitivity.setEnabled(false);
            this.joyP1Sensitivity.setSelectedIndex(0);
            this.joyP1XAxisL.setText("X Axis");
            this.joyP1XAxis.setSelectedIndex(Parameters.JOY_P1_XAXIS + (Parameters.JOY_P1_XAXIS_SIGNAL == -1 ? 6 : 0));
            this.joyP1YAxis.setEnabled(joy1Present);
            this.joyP1YAxis.setSelectedIndex(Parameters.JOY_P1_YAXIS + (Parameters.JOY_P1_YAXIS_SIGNAL == -1 ? 6 : 0));
            this.joystick0Icon.setIcon(joy0Present ? this.joystickIcon : this.joystickIconGrayed);
            this.joystick1Icon.setIcon(joy1Present ? this.joystickIcon : this.joystickIconGrayed);
        }
        for (JTextField f : this.joystick0FieldsList) {
            f.setEnabled(joy0Present);
        }
        for (JTextField f : this.joystick1FieldsList) {
            f.setEnabled(joy1Present);
        }
        for (JTextField field : this.joysticksFieldsList) {
            if (field == this.joystickEditField) {
                field.setBackground(EDDITING);
                field.setSelectionStart(0);
                field.setSelectionEnd(0);
                continue;
            }
            field.setBackground(field.getText().trim().isEmpty() ? UNMAPPED : Color.WHITE);
        }
        this.joysticksEdittingL.setText(this.joystickEditField != null ? "- press button -" : "");
        this.defaultsB.setText("Defaults");
        this.defaultsB.setVisible(true);
        if (this.room.awtControls().p1ControlsMode ^ this.room.joystickControls().swappedMode) {
            this.joysticksPlayer1Lb.setText("Player 2");
            this.joysticksPlayer2Lb.setText("Player 1");
            message = "Swapped";
        } else {
            this.joysticksPlayer1Lb.setText("Player 1");
            this.joysticksPlayer2Lb.setText("Player 2");
            message = "";
        }
        this.joysticksMessageL.setText(message);
        this.refreshInProgress = false;
    }

    private void refreshCartridge() {
        if (this.refreshInProgress) {
            return;
        }
        this.refreshInProgress = true;
        if (this.room.currentConsole().cartridgeSocket().inserted() == null) {
            this.romNameTf.setText("<NO CARTRIDGE INSERTED>");
            this.romFormatLb.setListData(new Object[0]);
            this.romFormatLb.setEnabled(false);
            this.defaultsB.setVisible(false);
        } else {
            Cartridge cart = this.room.currentConsole().cartridgeSocket().inserted();
            this.romNameTf.setText(cart.contentName());
            this.romNameTf.setCaretPosition(0);
            ArrayList<CartridgeFormatOption> formatOptions = CartridgeDatabase.getFormatOptionsUnhinted(cart);
            ArrayList<CartridgeFormat> formats = new ArrayList<CartridgeFormat>();
            for (CartridgeFormatOption option : formatOptions) {
                formats.add(option.format);
            }
            if (!formats.contains(cart.format())) {
                formats.add(0, cart.format());
            }
            this.romFormatLb.setListData(formats.toArray());
            this.romFormatLb.setSelectedValue(cart.format(), true);
            this.romFormatLb.setEnabled(!formats.isEmpty() && !this.room.isClientMode());
            this.defaultsB.setText("Auto Detect");
            this.defaultsB.setVisible(!this.room.isClientMode());
        }
        this.refreshInProgress = false;
    }

    private void refreshMultiplayer() {
        if (this.refreshInProgress) {
            return;
        }
        this.refreshInProgress = true;
        boolean serverMode = this.room.isServerMode();
        boolean clientMode = this.room.isClientMode();
        this.multiplayerModeL.setText(serverMode ? "P1 SERVER MODE" : (clientMode ? "P2 CLIENT MODE" : "STANDALONE MODE"));
        this.multiplayerModeL.setForeground(serverMode ? new Color(47, 92, 180) : (clientMode ? new Color(169, 46, 34) : new Color(0, 100, 30)));
        this.serverStartB.setText(serverMode ? "STOP" : "START");
        this.serverStartB.setEnabled(!clientMode);
        this.serverPortTf.setEditable(!serverMode && !clientMode);
        this.clientConnectB.setText(clientMode ? "LEAVE" : "JOIN");
        this.clientConnectB.setEnabled(!serverMode);
        this.clientServerAddressTf.setEditable(!serverMode && !clientMode);
        this.refreshMultiplayerImages();
        this.defaultsB.setText("Defaults");
        this.defaultsB.setVisible(!serverMode && !clientMode);
        this.refreshInProgress = false;
    }

    private void refreshMultiplayerImages() {
        boolean serverMode = this.room.isServerMode();
        boolean clientMode = this.room.isClientMode();
        boolean clientConnected = serverMode && this.room.serverCurrentConsole().remoteTransmitter().isClientConnected();
        boolean connectedToServer = clientMode && this.room.clientCurrentConsole().remoteReceiver().isConnected();
        this.standaloneConsoleL.setVisible(!serverMode && !clientMode);
        this.networkL.setVisible(serverMode || clientMode);
        this.serverConsoleL.setVisible(serverMode || connectedToServer);
        this.clientConsoleL.setVisible(clientMode || clientConnected);
    }

    private void setControlsFieldsKeyListeners() {
        MouseAdapter kmLis = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    SettingsDialog.this.keyboardSetEditField(e);
                }
            }
        };
        KeyAdapter kkLis = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SettingsDialog.this.keyboardSetKey(e);
            }
        };
        for (JTextField field : this.keyboardFieldsList) {
            field.addKeyListener(kkLis);
            field.addMouseListener(kmLis);
        }
        MouseAdapter jmLis = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    SettingsDialog.this.joystickSetEditField(e);
                }
            }
        };
        KeyAdapter jkLis = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 || e.getKeyCode() == 127 || e.getKeyCode() == 32) {
                    SettingsDialog.this.joystickSetButton(-1);
                }
            }
        };
        for (JTextField field : this.joysticksFieldsList) {
            field.addKeyListener(jkLis);
            field.addMouseListener(jmLis);
        }
    }

    private void keyboardSetEditField(MouseEvent e) {
        this.keyboardEditField = e.getSource();
        this.refreshKeyboard();
    }

    private void keyboardResetEditField() {
        this.keyboardEditField = null;
    }

    private void keyboardSetKey(KeyEvent e) {
        if (this.keyboardEditField == null) {
            return;
        }
        int code = e.getKeyCode();
        if (!KeyNames.hasName(code)) {
            return;
        }
        this.unsetKeyboardKey(code);
        if (this.keyboardEditField == this.keyP0Up) {
            Parameters.KEY_P0_UP = code;
        } else if (this.keyboardEditField == this.keyP0Down) {
            Parameters.KEY_P0_DOWN = code;
        } else if (this.keyboardEditField == this.keyP0Left) {
            Parameters.KEY_P0_LEFT = code;
        } else if (this.keyboardEditField == this.keyP0Right) {
            Parameters.KEY_P0_RIGHT = code;
        } else if (this.keyboardEditField == this.keyP0Button) {
            Parameters.KEY_P0_BUTTON = code;
        } else if (this.keyboardEditField == this.keyP0Button2) {
            Parameters.KEY_P0_BUTTON2 = code;
        } else if (this.keyboardEditField == this.keyP1Up) {
            Parameters.KEY_P1_UP = code;
        } else if (this.keyboardEditField == this.keyP1Down) {
            Parameters.KEY_P1_DOWN = code;
        } else if (this.keyboardEditField == this.keyP1Left) {
            Parameters.KEY_P1_LEFT = code;
        } else if (this.keyboardEditField == this.keyP1Right) {
            Parameters.KEY_P1_RIGHT = code;
        } else if (this.keyboardEditField == this.keyP1Button) {
            Parameters.KEY_P1_BUTTON = code;
        } else if (this.keyboardEditField == this.keyP1Button2) {
            Parameters.KEY_P1_BUTTON2 = code;
        }
        this.keyboardResetEditField();
        this.refreshKeyboard();
    }

    private void unsetKeyboardKey(int code) {
        if (Parameters.KEY_P0_UP == code) {
            Parameters.KEY_P0_UP = -1;
        }
        if (Parameters.KEY_P0_DOWN == code) {
            Parameters.KEY_P0_DOWN = -1;
        }
        if (Parameters.KEY_P0_LEFT == code) {
            Parameters.KEY_P0_LEFT = -1;
        }
        if (Parameters.KEY_P0_RIGHT == code) {
            Parameters.KEY_P0_RIGHT = -1;
        }
        if (Parameters.KEY_P0_BUTTON == code) {
            Parameters.KEY_P0_BUTTON = -1;
        }
        if (Parameters.KEY_P0_BUTTON2 == code) {
            Parameters.KEY_P0_BUTTON2 = -1;
        }
        if (Parameters.KEY_P1_UP == code) {
            Parameters.KEY_P1_UP = -1;
        }
        if (Parameters.KEY_P1_DOWN == code) {
            Parameters.KEY_P1_DOWN = -1;
        }
        if (Parameters.KEY_P1_LEFT == code) {
            Parameters.KEY_P1_LEFT = -1;
        }
        if (Parameters.KEY_P1_RIGHT == code) {
            Parameters.KEY_P1_RIGHT = -1;
        }
        if (Parameters.KEY_P1_BUTTON == code) {
            Parameters.KEY_P1_BUTTON = -1;
        }
        if (Parameters.KEY_P1_BUTTON2 == code) {
            Parameters.KEY_P1_BUTTON2 = -1;
        }
    }

    private void buildControlsFieldsLists() {
        this.keyboardFieldsList = Arrays.asList(this.keyP0Up, this.keyP0Down, this.keyP0Left, this.keyP0Right, this.keyP0Button, this.keyP0Button2, this.keyP1Up, this.keyP1Down, this.keyP1Left, this.keyP1Right, this.keyP1Button, this.keyP1Button2);
        this.joystick0FieldsList = Arrays.asList(this.joyP0Button, this.joyP0Button2, this.joyP0Select, this.joyP0Reset, this.joyP0Pause, this.joyP0FastSpeed);
        this.joystick1FieldsList = Arrays.asList(this.joyP1Button, this.joyP1Button2, this.joyP1Select, this.joyP1Reset, this.joyP1Pause, this.joyP1FastSpeed);
        this.joysticksFieldsList = new ArrayList<JTextField>(this.joystick0FieldsList);
        this.joysticksFieldsList.addAll(this.joystick1FieldsList);
        ArrayList<JTextField> all = new ArrayList<JTextField>(this.keyboardFieldsList);
        all.addAll(this.joysticksFieldsList);
        for (JTextField field : all) {
            field.setHighlighter(null);
        }
    }

    private void keyboardSetKeysDefaults() {
        Parameters.setDefaultKeysPreferences();
        this.keyboardResetEditField();
        this.refreshKeyboard();
    }

    private void joysticksSetDefaultOptions() {
        Parameters.setDefaultJoystickPreferences();
        this.joystickResetEditField();
        this.room.joystickControls().start();
        this.refreshJoysticks();
    }

    private void joystickSetEditField(MouseEvent e) {
        if (!this.room.joystickControls().isStarted()) {
            this.refreshJoysticks();
            return;
        }
        Object field = e.getSource();
        if (!(field instanceof JTextField) || !((JTextField)field).isEnabled()) {
            return;
        }
        this.joystickEditField = e.getSource();
        if (this.joystick0FieldsList.contains(this.joystickEditField) && this.room.joystickControls().getJoystick0() != null) {
            this.room.joystickControls().startButtonDetection(0, this);
        } else if (this.joystick1FieldsList.contains(this.joystickEditField) && this.room.joystickControls().getJoystick1() != null) {
            this.room.joystickControls().startButtonDetection(1, this);
        } else {
            return;
        }
        this.refreshJoysticks();
    }

    private void joystickResetEditField() {
        this.room.joystickControls().stopButtonDetection();
        this.joystickEditField = null;
    }

    @Override
    public void joystickButtonDetected(int joystick, int button) {
        if (this.joystickEditField == null) {
            return;
        }
        if (this.joystick0FieldsList.contains(this.joystickEditField) && joystick == 0) {
            this.joystickSetButton(button);
        } else if (this.joystick1FieldsList.contains(this.joystickEditField) && joystick == 1) {
            this.joystickSetButton(button);
        } else {
            this.joystickResetEditField();
        }
    }

    private void joystickSetButton(int button) {
        int joy;
        if (this.joystickEditField == null) {
            return;
        }
        if (this.joystick0FieldsList.contains(this.joystickEditField)) {
            joy = 0;
        } else if (this.joystick1FieldsList.contains(this.joystickEditField)) {
            joy = 1;
        } else {
            return;
        }
        this.unsetJoystickButton(joy, button);
        if (this.joystickEditField == this.joyP0Button) {
            Parameters.JOY_P0_BUTTON = button;
        } else if (this.joystickEditField == this.joyP0Button2) {
            Parameters.JOY_P0_BUTTON2 = button;
        } else if (this.joystickEditField == this.joyP0Reset) {
            Parameters.JOY_P0_RESET = button;
        } else if (this.joystickEditField == this.joyP0Select) {
            Parameters.JOY_P0_SELECT = button;
        } else if (this.joystickEditField == this.joyP0Pause) {
            Parameters.JOY_P0_PAUSE = button;
        } else if (this.joystickEditField == this.joyP0FastSpeed) {
            Parameters.JOY_P0_FAST_SPPED = button;
        } else if (this.joystickEditField == this.joyP1Button) {
            Parameters.JOY_P1_BUTTON = button;
        } else if (this.joystickEditField == this.joyP1Button2) {
            Parameters.JOY_P1_BUTTON2 = button;
        } else if (this.joystickEditField == this.joyP1Reset) {
            Parameters.JOY_P1_RESET = button;
        } else if (this.joystickEditField == this.joyP1Select) {
            Parameters.JOY_P1_SELECT = button;
        } else if (this.joystickEditField == this.joyP1Pause) {
            Parameters.JOY_P1_PAUSE = button;
        } else if (this.joystickEditField == this.joyP1FastSpeed) {
            Parameters.JOY_P1_FAST_SPPED = button;
        }
        this.joystickResetEditField();
        this.refreshJoysticks();
    }

    private void unsetJoystickButton(int joy, int button) {
        if (joy == 0 && Parameters.JOY_P0_BUTTON == button) {
            Parameters.JOY_P0_BUTTON = -1;
        }
        if (joy == 0 && Parameters.JOY_P0_BUTTON2 == button) {
            Parameters.JOY_P0_BUTTON2 = -1;
        }
        if (joy == 0 && Parameters.JOY_P0_RESET == button) {
            Parameters.JOY_P0_RESET = -1;
        }
        if (joy == 0 && Parameters.JOY_P0_SELECT == button) {
            Parameters.JOY_P0_SELECT = -1;
        }
        if (joy == 0 && Parameters.JOY_P0_PAUSE == button) {
            Parameters.JOY_P0_PAUSE = -1;
        }
        if (joy == 0 && Parameters.JOY_P0_FAST_SPPED == button) {
            Parameters.JOY_P0_FAST_SPPED = -1;
        }
        if (joy == 1 && Parameters.JOY_P1_BUTTON == button) {
            Parameters.JOY_P1_BUTTON = -1;
        }
        if (joy == 1 && Parameters.JOY_P1_BUTTON2 == button) {
            Parameters.JOY_P1_BUTTON2 = -1;
        }
        if (joy == 1 && Parameters.JOY_P1_RESET == button) {
            Parameters.JOY_P1_RESET = -1;
        }
        if (joy == 1 && Parameters.JOY_P1_SELECT == button) {
            Parameters.JOY_P1_SELECT = -1;
        }
        if (joy == 1 && Parameters.JOY_P1_PAUSE == button) {
            Parameters.JOY_P1_PAUSE = -1;
        }
        if (joy == 1 && Parameters.JOY_P1_FAST_SPPED == button) {
            Parameters.JOY_P1_FAST_SPPED = -1;
        }
    }

    private void setMultiplayerDefaults() {
        this.serverPortTf.setText(String.valueOf(Parameters.SERVER_SERVICE_PORT));
    }

    private void setupConnectionStatusListeners() {
        if (this.room == null) {
            return;
        }
        if (this.room.isServerMode()) {
            this.room.serverCurrentConsole().remoteTransmitter().addConnectionStatusListener(this);
        }
        if (this.room.isClientMode()) {
            this.room.clientCurrentConsole().remoteReceiver().addConnectionStatusListener(this);
        }
    }

    private void setEscActionListener() {
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.closeAction();
            }
        };
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESC");
        this.getRootPane().getActionMap().put("ESC", escapeAction);
    }

    protected void joyP0P1DeviceAction() {
        if (this.refreshInProgress) {
            return;
        }
        if (this.joyP0Device.isEnabled()) {
            JoystickConsoleControls.DeviceOption opt0 = (JoystickConsoleControls.DeviceOption)this.joyP0Device.getSelectedItem();
            int n = Parameters.JOY_P0_DEVICE = opt0 != null ? opt0.device : -99;
        }
        if (this.joyP1Device.isEnabled()) {
            JoystickConsoleControls.DeviceOption opt1 = (JoystickConsoleControls.DeviceOption)this.joyP1Device.getSelectedItem();
            Parameters.JOY_P1_DEVICE = opt1 != null ? opt1.device : -99;
        }
        this.room.joystickControls().start();
        this.refreshJoysticks();
    }

    protected void joyP0XAxisAction() {
        int i = this.joyP0XAxis.getSelectedIndex();
        if (this.room.joystickControls().paddleMode) {
            Parameters.JOY_P0_PAD_AXIS = JOY_AXIS_NUMBERS[i];
            Parameters.JOY_P0_PAD_AXIS_SIGNAL = JOY_AXIS_SIGNALS[i];
        } else {
            Parameters.JOY_P0_XAXIS = JOY_AXIS_NUMBERS[i];
            Parameters.JOY_P0_XAXIS_SIGNAL = JOY_AXIS_SIGNALS[i];
        }
        this.refreshJoysticks();
    }

    protected void joyP0YAxisAction() {
        if (this.room.joystickControls().paddleMode) {
            return;
        }
        int i = this.joyP0YAxis.getSelectedIndex();
        Parameters.JOY_P0_YAXIS = JOY_AXIS_NUMBERS[i];
        Parameters.JOY_P0_YAXIS_SIGNAL = JOY_AXIS_SIGNALS[i];
        this.refreshJoysticks();
    }

    protected void joyP0DeadzoneAction() {
        String val = this.joyP0Deadzone.getSelectedItem().toString().replaceAll("[^\\d-]", "");
        if (this.room.joystickControls().paddleMode) {
            Parameters.JOY_P0_PADDLE_CENTER = Integer.parseInt(val);
        } else {
            Parameters.JOY_P0_DEADZONE = Integer.parseInt(val);
        }
        this.refreshJoysticks();
    }

    protected void joyP0SensitivityAction() {
        if (!this.room.joystickControls().paddleMode) {
            return;
        }
        String val = this.joyP0Sensitivity.getSelectedItem().toString().replaceAll("[\\D]", "");
        Parameters.JOY_P0_PADDLE_SENS = val.isEmpty() ? 0 : Integer.parseInt(val);
        this.refreshJoysticks();
    }

    protected void joyP1XAxisAction() {
        int i = this.joyP1XAxis.getSelectedIndex();
        if (this.room.joystickControls().paddleMode) {
            Parameters.JOY_P1_PAD_AXIS = JOY_AXIS_NUMBERS[i];
            Parameters.JOY_P1_PAD_AXIS_SIGNAL = JOY_AXIS_SIGNALS[i];
        } else {
            Parameters.JOY_P1_XAXIS = JOY_AXIS_NUMBERS[i];
            Parameters.JOY_P1_XAXIS_SIGNAL = JOY_AXIS_SIGNALS[i];
        }
        this.refreshJoysticks();
    }

    protected void joyP1YAxisAction() {
        int i = this.joyP1YAxis.getSelectedIndex();
        Parameters.JOY_P1_YAXIS = JOY_AXIS_NUMBERS[i];
        Parameters.JOY_P1_YAXIS_SIGNAL = JOY_AXIS_SIGNALS[i];
        this.refreshJoysticks();
    }

    protected void joyP1DeadzoneAction() {
        String val = this.joyP1Deadzone.getSelectedItem().toString().replaceAll("[^\\d-]", "");
        if (this.room.joystickControls().paddleMode) {
            Parameters.JOY_P1_PADDLE_CENTER = Integer.parseInt(val);
        } else {
            Parameters.JOY_P1_DEADZONE = Integer.parseInt(val);
        }
        this.refreshJoysticks();
    }

    protected void joyP1SensitivityAction() {
        if (!this.room.joystickControls().paddleMode) {
            return;
        }
        String val = this.joyP1Sensitivity.getSelectedItem().toString().replaceAll("[\\D]", "");
        Parameters.JOY_P1_PADDLE_SENS = val.isEmpty() ? 0 : Integer.parseInt(val);
        this.refreshJoysticks();
    }

    private void mainTabbedPaneChanged() {
        if (!this.buildFinished) {
            return;
        }
        if (this.mainTabbedPane.getSelectedIndex() == 2) {
            this.joysticksPageEntered();
        } else {
            this.notJoysticksPageEntered();
        }
        this.refreshCurrentTab();
    }

    private void refreshCurrentTab() {
        this.keyboardResetEditField();
        this.joystickResetEditField();
        switch (this.mainTabbedPane.getSelectedIndex()) {
            case 0: {
                this.refreshMultiplayer();
                break;
            }
            case 1: {
                this.refreshKeyboard();
                break;
            }
            case 2: {
                this.refreshJoysticks();
                break;
            }
            case 3: {
                this.refreshCartridge();
                break;
            }
            default: {
                this.defaultsB.setVisible(false);
            }
        }
    }

    private void joysticksPageEntered() {
        this.room.joystickControls().start();
    }

    private void notJoysticksPageEntered() {
        this.room.joystickControls().stopButtonDetection();
    }

    private void officialWebPageAction() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        try {
            Desktop desktop = Desktop.getDesktop();
            if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                return;
            }
            this.closeAction();
            desktop.browse(new URI(Parameters.OFFICIAL_WEBSITE));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void twitterPageAction() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        try {
            Desktop desktop = Desktop.getDesktop();
            if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                return;
            }
            this.closeAction();
            desktop.browse(new URI(Parameters.TWITTER_WEBPAGE));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void serverStartAction() {
        if (!this.room.isServerMode()) {
            this.room.morphToServerMode();
            this.setupConnectionStatusListeners();
            try {
                RemoteTransmitter transmitter = this.room.serverCurrentConsole().remoteTransmitter();
                String portString = this.serverPortTf.getText().trim();
                try {
                    if (portString.isEmpty()) {
                        transmitter.start();
                    } else {
                        transmitter.start(Integer.valueOf(portString));
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid port number: " + portString);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Could not start Server:\n" + ex, "javatari P1 Server", 0);
                this.room.morphToStandaloneMode();
            }
        } else {
            try {
                RemoteTransmitter transmitter = this.room.serverCurrentConsole().remoteTransmitter();
                transmitter.stop();
                this.room.morphToStandaloneMode();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Error stopping Server:\n" + ex, "javatari P1 Server", 0);
            }
        }
        this.refreshMultiplayer();
    }

    private void clientConnectAction() {
        if (!this.room.isClientMode()) {
            this.room.morphToClientMode();
            this.setupConnectionStatusListeners();
            String serverAddress = "";
            try {
                RemoteReceiver receiver = this.room.clientCurrentConsole().remoteReceiver();
                serverAddress = this.clientServerAddressTf.getText().trim();
                receiver.connect(serverAddress);
                this.closeAction();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Connection failed: " + serverAddress + "\n" + ex, "javatari P2 Client", 0);
                this.room.morphToStandaloneMode();
            }
        } else {
            try {
                RemoteReceiver receiver = this.room.clientCurrentConsole().remoteReceiver();
                receiver.disconnect();
                this.room.morphToStandaloneMode();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Error disconnecting from Server:\n" + ex, "javatari P2 Client", 0);
            }
        }
        this.refreshMultiplayer();
    }

    private void defaultsAction() {
        switch (this.mainTabbedPane.getSelectedIndex()) {
            case 0: {
                this.setMultiplayerDefaults();
                break;
            }
            case 1: {
                this.keyboardSetKeysDefaults();
                break;
            }
            case 2: {
                this.joysticksSetDefaultOptions();
                break;
            }
            case 3: {
                this.cartridgeAutoDetect();
            }
        }
    }

    private void closeAction() {
        Parameters.savePreferences();
        this.room.awtControls().initPreferences();
        this.room.joystickControls().initPreferences();
        this.setVisible(false);
    }

    private void romFormatLbAction() {
        Object sel = this.romFormatLb.getSelectedValue();
        if (sel == null || !(sel instanceof CartridgeFormat)) {
            return;
        }
        CartridgeFormat format = (CartridgeFormat)sel;
        Console console = this.room.currentConsole();
        Cartridge cart = console.cartridgeSocket().inserted();
        if (cart == null || cart.format().equals(format)) {
            return;
        }
        Cartridge newCart = format.create(cart);
        console.cartridgeSocket().insert(newCart, true);
    }

    private void cartridgeAutoDetect() {
        Console console = this.room.currentConsole();
        Cartridge cart = console.cartridgeSocket().inserted();
        if (cart == null) {
            return;
        }
        ArrayList<CartridgeFormatOption> options = CartridgeDatabase.getFormatOptions(cart);
        if (options.isEmpty()) {
            return;
        }
        Cartridge newCart = options.get((int)0).format.create(cart);
        console.cartridgeSocket().insert(newCart, true);
        this.refreshCartridge();
    }

    private void loadImages() {
        try {
            BufferedImage image = GraphicsDeviceHelper.loadAsCompatibleTranslucentImage("org/javatari/pc/room/settings/images/Joystick.png");
            this.joystickIcon = new ImageIcon(image);
            this.joystickIconGrayed = new ImageIcon(GrayFilter.createDisabledImage(image));
            image = GraphicsDeviceHelper.loadAsCompatibleTranslucentImage("org/javatari/pc/room/settings/images/Paddle.png");
            this.paddleIcon = new ImageIcon(image);
            this.paddleIconGrayed = new ImageIcon(GrayFilter.createDisabledImage(image));
        }
        catch (IOException ex) {
            System.out.println("SettingsDialog: unable to load images\n" + ex);
        }
    }

    private void buildGUI() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(SettingsDialog.class.getResource("/org/javatari/pc/screen/images/Favicon.png")));
        this.setTitle("javatari");
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SettingsDialog.this.closeAction();
            }
        });
        final AbstractAction toggleP1ModeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.room.awtControls().toggleP1ControlsMode();
                SettingsDialog.this.refreshCurrentTab();
            }
        };
        final AbstractAction togglePaddlesAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.room.awtControls().togglePaddleMode();
                SettingsDialog.this.refreshCurrentTab();
            }
        };
        final AbstractAction toggleJoystickAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.room.joystickControls().toggleMode();
                SettingsDialog.this.refreshCurrentTab();
            }
        };
        final AbstractAction cycleROMFormatAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.room.currentConsole().controlsSocket().controlStateChanged(ConsoleControls.Control.CARTRIDGE_FORMAT, true);
                SettingsDialog.this.refreshCurrentTab();
            }
        };
        String fontName = "SansSerif";
        int adjust = 0;
        if (Environment.ARIAL_FONT) {
            fontName = "Arial";
        } else if (Environment.LIBERATION_FONT) {
            fontName = "Liberation Sans";
        } else {
            adjust = -1;
        }
        Font fontFields = new Font(fontName, 0, 11);
        Font fontLabel = new Font(fontName, 0, 13 + adjust);
        Font fontLabelBold = new Font(fontName, 1, 13 + adjust);
        Font fontLabelMedium = new Font(fontName, 0, 14 + adjust);
        Font fontLabelMediumBold = new Font(fontName, 1, 14 + adjust);
        Font fontLabelLarge = new Font(fontName, 0, 16 + adjust);
        Font fontLabelLargeBold = new Font(fontName, 1, 16 + adjust);
        Color noBackground = new Color(0, 0, 0, 0);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.mainTabbedPane = new JTabbedPane(1);
        if (Environment.NIMBUS_LAF) {
            this.mainTabbedPane.setBorder(new DeepBorder(13, new Insets(7, 2, 6, 2)));
        }
        this.mainTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SettingsDialog.this.mainTabbedPaneChanged();
            }
        });
        this.mainTabbedPane.setFont(fontLabel);
        this.mainTabbedPane.setBackground(UIManager.getColor("TabbedPane.background"));
        this.contentPanel.add((Component)this.mainTabbedPane, "Center");
        JPanel multiplayerPanel = new JPanel();
        this.mainTabbedPane.addTab("Multiplayer", null, multiplayerPanel, null);
        multiplayerPanel.setLayout(null);
        multiplayerPanel.setPreferredSize(INTERNAL_TAB_SIZE);
        this.clientConsoleL = new JLabel("");
        this.clientConsoleL.setIcon(new ImageIcon(SettingsDialog.class.getResource("/org/javatari/pc/room/settings/images/ServerClientConsole.png")));
        this.clientConsoleL.setBounds(316, 132, 139, 94);
        multiplayerPanel.add(this.clientConsoleL);
        this.serverConsoleL = new JLabel("");
        this.serverConsoleL.setIcon(new ImageIcon(SettingsDialog.class.getResource("/org/javatari/pc/room/settings/images/ServerClientConsole.png")));
        this.serverConsoleL.setBounds(12, 132, 139, 94);
        multiplayerPanel.add(this.serverConsoleL);
        this.networkL = new JLabel("");
        this.networkL.setIcon(new ImageIcon(SettingsDialog.class.getResource("/org/javatari/pc/room/settings/images/Network.png")));
        this.networkL.setBounds(116, 81, 237, 98);
        multiplayerPanel.add(this.networkL);
        JLabel lblNewLabel_1 = new JLabel("P1 Server");
        lblNewLabel_1.setFont(fontLabelLargeBold);
        lblNewLabel_1.setHorizontalAlignment(0);
        lblNewLabel_1.setBounds(24, 13, 100, 20);
        multiplayerPanel.add(lblNewLabel_1);
        this.serverStartB = new JButton("START");
        this.serverStartB.setFont(fontLabel);
        this.serverStartB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.serverStartAction();
            }
        });
        this.serverStartB.setBounds(20, 36, 108, 26);
        multiplayerPanel.add(this.serverStartB);
        this.clientConnectB = new JButton("JOIN");
        this.clientConnectB.setFont(fontLabel);
        this.clientConnectB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.clientConnectAction();
            }
        });
        this.clientConnectB.setBounds(341, 36, 108, 26);
        multiplayerPanel.add(this.clientConnectB);
        this.clientServerAddressTf = new JTextFieldNim();
        this.clientServerAddressTf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.clientConnectAction();
            }
        });
        this.clientServerAddressTf.setFont(fontLabel);
        this.clientServerAddressTf.setBounds(335, 85, 121, 25);
        multiplayerPanel.add(this.clientServerAddressTf);
        this.clientServerAddressTf.setColumns(10);
        JLabel lblServerAddressport = new JLabel("Server address [:port]");
        lblServerAddressport.setHorizontalAlignment(0);
        lblServerAddressport.setFont(fontLabel);
        lblServerAddressport.setBounds(323, 70, 144, 15);
        multiplayerPanel.add(lblServerAddressport);
        this.serverPortTf = new JTextFieldNim();
        this.serverPortTf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.serverStartAction();
            }
        });
        this.serverPortTf.setFont(fontLabel);
        this.serverPortTf.setHorizontalAlignment(4);
        this.serverPortTf.setColumns(10);
        this.serverPortTf.setBounds(41, 85, 66, 25);
        multiplayerPanel.add(this.serverPortTf);
        JLabel lblPort = new JLabel("Server port");
        lblPort.setHorizontalAlignment(0);
        lblPort.setFont(fontLabel);
        lblPort.setBounds(32, 70, 82, 15);
        multiplayerPanel.add(lblPort);
        JLabel lblPClient = new JLabel("P2 Client");
        lblPClient.setHorizontalAlignment(0);
        lblPClient.setFont(fontLabelLargeBold);
        lblPClient.setBounds(345, 13, 100, 20);
        multiplayerPanel.add(lblPClient);
        this.multiplayerModeL = new JLabel("P1 SERVER MODE");
        this.multiplayerModeL.setFont(fontLabelMediumBold);
        this.multiplayerModeL.setOpaque(false);
        this.multiplayerModeL.setBorder(new DeepBorder(10, new Insets(5, 5, 5, 5)));
        this.multiplayerModeL.setHorizontalAlignment(0);
        this.multiplayerModeL.setBounds(148, 34, 174, 30);
        multiplayerPanel.add(this.multiplayerModeL);
        this.standaloneConsoleL = new JLabel("");
        this.standaloneConsoleL.setIcon(new ImageIcon(SettingsDialog.class.getResource("/org/javatari/pc/room/settings/images/StandaloneConsole.png")));
        this.standaloneConsoleL.setBounds(120, 90, 202, 146);
        multiplayerPanel.add(this.standaloneConsoleL);
        this.keyboardPanel = new JPanel();
        this.mainTabbedPane.addTab("Keyboard", null, this.keyboardPanel, null);
        this.keyboardPanel.setLayout(null);
        this.keyboardPanel.setPreferredSize(INTERNAL_TAB_SIZE);
        this.keyboard0Icon = new JLabel("");
        this.keyboard0Icon.setIcon(this.joystickIcon);
        this.keyboard0Icon.setBounds(70, 91, 75, 90);
        this.keyboardPanel.add(this.keyboard0Icon);
        this.keyP0Up = new JTextFieldNim();
        this.keyP0Up.setDisabledTextColor(Color.GRAY);
        this.keyP0Up.setBackground(Color.WHITE);
        this.keyP0Up.setEditable(false);
        this.keyP0Up.setFont(fontFields);
        this.keyP0Up.setHorizontalAlignment(0);
        this.keyP0Up.setBounds(85, 67, 44, 23);
        this.keyP0Up.setColumns(10);
        this.keyboardPanel.add(this.keyP0Up);
        this.keyP0Right = new JTextFieldNim();
        this.keyP0Right.setDisabledTextColor(Color.GRAY);
        this.keyP0Right.setBackground(Color.WHITE);
        this.keyP0Right.setEditable(false);
        this.keyP0Right.setFont(fontFields);
        this.keyP0Right.setHorizontalAlignment(0);
        this.keyP0Right.setColumns(10);
        this.keyP0Right.setBounds(151, 130, 45, 23);
        this.keyboardPanel.add(this.keyP0Right);
        this.keyP0Left = new JTextFieldNim();
        this.keyP0Left.setDisabledTextColor(Color.GRAY);
        this.keyP0Left.setBackground(Color.WHITE);
        this.keyP0Left.setEditable(false);
        this.keyP0Left.setFont(fontFields);
        this.keyP0Left.setHorizontalAlignment(0);
        this.keyP0Left.setColumns(10);
        this.keyP0Left.setBounds(19, 130, 45, 23);
        this.keyboardPanel.add(this.keyP0Left);
        this.keyP0Down = new JTextFieldNim();
        this.keyP0Down.setDisabledTextColor(Color.GRAY);
        this.keyP0Down.setBackground(Color.WHITE);
        this.keyP0Down.setEditable(false);
        this.keyP0Down.setFont(fontFields);
        this.keyP0Down.setHorizontalAlignment(0);
        this.keyP0Down.setColumns(10);
        this.keyP0Down.setBounds(85, 194, 45, 23);
        this.keyboardPanel.add(this.keyP0Down);
        JLabel lblRight = new JLabel("Right");
        lblRight.setFont(fontLabel);
        lblRight.setHorizontalAlignment(0);
        lblRight.setBounds(153, 116, 40, 15);
        this.keyboardPanel.add(lblRight);
        JLabel lblLeft = new JLabel("Left");
        lblLeft.setFont(fontLabel);
        lblLeft.setHorizontalAlignment(0);
        lblLeft.setBounds(21, 116, 40, 14);
        this.keyboardPanel.add(lblLeft);
        this.keyP0DownL = new JLabel("Down");
        this.keyP0DownL.setFont(fontLabel);
        this.keyP0DownL.setHorizontalAlignment(0);
        this.keyP0DownL.setBounds(78, 180, 58, 14);
        this.keyboardPanel.add(this.keyP0DownL);
        this.keyP0UpL = new JLabel("Up");
        this.keyP0UpL.setFont(fontLabel);
        this.keyP0UpL.setHorizontalAlignment(0);
        this.keyP0UpL.setBounds(78, 53, 58, 14);
        this.keyboardPanel.add(this.keyP0UpL);
        this.keyP0Button = new JTextFieldNim();
        this.keyP0Button.setDisabledTextColor(Color.GRAY);
        this.keyP0Button.setBackground(Color.WHITE);
        this.keyP0Button.setEditable(false);
        this.keyP0Button.setFont(fontFields);
        this.keyP0Button.setHorizontalAlignment(0);
        this.keyP0Button.setColumns(10);
        this.keyP0Button.setBounds(29, 79, 44, 23);
        this.keyboardPanel.add(this.keyP0Button);
        JLabel lblFire = new JLabel("Fire 1");
        lblFire.setFont(fontLabel);
        lblFire.setHorizontalAlignment(0);
        lblFire.setBounds(31, 65, 40, 14);
        this.keyboardPanel.add(lblFire);
        this.keyboardPlayer1Lb = new JLabel("Player 1");
        this.keyboardPlayer1Lb.setFont(fontLabelLargeBold);
        this.keyboardPlayer1Lb.setHorizontalAlignment(0);
        this.keyboardPlayer1Lb.setBounds(70, 22, 74, 20);
        this.keyboardPanel.add(this.keyboardPlayer1Lb);
        JLabel lblFire_1 = new JLabel("Fire 2");
        lblFire_1.setFont(fontLabel);
        lblFire_1.setHorizontalAlignment(0);
        lblFire_1.setBounds(143, 65, 40, 14);
        this.keyboardPanel.add(lblFire_1);
        this.keyP0Button2 = new JTextFieldNim();
        this.keyP0Button2.setDisabledTextColor(Color.GRAY);
        this.keyP0Button2.setBackground(Color.WHITE);
        this.keyP0Button2.setEditable(false);
        this.keyP0Button2.setFont(fontFields);
        this.keyP0Button2.setHorizontalAlignment(0);
        this.keyP0Button2.setColumns(10);
        this.keyP0Button2.setBounds(141, 79, 44, 23);
        this.keyboardPanel.add(this.keyP0Button2);
        JLabel txtpnAltK_1 = new JLabel();
        txtpnAltK_1.setHorizontalTextPosition(0);
        txtpnAltK_1.setHorizontalAlignment(0);
        txtpnAltK_1.setOpaque(false);
        txtpnAltK_1.setFont(fontLabel);
        txtpnAltK_1.setText("ALT + K: Swap Controls");
        txtpnAltK_1.setBounds(143, 215, 185, 21);
        this.keyboardPanel.add(txtpnAltK_1);
        txtpnAltK_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                toggleP1ModeAction.actionPerformed(null);
            }
        });
        this.keyboard1Icon = new JLabel("");
        this.keyboard1Icon.setIcon(this.joystickIcon);
        this.keyboard1Icon.setBounds(327, 91, 75, 90);
        this.keyboardPanel.add(this.keyboard1Icon);
        this.keyP1Up = new JTextFieldNim();
        this.keyP1Up.setDisabledTextColor(Color.GRAY);
        this.keyP1Up.setHorizontalAlignment(0);
        this.keyP1Up.setFont(fontFields);
        this.keyP1Up.setEditable(false);
        this.keyP1Up.setColumns(10);
        this.keyP1Up.setBackground(Color.WHITE);
        this.keyP1Up.setBounds(342, 67, 44, 23);
        this.keyboardPanel.add(this.keyP1Up);
        this.keyP1Right = new JTextFieldNim();
        this.keyP1Right.setDisabledTextColor(Color.GRAY);
        this.keyP1Right.setHorizontalAlignment(0);
        this.keyP1Right.setFont(fontFields);
        this.keyP1Right.setEditable(false);
        this.keyP1Right.setColumns(10);
        this.keyP1Right.setBackground(Color.WHITE);
        this.keyP1Right.setBounds(407, 130, 45, 23);
        this.keyboardPanel.add(this.keyP1Right);
        this.keyP1Left = new JTextFieldNim();
        this.keyP1Left.setDisabledTextColor(Color.GRAY);
        this.keyP1Left.setHorizontalAlignment(0);
        this.keyP1Left.setFont(fontFields);
        this.keyP1Left.setEditable(false);
        this.keyP1Left.setColumns(10);
        this.keyP1Left.setBackground(Color.WHITE);
        this.keyP1Left.setBounds(276, 130, 45, 23);
        this.keyboardPanel.add(this.keyP1Left);
        this.keyP1Down = new JTextFieldNim();
        this.keyP1Down.setDisabledTextColor(Color.GRAY);
        this.keyP1Down.setHorizontalAlignment(0);
        this.keyP1Down.setFont(fontFields);
        this.keyP1Down.setEditable(false);
        this.keyP1Down.setColumns(10);
        this.keyP1Down.setBackground(Color.WHITE);
        this.keyP1Down.setBounds(342, 194, 45, 23);
        this.keyboardPanel.add(this.keyP1Down);
        JLabel label_1 = new JLabel("Right");
        label_1.setHorizontalAlignment(0);
        label_1.setFont(fontLabel);
        label_1.setBounds(409, 116, 40, 15);
        this.keyboardPanel.add(label_1);
        JLabel label_2 = new JLabel("Left");
        label_2.setHorizontalAlignment(0);
        label_2.setFont(fontLabel);
        label_2.setBounds(278, 116, 40, 14);
        this.keyboardPanel.add(label_2);
        this.keyP1DownL = new JLabel("Down");
        this.keyP1DownL.setHorizontalAlignment(0);
        this.keyP1DownL.setFont(fontLabel);
        this.keyP1DownL.setBounds(335, 180, 58, 14);
        this.keyboardPanel.add(this.keyP1DownL);
        this.keyP1UpL = new JLabel("Up");
        this.keyP1UpL.setHorizontalAlignment(0);
        this.keyP1UpL.setFont(fontLabel);
        this.keyP1UpL.setBounds(335, 53, 58, 14);
        this.keyboardPanel.add(this.keyP1UpL);
        this.keyP1Button = new JTextFieldNim();
        this.keyP1Button.setDisabledTextColor(Color.GRAY);
        this.keyP1Button.setHorizontalAlignment(0);
        this.keyP1Button.setFont(fontFields);
        this.keyP1Button.setEditable(false);
        this.keyP1Button.setColumns(10);
        this.keyP1Button.setBackground(Color.WHITE);
        this.keyP1Button.setBounds(286, 79, 44, 23);
        this.keyboardPanel.add(this.keyP1Button);
        JLabel label_5 = new JLabel("Fire 1");
        label_5.setHorizontalAlignment(0);
        label_5.setFont(fontLabel);
        label_5.setBounds(288, 65, 40, 14);
        this.keyboardPanel.add(label_5);
        this.keyboardPlayer2Lb = new JLabel("Player 2");
        this.keyboardPlayer2Lb.setHorizontalAlignment(0);
        this.keyboardPlayer2Lb.setFont(fontLabelLargeBold);
        this.keyboardPlayer2Lb.setBounds(327, 22, 74, 20);
        this.keyboardPanel.add(this.keyboardPlayer2Lb);
        JLabel label_7 = new JLabel("Fire 2");
        label_7.setHorizontalAlignment(0);
        label_7.setFont(fontLabel);
        label_7.setBounds(399, 65, 40, 14);
        this.keyboardPanel.add(label_7);
        this.keyP1Button2 = new JTextFieldNim();
        this.keyP1Button2.setDisabledTextColor(Color.GRAY);
        this.keyP1Button2.setHorizontalAlignment(0);
        this.keyP1Button2.setFont(fontFields);
        this.keyP1Button2.setEditable(false);
        this.keyP1Button2.setColumns(10);
        this.keyP1Button2.setBackground(Color.WHITE);
        this.keyP1Button2.setBounds(397, 79, 44, 23);
        this.keyboardPanel.add(this.keyP1Button2);
        this.keyboardMessageL = new JLabel("");
        this.keyboardMessageL.setHorizontalAlignment(0);
        this.keyboardMessageL.setFont(fontLabel);
        this.keyboardMessageL.setBounds(165, 25, 141, 15);
        this.keyboardPanel.add(this.keyboardMessageL);
        JLabel txtpnAltL = new JLabel();
        txtpnAltL.setHorizontalTextPosition(0);
        txtpnAltL.setHorizontalAlignment(0);
        txtpnAltL.setText("ALT + L: Toggle Paddles");
        txtpnAltL.setOpaque(false);
        txtpnAltL.setFont(fontLabel);
        txtpnAltL.setBounds(143, 235, 185, 21);
        this.keyboardPanel.add(txtpnAltL);
        txtpnAltL.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                togglePaddlesAction.actionPerformed(null);
            }
        });
        this.joysticksPanel = new JPanel();
        this.joysticksPanel.setLayout(null);
        this.joysticksPanel.setPreferredSize(INTERNAL_TAB_SIZE);
        this.mainTabbedPane.addTab("Joysticks", null, this.joysticksPanel, null);
        this.joystick0Icon = new JLabel("");
        this.joystick0Icon.setIcon(this.joystickIcon);
        this.joystick0Icon.setBounds(70, 91, 75, 90);
        this.joysticksPanel.add(this.joystick0Icon);
        this.joyP0Reset = new JTextFieldNim();
        this.joyP0Reset.setDisabledTextColor(Color.GRAY);
        this.joyP0Reset.setEnabled(false);
        this.joyP0Reset.setName("joyP0Reset");
        this.joyP0Reset.setHorizontalAlignment(0);
        this.joyP0Reset.setFont(fontFields);
        this.joyP0Reset.setEditable(false);
        this.joyP0Reset.setColumns(10);
        this.joyP0Reset.setBackground(Color.WHITE);
        this.joyP0Reset.setBounds(85, 194, 44, 23);
        this.joysticksPanel.add(this.joyP0Reset);
        this.joyP0Pause = new JTextFieldNim();
        this.joyP0Pause.setDisabledTextColor(Color.GRAY);
        this.joyP0Pause.setEnabled(false);
        this.joyP0Pause.setName("joyP0Pause");
        this.joyP0Pause.setHorizontalAlignment(0);
        this.joyP0Pause.setFont(fontFields);
        this.joyP0Pause.setEditable(false);
        this.joyP0Pause.setColumns(10);
        this.joyP0Pause.setBackground(Color.WHITE);
        this.joyP0Pause.setBounds(85, 232, 44, 23);
        this.joysticksPanel.add(this.joyP0Pause);
        JLabel lblSelect = new JLabel("Select");
        lblSelect.setHorizontalAlignment(0);
        lblSelect.setFont(fontLabel);
        lblSelect.setBounds(28, 180, 40, 15);
        this.joysticksPanel.add(lblSelect);
        JLabel lblFire_2 = new JLabel("Pause");
        lblFire_2.setHorizontalAlignment(0);
        lblFire_2.setFont(fontLabel);
        lblFire_2.setBounds(87, 218, 40, 14);
        this.joysticksPanel.add(lblFire_2);
        this.joyP0Button2 = new JTextFieldNim();
        this.joyP0Button2.setDisabledTextColor(Color.GRAY);
        this.joyP0Button2.setEnabled(false);
        this.joyP0Button2.setName("joyP0Button2");
        this.joyP0Button2.setHorizontalAlignment(0);
        this.joyP0Button2.setFont(fontFields);
        this.joyP0Button2.setEditable(false);
        this.joyP0Button2.setColumns(10);
        this.joyP0Button2.setBackground(Color.WHITE);
        this.joyP0Button2.setBounds(141, 79, 44, 23);
        this.joysticksPanel.add(this.joyP0Button2);
        JLabel lblFire_5 = new JLabel("Fire 2");
        lblFire_5.setHorizontalAlignment(0);
        lblFire_5.setFont(fontLabel);
        lblFire_5.setBounds(143, 65, 40, 14);
        this.joysticksPanel.add(lblFire_5);
        this.joysticksPlayer1Lb = new JLabel("Player 1");
        this.joysticksPlayer1Lb.setHorizontalAlignment(0);
        this.joysticksPlayer1Lb.setFont(fontLabelLargeBold);
        this.joysticksPlayer1Lb.setBounds(78, 6, 74, 20);
        this.joysticksPanel.add(this.joysticksPlayer1Lb);
        JLabel lblReset = new JLabel("Fire 1");
        lblReset.setHorizontalAlignment(0);
        lblReset.setFont(fontLabel);
        lblReset.setBounds(31, 65, 40, 15);
        this.joysticksPanel.add(lblReset);
        this.joyP0Button = new JTextFieldNim();
        this.joyP0Button.setDisabledTextColor(Color.GRAY);
        this.joyP0Button.setEnabled(false);
        this.joyP0Button.setName("joyP0Button");
        this.joyP0Button.setHorizontalAlignment(0);
        this.joyP0Button.setFont(fontFields);
        this.joyP0Button.setEditable(false);
        this.joyP0Button.setColumns(10);
        this.joyP0Button.setBackground(Color.WHITE);
        this.joyP0Button.setBounds(29, 79, 44, 23);
        this.joysticksPanel.add(this.joyP0Button);
        this.joystick1Icon = new JLabel("");
        this.joystick1Icon.setIcon(this.joystickIcon);
        this.joystick1Icon.setBounds(327, 91, 75, 90);
        this.joysticksPanel.add(this.joystick1Icon);
        this.joyP1Pause = new JTextFieldNim();
        this.joyP1Pause.setDisabledTextColor(Color.GRAY);
        this.joyP1Pause.setEnabled(false);
        this.joyP1Pause.setName("joyP1Pause");
        this.joyP1Pause.setHorizontalAlignment(0);
        this.joyP1Pause.setFont(fontFields);
        this.joyP1Pause.setEditable(false);
        this.joyP1Pause.setColumns(10);
        this.joyP1Pause.setBackground(Color.WHITE);
        this.joyP1Pause.setBounds(400, 232, 44, 23);
        this.joysticksPanel.add(this.joyP1Pause);
        JLabel lblFire_3 = new JLabel("Pause");
        lblFire_3.setHorizontalAlignment(0);
        lblFire_3.setFont(fontLabel);
        lblFire_3.setBounds(402, 218, 40, 14);
        this.joysticksPanel.add(lblFire_3);
        this.joysticksPlayer2Lb = new JLabel("Player 2");
        this.joysticksPlayer2Lb.setHorizontalAlignment(0);
        this.joysticksPlayer2Lb.setFont(fontLabelLargeBold);
        this.joysticksPlayer2Lb.setBounds(319, 6, 74, 20);
        this.joysticksPanel.add(this.joysticksPlayer2Lb);
        JLabel lblFire_4 = new JLabel("Fire 1");
        lblFire_4.setHorizontalAlignment(0);
        lblFire_4.setFont(fontLabel);
        lblFire_4.setBounds(288, 65, 40, 14);
        this.joysticksPanel.add(lblFire_4);
        this.joyP1Button = new JTextFieldNim();
        this.joyP1Button.setDisabledTextColor(Color.GRAY);
        this.joyP1Button.setEnabled(false);
        this.joyP1Button.setName("joyP1Button");
        this.joyP1Button.setHorizontalAlignment(0);
        this.joyP1Button.setFont(fontFields);
        this.joyP1Button.setEditable(false);
        this.joyP1Button.setColumns(10);
        this.joyP1Button.setBackground(Color.WHITE);
        this.joyP1Button.setBounds(286, 79, 44, 23);
        this.joysticksPanel.add(this.joyP1Button);
        this.joysticksMessageL = new JLabel("");
        this.joysticksMessageL.setHorizontalAlignment(0);
        this.joysticksMessageL.setFont(fontLabel);
        this.joysticksMessageL.setBounds(160, 9, 151, 15);
        this.joysticksPanel.add(this.joysticksMessageL);
        JLabel txtpnAltJ_1 = new JLabel();
        txtpnAltJ_1.setHorizontalTextPosition(0);
        txtpnAltJ_1.setHorizontalAlignment(0);
        txtpnAltJ_1.setText("ALT + J: Swap Joysticks");
        txtpnAltJ_1.setOpaque(false);
        txtpnAltJ_1.setFont(fontLabel);
        txtpnAltJ_1.setBounds(155, 215, 163, 21);
        this.joysticksPanel.add(txtpnAltJ_1);
        txtpnAltJ_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                toggleJoystickAction.actionPerformed(null);
            }
        });
        JLabel txtpnAltL_2 = new JLabel();
        txtpnAltL_2.setHorizontalTextPosition(0);
        txtpnAltL_2.setHorizontalAlignment(0);
        txtpnAltL_2.setText("ALT + L: Toggle Paddles");
        txtpnAltL_2.setOpaque(false);
        txtpnAltL_2.setFont(fontLabel);
        txtpnAltL_2.setBounds(146, 235, 179, 21);
        this.joysticksPanel.add(txtpnAltL_2);
        txtpnAltL_2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                togglePaddlesAction.actionPerformed(null);
            }
        });
        JLabel lblFastSpeed = new JLabel("Reset");
        lblFastSpeed.setHorizontalAlignment(0);
        lblFastSpeed.setFont(fontLabel);
        lblFastSpeed.setBounds(87, 180, 40, 15);
        this.joysticksPanel.add(lblFastSpeed);
        this.joyP0Select = new JTextFieldNim();
        this.joyP0Select.setDisabledTextColor(Color.GRAY);
        this.joyP0Select.setEnabled(false);
        this.joyP0Select.setName("joyP0Select");
        this.joyP0Select.setHorizontalAlignment(0);
        this.joyP0Select.setFont(fontFields);
        this.joyP0Select.setEditable(false);
        this.joyP0Select.setColumns(10);
        this.joyP0Select.setBackground(Color.WHITE);
        this.joyP0Select.setBounds(26, 194, 44, 23);
        this.joysticksPanel.add(this.joyP0Select);
        this.joyP1Select = new JTextFieldNim();
        this.joyP1Select.setDisabledTextColor(Color.GRAY);
        this.joyP1Select.setEnabled(false);
        this.joyP1Select.setName("joyP1Select");
        this.joyP1Select.setHorizontalAlignment(0);
        this.joyP1Select.setFont(fontFields);
        this.joyP1Select.setEditable(false);
        this.joyP1Select.setColumns(10);
        this.joyP1Select.setBackground(Color.WHITE);
        this.joyP1Select.setBounds(342, 194, 44, 23);
        this.joysticksPanel.add(this.joyP1Select);
        JLabel lblSelect_1 = new JLabel("Reset");
        lblSelect_1.setHorizontalAlignment(0);
        lblSelect_1.setFont(fontLabel);
        lblSelect_1.setBounds(402, 180, 40, 15);
        this.joysticksPanel.add(lblSelect_1);
        this.joyP1Reset = new JTextFieldNim();
        this.joyP1Reset.setDisabledTextColor(Color.GRAY);
        this.joyP1Reset.setEnabled(false);
        this.joyP1Reset.setName("joyP1Reset");
        this.joyP1Reset.setHorizontalAlignment(0);
        this.joyP1Reset.setFont(fontFields);
        this.joyP1Reset.setEditable(false);
        this.joyP1Reset.setColumns(10);
        this.joyP1Reset.setBackground(Color.WHITE);
        this.joyP1Reset.setBounds(400, 194, 44, 23);
        this.joysticksPanel.add(this.joyP1Reset);
        this.joyP1Button2 = new JTextFieldNim();
        this.joyP1Button2.setEnabled(false);
        this.joyP1Button2.setDisabledTextColor(Color.GRAY);
        this.joyP1Button2.setName("joyP1Button2");
        this.joyP1Button2.setHorizontalAlignment(0);
        this.joyP1Button2.setFont(fontFields);
        this.joyP1Button2.setEditable(false);
        this.joyP1Button2.setColumns(10);
        this.joyP1Button2.setBackground(Color.WHITE);
        this.joyP1Button2.setBounds(397, 79, 44, 23);
        this.joysticksPanel.add(this.joyP1Button2);
        JLabel lblReset_1 = new JLabel("Select");
        lblReset_1.setHorizontalAlignment(0);
        lblReset_1.setFont(fontLabel);
        lblReset_1.setBounds(344, 180, 40, 14);
        this.joysticksPanel.add(lblReset_1);
        JLabel lblFastSpeed_1 = new JLabel("Fire 2");
        lblFastSpeed_1.setHorizontalAlignment(0);
        lblFastSpeed_1.setFont(fontLabel);
        lblFastSpeed_1.setBounds(399, 65, 40, 15);
        this.joysticksPanel.add(lblFastSpeed_1);
        this.joyP0Deadzone = new JComboBoxNim();
        this.joyP0Deadzone.setFont(fontFields);
        this.joyP0Deadzone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.joyP0DeadzoneAction();
            }
        });
        this.joyP0Deadzone.setModel(new DefaultComboBoxModel<String>(JOY_DEADZONE_OPTIONS));
        this.joyP0Deadzone.setBounds(152, 121, 64, 23);
        this.joysticksPanel.add(this.joyP0Deadzone);
        this.joyP0DeadzoneL = new JLabel("Dead zone");
        this.joyP0DeadzoneL.setHorizontalAlignment(0);
        this.joyP0DeadzoneL.setFont(fontLabel);
        this.joyP0DeadzoneL.setBounds(149, 107, 71, 15);
        this.joysticksPanel.add(this.joyP0DeadzoneL);
        this.joyP1Deadzone = new JComboBoxNim();
        this.joyP1Deadzone.setFont(fontFields);
        this.joyP1Deadzone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.joyP1DeadzoneAction();
            }
        });
        this.joyP1Deadzone.setModel(new DefaultComboBoxModel<String>(JOY_DEADZONE_OPTIONS));
        this.joyP1Deadzone.setBounds(257, 121, 64, 23);
        this.joysticksPanel.add(this.joyP1Deadzone);
        this.joyP1DeadzoneL = new JLabel("Dead zone");
        this.joyP1DeadzoneL.setHorizontalAlignment(0);
        this.joyP1DeadzoneL.setFont(fontLabel);
        this.joyP1DeadzoneL.setBounds(254, 107, 71, 15);
        this.joysticksPanel.add(this.joyP1DeadzoneL);
        this.joyP0FastSpeed = new JTextFieldNim();
        this.joyP0FastSpeed.setName("joyP0FastSpeed");
        this.joyP0FastSpeed.setHorizontalAlignment(0);
        this.joyP0FastSpeed.setFont(fontFields);
        this.joyP0FastSpeed.setEnabled(false);
        this.joyP0FastSpeed.setEditable(false);
        this.joyP0FastSpeed.setDisabledTextColor(Color.GRAY);
        this.joyP0FastSpeed.setColumns(10);
        this.joyP0FastSpeed.setBackground(Color.WHITE);
        this.joyP0FastSpeed.setBounds(26, 232, 44, 23);
        this.joysticksPanel.add(this.joyP0FastSpeed);
        JLabel lblFast = new JLabel("Fast");
        lblFast.setHorizontalAlignment(0);
        lblFast.setFont(fontLabel);
        lblFast.setBounds(28, 218, 40, 15);
        this.joysticksPanel.add(lblFast);
        this.joyP1FastSpeed = new JTextFieldNim();
        this.joyP1FastSpeed.setName("joyP1FastSpeed");
        this.joyP1FastSpeed.setHorizontalAlignment(0);
        this.joyP1FastSpeed.setFont(fontFields);
        this.joyP1FastSpeed.setEnabled(false);
        this.joyP1FastSpeed.setEditable(false);
        this.joyP1FastSpeed.setDisabledTextColor(Color.GRAY);
        this.joyP1FastSpeed.setColumns(10);
        this.joyP1FastSpeed.setBackground(Color.WHITE);
        this.joyP1FastSpeed.setBounds(342, 232, 44, 23);
        this.joysticksPanel.add(this.joyP1FastSpeed);
        JLabel lblFast_1 = new JLabel("Fast");
        lblFast_1.setHorizontalAlignment(0);
        lblFast_1.setFont(fontLabel);
        lblFast_1.setBounds(344, 218, 40, 15);
        this.joysticksPanel.add(lblFast_1);
        this.joyP0Sensitivity = new JComboBoxNim();
        this.joyP0Sensitivity.setFont(fontFields);
        this.joyP0Sensitivity.setModel(new DefaultComboBoxModel<String>(PADDLE_SENS_OPTIONS));
        this.joyP0Sensitivity.setBounds(152, 163, 64, 23);
        this.joysticksPanel.add(this.joyP0Sensitivity);
        this.joyP0Sensitivity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.joyP0SensitivityAction();
            }
        });
        JLabel lblPaddleSens = new JLabel("Sensitivity");
        lblPaddleSens.setHorizontalAlignment(0);
        lblPaddleSens.setFont(fontLabel);
        lblPaddleSens.setBounds(149, 149, 71, 15);
        this.joysticksPanel.add(lblPaddleSens);
        this.joyP1Sensitivity = new JComboBoxNim();
        this.joyP1Sensitivity.setFont(fontFields);
        this.joyP1Sensitivity.setModel(new DefaultComboBoxModel<String>(PADDLE_SENS_OPTIONS));
        this.joyP1Sensitivity.setBounds(257, 163, 64, 23);
        this.joysticksPanel.add(this.joyP1Sensitivity);
        this.joyP1Sensitivity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.joyP1SensitivityAction();
            }
        });
        JLabel label_3 = new JLabel("Sensitivity");
        label_3.setHorizontalAlignment(0);
        label_3.setFont(fontLabel);
        label_3.setBounds(254, 149, 71, 15);
        this.joysticksPanel.add(label_3);
        JPanel cartridgePanel = new JPanel();
        this.mainTabbedPane.addTab("Cartridge", null, cartridgePanel, null);
        cartridgePanel.setLayout(null);
        cartridgePanel.setPreferredSize(INTERNAL_TAB_SIZE);
        JLabel txtpnRomName = new JLabel();
        txtpnRomName.setBounds(16, 6, 446, 21);
        txtpnRomName.setText("ROM Name");
        txtpnRomName.setOpaque(false);
        txtpnRomName.setFont(fontLabelBold);
        cartridgePanel.add(txtpnRomName);
        this.romNameTf = new JTextFieldNim();
        this.romNameTf.setFont(fontLabel);
        this.romNameTf.setEditable(false);
        this.romNameTf.setBounds(14, 24, 445, 25);
        cartridgePanel.add(this.romNameTf);
        this.romNameTf.setColumns(10);
        JLabel txtpnRomFormat = new JLabel();
        txtpnRomFormat.setText("ROM Format");
        txtpnRomFormat.setOpaque(false);
        txtpnRomFormat.setFont(fontLabelBold);
        txtpnRomFormat.setBounds(15, 53, 446, 21);
        cartridgePanel.add(txtpnRomFormat);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(15, 73, 284, 177);
        cartridgePanel.add(scrollPane);
        this.romFormatLb = new JList();
        this.romFormatLb.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SettingsDialog.this.romFormatLbAction();
            }
        });
        this.romFormatLb.setFont(fontLabel);
        scrollPane.setViewportView(this.romFormatLb);
        JTextPane txtpnYouCanPlace = new JTextPane();
        txtpnYouCanPlace.setText("You can give Format Hints like (E0) or (3F) in ROMs filenames");
        txtpnYouCanPlace.setOpaque(false);
        txtpnYouCanPlace.setBackground(noBackground);
        txtpnYouCanPlace.setFont(fontLabel);
        txtpnYouCanPlace.setEditable(false);
        txtpnYouCanPlace.setBounds(306, 77, 165, 78);
        cartridgePanel.add(txtpnYouCanPlace);
        JTextPane txtpnAltbCycle = new JTextPane();
        txtpnAltbCycle.setFocusable(false);
        txtpnAltbCycle.setText("ALT + B: Cycle through compatible Formats\r\n");
        txtpnAltbCycle.setOpaque(false);
        txtpnAltbCycle.setBackground(noBackground);
        txtpnAltbCycle.setFont(fontLabel);
        txtpnAltbCycle.setEditable(false);
        txtpnAltbCycle.setBounds(306, 201, 165, 61);
        cartridgePanel.add(txtpnAltbCycle);
        txtpnAltbCycle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                cycleROMFormatAction.actionPerformed(null);
            }
        });
        JPanel helpPanel = new JPanel();
        this.mainTabbedPane.addTab("Help", null, helpPanel, null);
        helpPanel.setLayout(null);
        helpPanel.setPreferredSize(INTERNAL_TAB_SIZE);
        JTextPane txtpnAltJ = new JTextPane();
        txtpnAltJ.setOpaque(false);
        txtpnAltJ.setBackground(noBackground);
        txtpnAltJ.setEditable(false);
        txtpnAltJ.setFont(fontLabel);
        txtpnAltJ.setBounds(12, 39, 121, 226);
        helpPanel.add(txtpnAltJ);
        txtpnAltJ.setText("CTR + 1-0:\r\nALT + 1-0:\r\n\r\nALT + ENT:\r\nALT + V:\r\nALT + R:\r\nALT + Q:\r\nALT + G:\r\nALT + D:\r\nALT + C:\r\nALT + P:\r\nALT + F:\r\nTAB:");
        JTextPane txtpnFullscreenNtsc = new JTextPane();
        txtpnFullscreenNtsc.setOpaque(false);
        txtpnFullscreenNtsc.setBackground(noBackground);
        txtpnFullscreenNtsc.setEditable(false);
        txtpnFullscreenNtsc.setText("Save State\r\nLoad State\r\n\r\nFullscreen\r\nNTSC / PAL\r\nCRT Modes\r\nFilter\r\nShow info\r\nDebug Modes\r\nCollisions\r\nPause\r\nNext Frame\r\nFast Speed");
        txtpnFullscreenNtsc.setFont(fontLabel);
        txtpnFullscreenNtsc.setBounds(95, 39, 145, 226);
        helpPanel.add(txtpnFullscreenNtsc);
        JTextPane txtpnAltF = new JTextPane();
        txtpnAltF.setOpaque(false);
        txtpnAltF.setBackground(noBackground);
        txtpnAltF.setEditable(false);
        txtpnAltF.setText("ALT + F1:\r\n\r\nALT + F5:\r\nALT + F6:\r\nF7:\r\n\r\nDrag/Drop or Copy/Paste of files and URLs\r\n\r\nCTR-ALT + Arrows:\r\nCTR-SHT + Arrows:\r\nALT-SHT + Arrows:\r\n\r\nBACKSPACE:");
        txtpnAltF.setFont(fontLabel);
        txtpnAltF.setBounds(201, 39, 309, 226);
        helpPanel.add(txtpnAltF);
        JTextPane txtpnFryConsoleLoad = new JTextPane();
        txtpnFryConsoleLoad.setOpaque(false);
        txtpnFryConsoleLoad.setBackground(noBackground);
        txtpnFryConsoleLoad.setEditable(false);
        txtpnFryConsoleLoad.setText("Fry Console\r\n\r\nLoad Cartridge\r\nwith no Power Cycle\r\nRemove Cartridge");
        txtpnFryConsoleLoad.setFont(fontLabel);
        txtpnFryConsoleLoad.setBounds(277, 39, 194, 117);
        helpPanel.add(txtpnFryConsoleLoad);
        JTextPane txtpnDisplayOriginDisplay = new JTextPane();
        txtpnDisplayOriginDisplay.setOpaque(false);
        txtpnDisplayOriginDisplay.setBackground(noBackground);
        txtpnDisplayOriginDisplay.setEditable(false);
        txtpnDisplayOriginDisplay.setText("\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nDisplay Origin\r\nDisplay Size\r\nDisplay Scale\r\n\r\nDisplay Defaults");
        txtpnDisplayOriginDisplay.setFont(fontLabel);
        txtpnDisplayOriginDisplay.setBounds(332, 39, 139, 226);
        helpPanel.add(txtpnDisplayOriginDisplay);
        JLabel lblHotKeys = new JLabel();
        lblHotKeys.setHorizontalAlignment(0);
        lblHotKeys.setText("Hot Keys");
        lblHotKeys.setOpaque(false);
        lblHotKeys.setFont(fontLabelBold);
        lblHotKeys.setBounds(11, 10, 446, 21);
        helpPanel.add(lblHotKeys);
        JPanel aboutPanel = new JPanel();
        aboutPanel.setCursor(Cursor.getPredefinedCursor(0));
        aboutPanel.setBackground(UIManager.getColor("Panel.background"));
        this.mainTabbedPane.addTab("About", null, aboutPanel, null);
        aboutPanel.setLayout(null);
        aboutPanel.setPreferredSize(INTERNAL_TAB_SIZE);
        JLabel lblNewButton = new JLabel("");
        lblNewButton.setBounds(29, 27, 170, 166);
        aboutPanel.add(lblNewButton);
        lblNewButton.setIcon(new ImageIcon(SettingsDialog.class.getResource("/org/javatari/pc/room/settings/images/LogoAbout.png")));
        lblNewButton.setHorizontalAlignment(0);
        lblNewButton.setVerticalAlignment(0);
        lblNewButton.setBorder(new DeepBorder(6, new Insets(3, 3, 3, 3)));
        JLabel lblVerion = new JLabel("version 3.10");
        lblVerion.setHorizontalAlignment(0);
        lblVerion.setFont(fontLabelMedium);
        lblVerion.setBounds(67, 202, 95, 14);
        aboutPanel.add(lblVerion);
        JLabel lblCreate = new JLabel("Paulo Augusto Peccin");
        lblCreate.setHorizontalAlignment(0);
        lblCreate.setFont(fontLabelLarge);
        lblCreate.setBounds(241, 67, 173, 19);
        aboutPanel.add(lblCreate);
        JLabel lblCreated = new JLabel("created by");
        lblCreated.setHorizontalAlignment(0);
        lblCreated.setFont(fontLabelMedium);
        lblCreated.setBounds(259, 44, 137, 21);
        aboutPanel.add(lblCreated);
        JLabel lblOfficialHomepage = new JLabel("official homepage:");
        lblOfficialHomepage.setHorizontalAlignment(0);
        lblOfficialHomepage.setFont(fontLabelMedium);
        lblOfficialHomepage.setBounds(259, 130, 137, 21);
        aboutPanel.add(lblOfficialHomepage);
        JButton lblHttpjavatariorg = new JButton("http://javatari.org");
        lblHttpjavatariorg.setFocusPainted(false);
        lblHttpjavatariorg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.officialWebPageAction();
            }
        });
        lblHttpjavatariorg.setCursor(Cursor.getPredefinedCursor(12));
        lblHttpjavatariorg.setBorder(null);
        lblHttpjavatariorg.setContentAreaFilled(false);
        lblHttpjavatariorg.setBorderPainted(false);
        lblHttpjavatariorg.setHorizontalAlignment(0);
        lblHttpjavatariorg.setForeground(new Color(40, 100, 230));
        lblHttpjavatariorg.setFont(fontLabelLarge);
        lblHttpjavatariorg.setBounds(250, 152, 154, 19);
        aboutPanel.add(lblHttpjavatariorg);
        JButton lblppeccin = new JButton("@ppeccin");
        lblppeccin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.twitterPageAction();
            }
        });
        lblppeccin.setCursor(Cursor.getPredefinedCursor(12));
        lblppeccin.setContentAreaFilled(false);
        lblppeccin.setForeground(new Color(40, 100, 230));
        lblppeccin.setBorderPainted(false);
        lblppeccin.setBorder(null);
        lblppeccin.setHorizontalAlignment(0);
        lblppeccin.setFont(fontLabelMedium);
        lblppeccin.setBounds(259, 87, 137, 19);
        aboutPanel.add(lblppeccin);
        this.vmInfo = new JLabel("");
        this.vmInfo.setHorizontalAlignment(0);
        this.vmInfo.setVerticalAlignment(3);
        this.vmInfo.setFont(fontFields);
        this.vmInfo.setBounds(11, 239, 450, 20);
        aboutPanel.add(this.vmInfo);
        JPanel buttonPane = new JPanel();
        this.getContentPane().add((Component)buttonPane, "South");
        buttonPane.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panel.getLayout();
        flowLayout.setAlignment(0);
        buttonPane.add((Component)panel, "West");
        this.defaultsB = new JButton("Defaults");
        this.defaultsB.setFont(fontLabel);
        this.defaultsB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.defaultsAction();
            }
        });
        panel.add(this.defaultsB);
        JPanel panel_1 = new JPanel();
        buttonPane.add((Component)panel_1, "East");
        this.closeB = new JButton("Close");
        this.closeB.setFont(fontLabel);
        panel_1.add(this.closeB);
        this.closeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.closeAction();
            }
        });
        this.closeB.setActionCommand("Cancel");
        this.keyboardEdittingL = new JLabel("");
        this.keyboardEdittingL.setHorizontalAlignment(0);
        this.keyboardEdittingL.setFont(fontLabel);
        this.keyboardEdittingL.setBounds(192, 53, 86, 15);
        this.keyboardPanel.add(this.keyboardEdittingL);
        this.joyP0XAxis = new JComboBoxNim();
        this.joyP0XAxis.setFont(fontFields);
        this.joyP0XAxis.setModel(new DefaultComboBoxModel<String>(JOY_AXIS_OPTIONS));
        this.joyP0XAxis.setBounds(19, 130, 44, 23);
        this.joysticksPanel.add(this.joyP0XAxis);
        this.joyP0XAxis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.joyP0XAxisAction();
            }
        });
        this.joyP0XAxisL = new JLabel("X Axis");
        this.joyP0XAxisL.setHorizontalAlignment(0);
        this.joyP0XAxisL.setFont(fontLabel);
        this.joyP0XAxisL.setBounds(12, 116, 58, 15);
        this.joysticksPanel.add(this.joyP0XAxisL);
        this.joyP0YAxis = new JComboBoxNim();
        this.joyP0YAxis.setFont(fontFields);
        this.joyP0YAxis.setModel(new DefaultComboBoxModel<String>(JOY_AXIS_OPTIONS));
        this.joyP0YAxis.setBounds(85, 67, 44, 23);
        this.joysticksPanel.add(this.joyP0YAxis);
        this.joyP0YAxis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.joyP0YAxisAction();
            }
        });
        JLabel lblVAxis = new JLabel("Y Axis");
        lblVAxis.setHorizontalAlignment(0);
        lblVAxis.setFont(fontLabel);
        lblVAxis.setBounds(85, 53, 45, 15);
        this.joysticksPanel.add(lblVAxis);
        this.joyP1XAxis = new JComboBoxNim();
        this.joyP1XAxis.setFont(fontFields);
        this.joyP1XAxis.setModel(new DefaultComboBoxModel<String>(JOY_AXIS_OPTIONS));
        this.joyP1XAxis.setBounds(407, 130, 44, 23);
        this.joysticksPanel.add(this.joyP1XAxis);
        this.joyP1XAxis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.joyP1XAxisAction();
            }
        });
        this.joyP1XAxisL = new JLabel("X Axis");
        this.joyP1XAxisL.setHorizontalAlignment(0);
        this.joyP1XAxisL.setFont(fontLabel);
        this.joyP1XAxisL.setBounds(400, 116, 58, 15);
        this.joysticksPanel.add(this.joyP1XAxisL);
        this.joyP1YAxis = new JComboBoxNim();
        this.joyP1YAxis.setFont(fontFields);
        this.joyP1YAxis.setModel(new DefaultComboBoxModel<String>(JOY_AXIS_OPTIONS));
        this.joyP1YAxis.setBounds(342, 67, 44, 23);
        this.joysticksPanel.add(this.joyP1YAxis);
        this.joyP1YAxis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.joyP1YAxisAction();
            }
        });
        JLabel lblP1YAxis = new JLabel("Y Axis");
        lblP1YAxis.setHorizontalAlignment(0);
        lblP1YAxis.setFont(fontLabel);
        lblP1YAxis.setBounds(342, 53, 45, 15);
        this.joysticksPanel.add(lblP1YAxis);
        this.joysticksEdittingL = new JLabel("");
        this.joysticksEdittingL.setHorizontalAlignment(0);
        this.joysticksEdittingL.setFont(fontLabel);
        this.joysticksEdittingL.setBounds(186, 52, 100, 15);
        this.joysticksPanel.add(this.joysticksEdittingL);
        this.joyP0Device = new JComboBoxNim();
        this.joyP0Device.setFont(fontFields);
        this.joyP0Device.setBounds(13, 26, 213, 23);
        this.joysticksPanel.add(this.joyP0Device);
        this.joyP0Device.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.joyP0P1DeviceAction();
            }
        });
        this.joyP1Device = new JComboBoxNim();
        this.joyP1Device.setFont(fontFields);
        this.joyP1Device.setBounds(245, 26, 213, 23);
        this.joysticksPanel.add(this.joyP1Device);
        this.joyP1Device.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.joyP0P1DeviceAction();
            }
        });
        ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(75, 512), "ToggleP1Mode");
        ((JComponent)this.getContentPane()).getActionMap().put("ToggleP1Mode", toggleP1ModeAction);
        ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(76, 512), "TogglePaddles");
        ((JComponent)this.getContentPane()).getActionMap().put("TogglePaddles", togglePaddlesAction);
        ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(74, 512), "ToggleJoystick");
        ((JComponent)this.getContentPane()).getActionMap().put("ToggleJoystick", toggleJoystickAction);
        ((JComponent)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(66, 512), "CycleROMFormat");
        ((JComponent)this.getContentPane()).getActionMap().put("CycleROMFormat", cycleROMFormatAction);
        this.buildFinished = true;
    }
}

