/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.screen;

import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeSocket;
import org.javatari.atari.controls.ConsoleControlsSocket;
import org.javatari.general.av.video.VideoSignal;
import org.javatari.parameters.Parameters;
import org.javatari.pc.room.Room;
import org.javatari.pc.screen.DesktopConsolePanel;
import org.javatari.pc.screen.DesktopScreenFullWindow;
import org.javatari.pc.screen.Monitor;
import org.javatari.pc.screen.MonitorDisplay;
import org.javatari.pc.screen.ROMTransferHandlerUtil;
import org.javatari.pc.screen.Screen;
import org.javatari.utils.GraphicsDeviceHelper;
import org.javatari.utils.Terminator;
import org.javatari.utils.slickframe.HotspotManager;
import org.javatari.utils.slickframe.SlickFrame;

public final class DesktopScreenWindow
extends SlickFrame
implements MonitorDisplay,
Screen {
    private Monitor monitor;
    private Canvas canvas;
    private DesktopConsolePanel consolePanelWindow;
    private DesktopScreenFullWindow fullWindow;
    private boolean fullScreen = false;
    private BufferStrategy bufferStrategy;
    private HotspotManager hotspots;
    private int totalCanvasVertPadding;
    private int totalCanvasHorizPadding;
    private BufferedImage topLeft;
    private BufferedImage bottomLeft;
    private BufferedImage topRight;
    private BufferedImage bottomRight;
    private BufferedImage top;
    private BufferedImage bottomBar;
    private BufferedImage bottomLeftBar;
    private BufferedImage bottomRightBar;
    private BufferedImage logoBar;
    public BufferedImage favicon;
    public BufferedImage icon64;
    public BufferedImage icon32;
    private static final Insets SLICK_INSETS = new Insets(4, 4, 30, 4);
    public static final String BASE_TITLE = "javatari";
    public static final boolean FULLSCREEN = Parameters.SCREEN_FULLSCREEN;
    public static final int BORDER_SIZE = Parameters.SCREEN_BORDER_SIZE;
    public static final boolean CONSOLE_PANEL = Parameters.SCREEN_CONSOLE_PANEL;
    public static final long serialVersionUID = 1L;

    public DesktopScreenWindow() {
        this.totalCanvasVertPadding = DesktopScreenWindow.SLICK_INSETS.top + DesktopScreenWindow.SLICK_INSETS.bottom;
        this.totalCanvasHorizPadding = DesktopScreenWindow.SLICK_INSETS.left + DesktopScreenWindow.SLICK_INSETS.right;
        this.monitor = new Monitor();
        if (CONSOLE_PANEL) {
            this.consolePanelWindow = new DesktopConsolePanel(this, this.monitor);
        }
        this.fullWindow = new DesktopScreenFullWindow(this);
        this.monitor.addControlInputComponents(this.controlsInputComponents());
        this.setup();
    }

    @Override
    public void connect(VideoSignal videoSignal, ConsoleControlsSocket controlsSocket, CartridgeSocket cartridgeSocket) {
        this.monitor.connect(videoSignal, cartridgeSocket);
        if (this.consolePanelWindow != null) {
            this.consolePanelWindow.connect(controlsSocket);
        }
    }

    @Override
    public void powerOn() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DesktopScreenWindow.this.fullScreen(FULLSCREEN);
                DesktopScreenWindow.this.monitor.powerOn();
            }
        });
    }

    @Override
    public void powerOff() {
        if (this.fullScreen) {
            this.fullScreen(false);
        }
        this.monitor.powerOff();
    }

    @Override
    public void destroy() {
        this.setVisible(false);
        this.monitor.destroy();
    }

    @Override
    public Monitor monitor() {
        return this.monitor;
    }

    @Override
    protected void init() {
        this.loadImages();
        this.setBackground(Color.BLACK);
        this.getContentPane().setBackground(Color.BLACK);
        this.getContentPane().setIgnoreRepaint(true);
        this.setLayout(null);
        this.setIconImages(Arrays.asList(this.icon64, this.icon32, this.favicon));
        this.setTitle(BASE_TITLE);
        this.canvas = new Canvas();
        this.canvas.setBackground(Color.BLACK);
        this.canvas.setIgnoreRepaint(true);
        this.canvas.setFocusTraversalKeysEnabled(false);
        this.add(this.canvas);
        super.init();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Insets ins = this.getInsets();
            this.totalCanvasHorizPadding = ins.left + ins.right + DesktopScreenWindow.SLICK_INSETS.left + DesktopScreenWindow.SLICK_INSETS.right + BORDER_SIZE * 2;
            this.totalCanvasVertPadding = ins.top + ins.bottom + DesktopScreenWindow.SLICK_INSETS.top + DesktopScreenWindow.SLICK_INSETS.bottom + BORDER_SIZE * 2;
            if (this.consolePanelWindow != null) {
                this.consolePanelWindow.setVisible(true);
            }
            this.canvasSetRenderingMode();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DesktopScreenWindow.this.repaint();
                }
            });
        } else if (this.consolePanelWindow != null) {
            this.consolePanelWindow.setVisible(false);
        }
    }

    @Override
    public Component[] controlsInputComponents() {
        return new Component[]{this};
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.canvas.addKeyListener(l);
        this.fullWindow.addKeyListener(l);
        if (this.consolePanelWindow != null) {
            this.consolePanelWindow.addKeyListener(l);
        }
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.canvas.removeKeyListener(l);
        this.fullWindow.removeKeyListener(l);
        if (this.consolePanelWindow != null) {
            this.consolePanelWindow.removeKeyListener(l);
        }
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.canvas.addMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.canvas.addMouseMotionListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.canvas.removeMouseListener(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.canvas.removeMouseMotionListener(l);
    }

    @Override
    public void displaySize(Dimension size) {
        Dimension winDim = this.windowDimensionForCanvasDimension(size);
        if (this.getSize().equals(winDim)) {
            return;
        }
        int centerX = this.getX() + this.getWidth() / 2;
        int centerY = this.getY() + (this.getHeight() + 137) / 4;
        int newX = centerX - winDim.width / 2;
        int newY = centerY - (winDim.height + 137) / 4;
        this.setBounds(newX, newY, winDim.width, winDim.height);
    }

    @Override
    public void displayCenter() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        int x = (tk.getScreenSize().width - this.getWidth()) / 2;
        int y = (tk.getScreenSize().height - this.getHeight() - 137) / 4;
        this.setLocation(x, y);
    }

    @Override
    public Dimension displayEffectiveSize() {
        return this.canvas.getSize();
    }

    @Override
    public Graphics2D displayGraphics() {
        Graphics2D graphics = (Graphics2D)(this.bufferStrategy != null ? this.bufferStrategy.getDrawGraphics() : this.canvas.getGraphics());
        return graphics;
    }

    @Override
    public void displayFinishFrame(Graphics2D graphics) {
        graphics.dispose();
        if (this.bufferStrategy != null) {
            this.bufferStrategy.show();
        }
    }

    @Override
    public Container displayContainer() {
        return this;
    }

    @Override
    public void displayClear() {
        Graphics2D canvasGraphics = this.displayGraphics();
        canvasGraphics.setColor(Color.BLACK);
        canvasGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.displayFinishFrame(canvasGraphics);
    }

    @Override
    public float displayDefaultOpenningScaleX(int displayWidh, int displayHeight) {
        return Monitor.DEFAULT_SCALE_X;
    }

    @Override
    public void displayMinimumSize(Dimension minSize) {
        this.minimunResize(this.windowDimensionForCanvasDimension(minSize));
    }

    @Override
    public void displayRequestFocus() {
        this.requestFocus();
    }

    @Override
    public void displayLeaveFullscreen() {
        if (this.fullScreen) {
            this.fullScreen(false);
        }
    }

    private void setup() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (e.getComponent() == DesktopScreenWindow.this) {
                    DesktopScreenWindow.this.positionCanvas();
                }
            }
        });
        this.getRootPane().setTransferHandler(new ROMDropTransferHandler());
        this.addHotspots();
        this.addKeyListener(new DesktopScreenControlKeyListener());
        this.monitor.setDisplay(this);
        this.displayCenter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullScreen(boolean state) {
        String string = this.monitor.refreshMonitor;
        synchronized (string) {
            if (state && this.openFullWindow()) {
                return;
            }
            this.openWindow();
        }
    }

    private void openWindow() {
        if (this.isVisible()) {
            return;
        }
        GraphicsDevice dev = GraphicsDeviceHelper.defaultScreenDevice();
        if (dev.isFullScreenSupported() && dev.getFullScreenWindow() != null) {
            dev.setFullScreenWindow(null);
        }
        this.fullWindow.setVisible(false);
        this.setVisible(true);
        this.fullScreen = false;
        this.monitor.setDisplay(this);
    }

    private boolean openFullWindow() {
        if (this.fullWindow.isVisible()) {
            return true;
        }
        GraphicsDevice dev = GraphicsDeviceHelper.defaultScreenDevice();
        if (!dev.isFullScreenSupported()) {
            return false;
        }
        this.setVisible(false);
        this.fullWindow.setVisible(true);
        dev.setFullScreenWindow(this.fullWindow);
        this.fullScreen = true;
        this.monitor.setDisplay(this.fullWindow);
        return true;
    }

    public void canvasSetRenderingMode() {
        if (Monitor.MULTI_BUFFERING <= 0) {
            return;
        }
        BufferCapabilities desiredCaps = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), Monitor.PAGE_FLIPPING ? BufferCapabilities.FlipContents.BACKGROUND : null);
        Class<?> extBufCapClass = null;
        if (Monitor.BUFFER_VSYNC != -1) {
            try {
                extBufCapClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities");
                Class<?> vSyncTypeClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities$VSyncType");
                Constructor<?> extBufCapConstructor = extBufCapClass.getConstructor(BufferCapabilities.class, vSyncTypeClass);
                Object vSyncType = vSyncTypeClass.getField(Monitor.BUFFER_VSYNC == 1 ? "VSYNC_ON" : "VSYNC_OFF").get(null);
                BufferCapabilities extBuffCaps = (BufferCapabilities)extBufCapConstructor.newInstance(desiredCaps, vSyncType);
                this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING, extBuffCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.canvas.getBufferStrategy() == null) {
            try {
                this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING, desiredCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.canvas.getBufferStrategy() == null) {
            System.out.println("Could not create desired BufferStrategy. Switching to default...");
            this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING);
        }
        this.bufferStrategy = this.canvas.getBufferStrategy();
        BufferCapabilities grantedCaps = this.bufferStrategy.getCapabilities();
        System.out.println("Backbuffer accelerated: " + grantedCaps.getBackBufferCapabilities().isAccelerated());
        System.out.println("PageFlipping active: " + grantedCaps.isPageFlipping() + ", " + grantedCaps.getFlipContents());
        if (extBufCapClass != null && grantedCaps.getClass().equals(extBufCapClass)) {
            try {
                System.out.println("VSynch active: " + extBufCapClass.getMethod("getVSync", null).invoke((Object)grantedCaps, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Dimension windowDimensionForCanvasDimension(Dimension size) {
        return new Dimension(size.width + this.totalCanvasHorizPadding, size.height + this.totalCanvasVertPadding);
    }

    private void positionCanvas() {
        this.canvas.setBounds(DesktopScreenWindow.SLICK_INSETS.left + BORDER_SIZE, DesktopScreenWindow.SLICK_INSETS.top + BORDER_SIZE, this.getWidth() - this.totalCanvasHorizPadding, this.getHeight() - this.totalCanvasVertPadding);
    }

    private void addHotspots() {
        this.hotspots = new HotspotManager(this, this.detachMouseListener());
        this.hotspots.addHotspot(new Rectangle(8, -25, 19, 19), new Runnable(){

            @Override
            public void run() {
                DesktopScreenWindow.this.exit();
            }
        });
        this.hotspots.addHotspot(new Rectangle(-10000, -27, 24, 28), new Runnable(){

            @Override
            public void run() {
                if (DesktopScreenWindow.this.consolePanelWindow != null) {
                    DesktopScreenWindow.this.consolePanelWindow.toggle();
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(-118, -20, 13, 15), new Runnable(){

            @Override
            public void run() {
                DesktopScreenWindow.this.setState(1);
            }
        });
        this.hotspots.addHotspot(new Rectangle(-99, -21, 12, 16), new Runnable(){

            @Override
            public void run() {
                DesktopScreenWindow.this.monitor.controlActivated(Monitor.Control.SIZE_MINUS);
            }
        });
        this.hotspots.addHotspot(new Rectangle(-84, -24, 14, 19), new Runnable(){

            @Override
            public void run() {
                DesktopScreenWindow.this.monitor.controlActivated(Monitor.Control.SIZE_PLUS);
            }
        });
        this.hotspots.addHotspot(new Rectangle(-64, -24, 17, 19), new Runnable(){

            @Override
            public void run() {
                DesktopScreenWindow.this.fullScreen(!DesktopScreenWindow.this.fullScreen);
            }
        });
        this.hotspots.addHotspot(new Rectangle(-41, -24, 17, 19), new Runnable(){

            @Override
            public void run() {
                Room.currentRoom().openSettings();
                DesktopScreenWindow.this.requestFocus();
            }
        });
    }

    private void loadImages() {
        try {
            this.topLeft = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/TopLeft.png");
            this.bottomLeft = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomLeft.png");
            this.topRight = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/TopRight.png");
            this.bottomRight = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomRight.png");
            this.top = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/Top.png");
            this.bottomLeftBar = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomLeftBar.png");
            this.bottomRightBar = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomRightBar.png");
            this.bottomBar = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomBar.png");
            this.logoBar = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/LogoBar.png");
            this.favicon = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/Favicon.png");
            this.icon64 = GraphicsDeviceHelper.loadAsCompatibleTranslucentImage("org/javatari/pc/screen/images/LogoIcon64.png");
            this.icon32 = GraphicsDeviceHelper.loadAsCompatibleTranslucentImage("org/javatari/pc/screen/images/LogoIcon32.png");
        }
        catch (IOException ex) {
            System.out.println("Screen Window: unable to load images\n" + ex);
        }
    }

    private void exit() {
        Terminator.terminate();
    }

    @Override
    public void paint(Graphics origGraphics) {
        Insets ins = this.getInsets();
        int w = this.getWidth() - ins.left - ins.right;
        int h = this.getHeight() - ins.top - ins.bottom;
        Graphics g = origGraphics.create(ins.left, ins.top, w, h);
        g.setColor(Color.BLACK);
        g.fillRect(DesktopScreenWindow.SLICK_INSETS.left, DesktopScreenWindow.SLICK_INSETS.top, this.getWidth() - DesktopScreenWindow.SLICK_INSETS.left - DesktopScreenWindow.SLICK_INSETS.right, this.getHeight() - DesktopScreenWindow.SLICK_INSETS.top - DesktopScreenWindow.SLICK_INSETS.bottom);
        int halfH = (h - 30) / 2;
        int halfW = w / 2;
        int maxHalfW = Math.min(halfW - 11, 512);
        int x = 0;
        while (x < w) {
            g.drawImage(this.top, x, 0, null);
            x += 512;
        }
        g.drawImage(this.topLeft, 0, 0, null);
        g.drawImage(this.topRight, w - 4, 0, null);
        x = 512;
        while (x < w - 512) {
            g.drawImage(this.bottomBar, x, h - 30, x + 256, h, 0, 0, 256, 30, null);
            x += 256;
        }
        g.drawImage(this.logoBar, halfW - 12, h - 30, null);
        g.drawImage(this.bottomLeftBar, 0, h - 30, maxHalfW, h, 0, 0, maxHalfW, 30, null);
        g.drawImage(this.bottomRightBar, w - maxHalfW, h - 30, w, h, 512 - maxHalfW, 0, 512, 30, null);
        g.drawImage(this.bottomLeft, 0, halfH, 4, h - 30, 0, 600 - halfH, 4, 600, null);
        g.drawImage(this.bottomRight, w - 4, halfH, w, h - 30, 0, 600 - halfH, 4, 600, null);
        g.dispose();
    }

    private class DesktopScreenControlKeyListener
    extends KeyAdapter {
        static final int KEY_EXIT = 27;
        static final int KEY_CONSOLE_PANEL = 72;
        static final int KEY_FULL_SCR = 10;

        private DesktopScreenControlKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            switch (e.getModifiersEx()) {
                case 0: {
                    if (code == 27) {
                        if (DesktopScreenWindow.this.fullScreen) {
                            DesktopScreenWindow.this.fullScreen(!DesktopScreenWindow.this.fullScreen);
                        } else {
                            DesktopScreenWindow.this.exit();
                        }
                    }
                    return;
                }
                case 512: {
                    switch (code) {
                        case 10: {
                            DesktopScreenWindow.this.fullScreen(!DesktopScreenWindow.this.fullScreen);
                            return;
                        }
                        case 72: {
                            if (!DesktopScreenWindow.this.fullScreen && DesktopScreenWindow.this.consolePanelWindow != null) {
                                DesktopScreenWindow.this.consolePanelWindow.toggle();
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    class ROMDropTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        ROMDropTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!DesktopScreenWindow.this.monitor.isCartridgeChangeEnabled()) {
                return false;
            }
            Transferable transf = support.getTransferable();
            if (!ROMTransferHandlerUtil.canAccept(transf)) {
                return false;
            }
            if (support.isDrop() && support.getUserDropAction() != 0x40000000) {
                support.setDropAction(1);
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            DesktopScreenWindow.this.monitor.showOSD("LOADING CARTRIDGE...", true);
            Cartridge cart = ROMTransferHandlerUtil.importCartridgeData(support.getTransferable());
            DesktopScreenWindow.this.monitor.showOSD(null, true);
            if (cart == null) {
                return false;
            }
            boolean autoPower = !support.isDrop() || support.getDropAction() != 0x40000000;
            DesktopScreenWindow.this.monitor.cartridgeInsert(cart, autoPower);
            return true;
        }
    }
}

