/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.formats.CartridgeFormatOptionHinted;

public final class Cartridge4K
extends Cartridge {
    private static final int MIN_SIZE = 8;
    private static final int MAX_SIZE = 4096;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("4K", "4K Atari"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge create(byte[] content, String contentName) {
            return new Cartridge4K(content, contentName, null);
        }

        @Override
        public CartridgeFormatOption getOption(byte[] content, String contentName) {
            if (content.length < 8 || content.length > 4096 || 4096 % content.length != 0) {
                return null;
            }
            return new CartridgeFormatOptionHinted(101, this, contentName);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge4K(byte[] content, String contentName) {
        super(new byte[4096], contentName, FORMAT);
        int len = content.length;
        int pos = 0;
        while (pos < 4096) {
            System.arraycopy(content, 0, this.bytes, pos, len);
            pos += len;
        }
    }

    /* synthetic */ Cartridge4K(byte[] byArray, String string, Cartridge4K cartridge4K) {
        this(byArray, string);
    }
}

