/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.formats.CartridgeBankedByBusMonitoring;
import org.javatari.atari.cartridge.formats.CartridgeFormatOptionHinted;

public class Cartridge8K_512K_3F
extends CartridgeBankedByBusMonitoring {
    protected final int selectableSliceMaxBank;
    protected final int fixedSliceAddressOffset;
    protected static final int BANK_SIZE = 2048;
    protected static final int MIN_SIZE = 8192;
    protected static final int MAX_SIZE = 524288;
    protected static final int FIXED_SLICE_START_ADDRESS = 2048;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("3F", "8K-512K Tigervision"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge create(byte[] content, String contentName) {
            return new Cartridge8K_512K_3F(content, contentName, this);
        }

        @Override
        public CartridgeFormatOption getOption(byte[] content, String contentName) {
            if (content.length % 2048 != 0 || content.length < 8192 || content.length > 524288) {
                return null;
            }
            return new CartridgeFormatOptionHinted(112, this, contentName);
        }
    };
    public static final long serialVersionUID = 1L;

    protected Cartridge8K_512K_3F(byte[] content, String contentName, CartridgeFormat format) {
        super(content, contentName, format);
        this.selectableSliceMaxBank = (content.length - 2048) / 2048 - 1;
        this.fixedSliceAddressOffset = content.length - 4096;
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        if (this.maskedAddress >= 2048) {
            return this.bytes[this.fixedSliceAddressOffset + this.maskedAddress];
        }
        return this.bytes[this.bankAddressOffset + this.maskedAddress];
    }

    @Override
    public void monitorByteRead(int address, byte data) {
    }

    @Override
    public void monitorByteWritten(int address, byte data) {
        int bank;
        if (address <= 63 && (bank = data & 0xFF) <= this.selectableSliceMaxBank) {
            this.bankAddressOffset = bank * 2048;
        }
    }

    @Override
    protected void performBankSwitchOnMonitoredAccess(int address) {
    }
}

