/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import java.util.Arrays;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.formats.CartridgeBanked;

public abstract class CartridgeBankedByMaskedRange
extends CartridgeBanked {
    private final int numBanks;
    private final int baseBankSwitchAddress;
    private final int topBankSwitchAddress;
    private boolean superChipMode = false;
    private final boolean superChipAutoDetect;
    private final int extraRAMSize;
    private byte[] extraRAM;
    protected static final int BANK_SIZE = 4096;
    public static final long serialVersionUID = 1L;

    protected CartridgeBankedByMaskedRange(byte[] content, String contentName, CartridgeFormat format, int baseBankSwitchAddress, Boolean superChip, int extraRAMSize) {
        super(content, contentName, format);
        this.numBanks = content.length / 4096;
        this.baseBankSwitchAddress = baseBankSwitchAddress;
        this.topBankSwitchAddress = baseBankSwitchAddress + this.numBanks - 1;
        this.extraRAMSize = extraRAMSize;
        if (superChip == null) {
            this.superChipMode = false;
            this.superChipAutoDetect = true;
        } else {
            this.superChipMode = superChip;
            this.superChipAutoDetect = false;
        }
        this.extraRAM = superChip == null || superChip != false ? Arrays.copyOf(this.bytes, extraRAMSize) : null;
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        if (this.superChipMode && this.maskedAddress >= this.extraRAMSize && this.maskedAddress < this.extraRAMSize * 2) {
            return this.extraRAM[this.maskedAddress - this.extraRAMSize];
        }
        return this.bytes[this.bankAddressOffset + this.maskedAddress];
    }

    @Override
    public void writeByte(int address, byte b) {
        this.maskAddress(address);
        if (this.maskedAddress < this.extraRAMSize && (this.superChipMode || this.superChipAutoDetect)) {
            if (!this.superChipMode) {
                this.superChipMode = true;
            }
            this.extraRAM[this.maskedAddress] = b;
        }
    }

    @Override
    protected void performBankSwitchOnMaskedAddress() {
        if (this.maskedAddress >= this.baseBankSwitchAddress && this.maskedAddress <= this.topBankSwitchAddress) {
            this.bankAddressOffset = 4096 * (this.maskedAddress - this.baseBankSwitchAddress);
        }
    }

    @Override
    public CartridgeBankedByMaskedRange clone() {
        CartridgeBankedByMaskedRange clone = (CartridgeBankedByMaskedRange)super.clone();
        if (this.extraRAM != null) {
            clone.extraRAM = (byte[])this.extraRAM.clone();
        }
        return clone;
    }
}

