/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.general.m6502.instructions;

import org.javatari.general.m6502.Instruction;
import org.javatari.general.m6502.M6502;

public final class uNOP
extends Instruction {
    private final int type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public uNOP(M6502 cpu, int type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        if (this.type == 1) {
            this.ea = this.cpu.fetchImmediateAddress();
            return 2;
        }
        if (this.type == 20) {
            this.ea = this.cpu.fetchZeroPageAddress();
            return 3;
        }
        if (this.type == 21) {
            this.ea = this.cpu.fetchZeroPageXAddress();
            return 4;
        }
        if (this.type == 10) {
            this.ea = this.cpu.fetchAbsoluteAddress();
            return 4;
        }
        if (this.type == 11) {
            this.ea = this.cpu.fetchAbsoluteXAddress();
            return 4 + (this.cpu.pageCrossed ? 1 : 0);
        }
        throw new IllegalStateException("uNOP Invalid Operand Type: " + this.type);
    }

    @Override
    public void execute() {
        this.cpu.bus.readByte(this.ea);
    }
}

