/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.screen;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeInfo;
import org.javatari.atari.cartridge.CartridgeInsertionListener;
import org.javatari.atari.cartridge.CartridgeSocket;
import org.javatari.atari.controls.ConsoleControls;
import org.javatari.atari.controls.ConsoleControlsInput;
import org.javatari.atari.controls.ConsoleControlsRedefinitionListener;
import org.javatari.atari.controls.ConsoleControlsSocket;
import org.javatari.parameters.Parameters;
import org.javatari.pc.screen.Monitor;
import org.javatari.utils.Environment;
import org.javatari.utils.GraphicsDeviceHelper;
import org.javatari.utils.slickframe.HotspotManager;
import org.javatari.utils.slickframe.MousePressAndMotionListener;

public final class ConsolePanel
extends JPanel
implements ConsoleControls,
ConsoleControlsInput,
ConsoleControlsRedefinitionListener,
CartridgeInsertionListener {
    private HotspotManager hotspots;
    private BufferedImage panelImage;
    private BufferedImage powerDownImage;
    private BufferedImage colorDownImage;
    private BufferedImage selectDownImage;
    private BufferedImage resetDownImage;
    private BufferedImage p0DiffDownImage;
    private BufferedImage p1DiffDownImage;
    private BufferedImage changeCartKeysImage;
    private BufferedImage cartridgeImage;
    private JLabel cartridgeLabelComponent;
    private boolean cartridgeInserted = false;
    private HotspotManager.HotspotAction cartridgeInsertedHotspot;
    private HotspotManager.HotspotAction cartridgeMissingHotspot;
    private HotspotManager.HotspotAction fileHotspot;
    private HotspotManager.HotspotAction urlHotspot;
    private final Monitor screen;
    private ConsoleControlsSocket consoleControlsSocket;
    private final Map<ConsoleControls.Control, Boolean> controlsStateReport = new HashMap<ConsoleControls.Control, Boolean>();
    public static final int WIDTH = 465;
    public static final int HEIGHT = 137;
    private static final Set<ConsoleControls.Control> visibleControls = new HashSet<ConsoleControls.Control>(Arrays.asList(ConsoleControls.Control.POWER, ConsoleControls.Control.BLACK_WHITE, ConsoleControls.Control.SELECT, ConsoleControls.Control.RESET, ConsoleControls.Control.DIFFICULTY0, ConsoleControls.Control.DIFFICULTY1));
    private static final String DEFAULT_CARTRIDGE_LABEL = Parameters.DEFAULT_CARTRIDGE_LABEL;
    private static final int DEFAULT_CARTRIDGE_LABEL_COLOR = Parameters.DEFAULT_CARTRIDGE_LABEL_COLOR;
    private static final int DEFAULT_CARTRIDGE_BACK_COLOR = Parameters.DEFAULT_CARTRIDGE_BACK_COLOR;
    public static final long serialVersionUID = 1L;

    public ConsolePanel(Monitor screen, MousePressAndMotionListener forwardListener) {
        this.screen = screen;
        this.buildGUI();
        this.addHotspots(forwardListener);
        this.cartridgeInserted(null);
    }

    public void connect(ConsoleControlsSocket controlsSocket, CartridgeSocket cartridgeSocket) {
        this.consoleControlsSocket = controlsSocket;
        this.consoleControlsSocket.addForwardedInput(this);
        this.consoleControlsSocket.addRedefinitionListener(this);
        cartridgeSocket.addInsertionListener(this);
        this.updateVisibleControlsState();
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, boolean state) {
        if (visibleControls.contains((Object)control)) {
            this.updateVisibleControlsState();
        }
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, int position) {
        if (visibleControls.contains((Object)control)) {
            this.updateVisibleControlsState();
        }
    }

    @Override
    public void controlsStateReport(Map<ConsoleControls.Control, Boolean> report) {
    }

    @Override
    public void controlsStatesRedefined() {
        this.updateVisibleControlsState();
    }

    @Override
    public void cartridgeInserted(Cartridge cartridge) {
        this.cartridgeInserted = cartridge != null;
        String label = null;
        int fore = -1;
        int back = -1;
        int bord = -1;
        if (this.cartridgeInserted) {
            CartridgeInfo info = cartridge.getInfo();
            label = info.label;
            fore = info.labelColor;
            back = info.labelBackColor;
            bord = info.labelBorderColor;
        }
        if (label == null) {
            label = DEFAULT_CARTRIDGE_LABEL;
        }
        if (fore == -1) {
            fore = DEFAULT_CARTRIDGE_LABEL_COLOR;
        }
        if (back == -1) {
            back = DEFAULT_CARTRIDGE_BACK_COLOR;
        }
        this.cartridgeLabelComponent.setText(label);
        this.cartridgeLabelComponent.setForeground(new Color(fore));
        Color b = new Color(back);
        this.cartridgeLabelComponent.setBackground(b);
        float bf = 0.9f;
        this.cartridgeLabelComponent.setBorder(bord == -1 ? new LineBorder(new Color((int)((float)b.getRed() * bf), (int)((float)b.getGreen() * bf), (int)((float)b.getBlue() * bf)), 1) : new LineBorder(new Color(bord), 1));
        this.hotspots.removeHotspot(this.cartridgeInsertedHotspot);
        this.hotspots.removeHotspot(this.cartridgeMissingHotspot);
        this.hotspots.addHotspot(this.cartridgeInserted ? this.cartridgeInsertedHotspot : this.cartridgeMissingHotspot);
        this.hotspots.removeHotspot(this.fileHotspot);
        this.hotspots.removeHotspot(this.urlHotspot);
        if (this.screen.isCartridgeChangeEnabled()) {
            this.hotspots.addHotspot(this.fileHotspot);
            this.hotspots.addHotspot(this.urlHotspot);
        }
        if (this.isVisible()) {
            this.repaint();
        }
    }

    private void buildGUI() {
        this.prepareResources();
        Dimension size = this.desiredSize();
        this.setSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.setFocusable(false);
    }

    private void prepareResources() {
        try {
            this.panelImage = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/Panel.png");
            this.cartridgeImage = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/Cartridge.png");
            this.changeCartKeysImage = GraphicsDeviceHelper.loadAsCompatibleTranslucentImage("org/javatari/pc/screen/images/CartridgeChangeKeys.png");
            this.powerDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/PowerDown.png");
            this.colorDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/ColorDown.png");
            this.selectDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/SelectDown.png");
            this.resetDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/ResetDown.png");
            this.p0DiffDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/P0DiffDown.png");
            this.p1DiffDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/P1DiffDown.png");
            this.cartridgeLabelComponent = new JLabel();
            if (Environment.cartridgeLabelFont != null) {
                this.cartridgeLabelComponent.setFont(Environment.cartridgeLabelFont);
            } else if (Environment.LIBERATION_FONT) {
                this.cartridgeLabelComponent.setFont(new Font("Liberation Sans", 1, 15));
            } else if (Environment.ARIAL_FONT) {
                this.cartridgeLabelComponent.setFont(new Font("Arial", 1, 14));
            } else {
                this.cartridgeLabelComponent.setFont(new Font("SansSerif", 1, 14));
            }
            this.cartridgeLabelComponent.setOpaque(true);
            this.cartridgeLabelComponent.setHorizontalAlignment(0);
            this.cartridgeLabelComponent.setVerticalAlignment(0);
        }
        catch (IOException ex) {
            System.out.println("Console Panel: unable to load images\n" + ex);
        }
    }

    private void addHotspots(MousePressAndMotionListener forwardListener) {
        this.hotspots = forwardListener != null ? new HotspotManager(this, forwardListener) : new HotspotManager(this);
        this.hotspots.addHotspot(new Rectangle(31, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.POWER, true);
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(95, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.BLACK_WHITE, true);
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(351, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.SELECT, true);
                }
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.SELECT, false);
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(414, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.RESET, true);
                }
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.RESET, false);
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(161, -133, 34, 21), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.DIFFICULTY0, true);
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(274, -133, 34, 21), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.DIFFICULTY1, true);
                }
            }
        });
        HotspotManager hotspotManager = this.hotspots;
        hotspotManager.getClass();
        this.cartridgeInsertedHotspot = new HotspotManager.HotspotAction(hotspotManager, new Rectangle(145, -92, 180, 46), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.screen.controlActivated(Monitor.Control.LOAD_CARTRIDGE_FILE);
            }
        });
        HotspotManager hotspotManager2 = this.hotspots;
        hotspotManager2.getClass();
        this.cartridgeMissingHotspot = new HotspotManager.HotspotAction(hotspotManager2, new Rectangle(153, -83, 164, 42), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.screen.controlActivated(Monitor.Control.LOAD_CARTRIDGE_FILE);
            }
        });
        HotspotManager hotspotManager3 = this.hotspots;
        hotspotManager3.getClass();
        this.fileHotspot = new HotspotManager.HotspotAction(hotspotManager3, new Rectangle(172, -34, 30, 29), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.screen.controlActivated(Monitor.Control.LOAD_CARTRIDGE_FILE);
            }
        });
        HotspotManager hotspotManager4 = this.hotspots;
        hotspotManager4.getClass();
        this.urlHotspot = new HotspotManager.HotspotAction(hotspotManager4, new Rectangle(266, -34, 30, 29), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.screen.controlActivated(Monitor.Control.LOAD_CARTRIDGE_URL);
            }
        });
    }

    private Dimension desiredSize() {
        Insets ins = this.getInsets();
        return new Dimension(465 + ins.left + ins.right, 137 + ins.top + ins.bottom);
    }

    private void updateVisibleControlsState() {
        this.consoleControlsSocket.controlsStateReport(this.controlsStateReport);
        if (this.isVisible()) {
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets ins = this.getInsets();
        int initialHeight = 137 - (this.getHeight() - ins.top - ins.bottom);
        g.drawImage(this.panelImage, ins.left, ins.top, this.getWidth() - ins.right, this.getHeight() - ins.bottom, 0, initialHeight, this.getWidth() - ins.left - ins.right, initialHeight + this.getHeight() - ins.top - ins.bottom, null);
        int panelBottom = this.getHeight() - ins.bottom;
        if (this.cartridgeInserted) {
            g.drawImage(this.cartridgeImage, ins.left + 141, panelBottom - 94, null);
            ((Graphics2D)g).setComposite(AlphaComposite.SrcOver);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            SwingUtilities.paintComponent(g, this.cartridgeLabelComponent, this, ins.left + 158, panelBottom - 85, 154, 27);
        }
        if (this.screen.isCartridgeChangeEnabled() && initialHeight < 127) {
            g.drawImage(this.changeCartKeysImage, ins.left + 174, panelBottom - 32, null);
        }
        if (this.controlsStateReport.isEmpty()) {
            return;
        }
        if (!this.controlsStateReport.get((Object)ConsoleControls.Control.POWER).booleanValue()) {
            g.drawImage(this.powerDownImage, ins.left + 33, panelBottom - 87, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.BLACK_WHITE).booleanValue()) {
            g.drawImage(this.colorDownImage, ins.left + 97, panelBottom - 87, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.SELECT).booleanValue()) {
            g.drawImage(this.selectDownImage, ins.left + 353, panelBottom - 87, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.RESET).booleanValue()) {
            g.drawImage(this.resetDownImage, ins.left + 416, panelBottom - 87, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.DIFFICULTY0).booleanValue()) {
            g.drawImage(this.p0DiffDownImage, ins.left + 164, panelBottom - 131, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.DIFFICULTY1).booleanValue()) {
            g.drawImage(this.p1DiffDownImage, ins.left + 277, panelBottom - 131, null);
        }
    }
}

