/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.utils.slickframe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.javatari.utils.slickframe.MousePressAndMotionAdapter;
import org.javatari.utils.slickframe.MousePressAndMotionListener;

public final class HotspotManager {
    private final Component masterComponent;
    private final MousePressAndMotionListener forwardListener;
    private MousePressAndMotionListener mouseListener;
    private List<HotspotAction> hotspots = new ArrayList<HotspotAction>();
    private HotspotAction activeHotspot;
    public static final int CENTER_HOTSPOT = -10000;
    public static final long serialVersionUID = 1L;

    public HotspotManager(Component masterComponent) throws HeadlessException {
        this(masterComponent, new MousePressAndMotionAdapter(){});
    }

    public HotspotManager(Component masterComponent, MousePressAndMotionListener forwardListener) throws HeadlessException {
        this.masterComponent = masterComponent;
        this.forwardListener = forwardListener;
        this.init();
    }

    public HotspotAction addHotspot(Rectangle area, Runnable activationAction) {
        HotspotAction h = new HotspotAction(area, activationAction);
        return this.addHotspot(h);
    }

    public HotspotAction addHotspot(Rectangle area, Runnable activationAction, Runnable deactivationAction) {
        HotspotAction h = new HotspotAction(area, activationAction, deactivationAction);
        return this.addHotspot(h);
    }

    public HotspotAction addHotspot(HotspotAction h) {
        this.hotspots.add(h);
        return h;
    }

    public void removeHotspot(HotspotAction hotspot) {
        this.hotspots.remove(hotspot);
    }

    public MousePressAndMotionListener detachMouseListener() {
        this.masterComponent.removeMouseListener(this.mouseListener);
        this.masterComponent.removeMouseMotionListener(this.mouseListener);
        return this.mouseListener;
    }

    private void init() {
        this.mouseListener = this.buildMouseListener();
        this.masterComponent.addMouseListener(this.mouseListener);
        this.masterComponent.addMouseMotionListener(this.mouseListener);
    }

    private MousePressAndMotionListener buildMouseListener() {
        return new MousePressAndMotionListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    Point point = e.getPoint();
                    for (HotspotAction hotspot : HotspotManager.this.hotspots) {
                        Rectangle efectiveArea = HotspotManager.this.effectiveArea(hotspot.area);
                        if (!efectiveArea.contains(point)) continue;
                        HotspotManager.this.activeHotspot = hotspot;
                        hotspot.activationAction.run();
                        return;
                    }
                    HotspotManager.this.activeHotspot = null;
                }
                HotspotManager.this.forwardListener.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1 && HotspotManager.this.activeHotspot != null) {
                    if (((HotspotManager)HotspotManager.this).activeHotspot.deactivationAction != null) {
                        ((HotspotManager)HotspotManager.this).activeHotspot.deactivationAction.run();
                    }
                    HotspotManager.this.activeHotspot = null;
                    return;
                }
                HotspotManager.this.forwardListener.mouseReleased(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (HotspotManager.this.activeHotspot == null) {
                    HotspotManager.this.forwardListener.mouseDragged(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                HotspotManager.this.forwardListener.mouseClicked(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                HotspotManager.this.forwardListener.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HotspotManager.this.forwardListener.mouseExited(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                HotspotManager.this.forwardListener.mouseMoved(e);
            }
        };
    }

    public void paintHotspots(Graphics g) {
        g.setColor(Color.YELLOW);
        for (HotspotAction hotspot : this.hotspots) {
            Rectangle rect = this.effectiveArea(hotspot.area);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private Rectangle effectiveArea(Rectangle area) {
        return new Rectangle(area.x == -10000 ? (this.masterComponent.getWidth() - area.width) / 2 : (area.x < 0 ? this.masterComponent.getWidth() + area.x : area.x), area.y == -10000 ? (this.masterComponent.getHeight() - area.height) / 2 : (area.y < 0 ? this.masterComponent.getHeight() + area.y : area.y), area.width, area.height);
    }

    public class HotspotAction {
        public Rectangle area;
        public Runnable activationAction;
        public Runnable deactivationAction;

        public HotspotAction(Rectangle area, Runnable activationAction) {
            this(area, activationAction, null);
        }

        public HotspotAction(Rectangle area, Runnable activationAction, Runnable deactivationAction) {
            this.area = area;
            this.activationAction = activationAction;
            this.deactivationAction = deactivationAction;
        }
    }
}

