/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.javatari.atari.network.ConnectionStatusListener;
import org.javatari.atari.network.ServerConsole;
import org.javatari.atari.network.ServerUpdate;
import org.javatari.parameters.Parameters;

public final class RemoteTransmitter {
    private boolean started = false;
    private ServerSocket serverSocket;
    private Socket socket;
    private int port = Parameters.SERVER_SERVICE_PORT;
    private ServerConsole console;
    private ConcurrentLinkedQueue<ServerUpdate> updates;
    private UpdatesSender updatesSender;
    private OutputStream socketOutputStream;
    private InputStream socketInputStream;
    private ObjectOutputStream outputStream;
    private ObjectInputStream inputStream;
    private List<ConnectionStatusListener> connectionListeners = new ArrayList<ConnectionStatusListener>();
    private static final int MAX_UPDATES_PENDING = Parameters.SERVER_MAX_UPDATES_PENDING;

    public RemoteTransmitter() {
        this.updates = new ConcurrentLinkedQueue();
    }

    public void start() throws IOException {
        this.start(this.port);
    }

    public void start(int port) throws IOException {
        this.port = port;
        this.serverSocket = new ServerSocket(port);
        this.updatesSender = new UpdatesSender();
        this.started = true;
        this.updatesSender.start();
    }

    public void stop() throws IOException {
        UpdatesSender sender;
        this.started = false;
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            this.serverSocket.close();
        }
        if ((sender = this.updatesSender) == null) {
            return;
        }
        sender.interrupt();
        try {
            sender.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public int port() {
        return this.port;
    }

    public void serverConsole(ServerConsole console) {
        this.console = console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendUpdate(ServerUpdate update) {
        if (this.outputStream == null) {
            return;
        }
        ConcurrentLinkedQueue<ServerUpdate> concurrentLinkedQueue = this.updates;
        synchronized (concurrentLinkedQueue) {
            while (true) {
                if (this.updates.size() <= MAX_UPDATES_PENDING) {
                    this.updates.add(update);
                    this.updates.notifyAll();
                    return;
                }
                try {
                    this.updates.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isClientConnected() {
        return this.outputStream != null;
    }

    public void addConnectionStatusListener(ConnectionStatusListener lis) {
        if (!this.connectionListeners.contains(lis)) {
            this.connectionListeners.add(lis);
        }
    }

    private void listen() throws IOException {
        if (this.serverSocket == null || this.serverSocket.isClosed()) {
            this.serverSocket = new ServerSocket(this.port);
        }
        Socket conn = this.serverSocket.accept();
        this.serverSocket.close();
        this.connect(conn);
    }

    private void connect(Socket toSocket) throws IOException {
        this.socket = toSocket;
        this.socket.setTcpNoDelay(true);
        this.socketOutputStream = this.socket.getOutputStream();
        this.outputStream = new ObjectOutputStream(this.socketOutputStream);
        this.socketInputStream = this.socket.getInputStream();
        this.inputStream = new ObjectInputStream(this.socketInputStream);
        this.resetUpdatesPending();
        this.console.clientConnected();
        this.notifyConnectionStatusListeners();
    }

    private void disconnect() {
        boolean wasConnected = this.outputStream != null;
        this.cleanStreamsSilently();
        this.resetUpdatesPending();
        if (wasConnected) {
            this.console.clientDisconnected();
            this.notifyConnectionStatusListeners();
        }
    }

    private void cleanStreamsSilently() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socketOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socketInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
        this.socketOutputStream = null;
        this.outputStream = null;
        this.socketInputStream = null;
        this.inputStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUpdatesPending() {
        ConcurrentLinkedQueue<ServerUpdate> concurrentLinkedQueue = this.updates;
        synchronized (concurrentLinkedQueue) {
            this.updates.clear();
            this.updates.notifyAll();
        }
    }

    private void notifyConnectionStatusListeners() {
        for (ConnectionStatusListener lis : this.connectionListeners) {
            lis.connectionStatusChanged();
        }
    }

    private class UpdatesSender
    extends Thread {
        public UpdatesSender() {
            super("RemoteTransmitter Sender");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (RemoteTransmitter.this.started) {
                    RemoteTransmitter.this.listen();
                    block11: while (true) {
                        try {
                            while (RemoteTransmitter.this.started) {
                                ServerUpdate update;
                                Object object = RemoteTransmitter.this.updates;
                                synchronized (object) {
                                    while ((update = (ServerUpdate)RemoteTransmitter.this.updates.poll()) == null) {
                                        RemoteTransmitter.this.updates.wait();
                                    }
                                    RemoteTransmitter.this.updates.notifyAll();
                                }
                                if (!RemoteTransmitter.this.started || update == null) continue;
                                object = RemoteTransmitter.this.outputStream;
                                synchronized (object) {
                                    RemoteTransmitter.this.outputStream.writeObject(update);
                                    RemoteTransmitter.this.outputStream.flush();
                                    RemoteTransmitter.this.socketOutputStream.flush();
                                    List clientControlChanges = (List)RemoteTransmitter.this.inputStream.readObject();
                                    if (clientControlChanges != null) {
                                        RemoteTransmitter.this.console.receiveClientControlChanges(clientControlChanges);
                                    }
                                    continue block11;
                                }
                            }
                            break;
                        }
                        catch (Exception update) {
                            // empty catch block
                            break;
                        }
                    }
                    RemoteTransmitter.this.disconnect();
                }
            }
            catch (Exception ex) {
                RemoteTransmitter.this.disconnect();
            }
            RemoteTransmitter.this.started = false;
            RemoteTransmitter.this.updatesSender = null;
        }
    }
}

