/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.network;

import java.util.ArrayList;
import java.util.List;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.console.Console;
import org.javatari.atari.console.savestate.ConsoleState;
import org.javatari.atari.controls.ConsoleControls;
import org.javatari.atari.controls.ConsoleControlsSocket;
import org.javatari.atari.network.ControlChange;
import org.javatari.atari.network.ControlChangeForPaddle;
import org.javatari.atari.network.RemoteTransmitter;
import org.javatari.atari.network.ServerUpdate;
import org.javatari.general.av.video.VideoStandard;
import org.javatari.general.board.Clock;
import org.javatari.general.board.ClockDriven;

public final class ServerConsole
extends Console
implements ClockDriven {
    private RemoteTransmitter remoteTransmitter;

    public ServerConsole(RemoteTransmitter transmitter) {
        this.setupTransmitter(transmitter);
    }

    public RemoteTransmitter remoteTransmitter() {
        return this.remoteTransmitter;
    }

    @Override
    public void powerOff() {
        super.powerOff();
        this.mainClockGo();
    }

    @Override
    protected void mainClockCreate() {
        this.mainClock = new Clock("Server Console", this, VideoStandard.NTSC.fps);
        this.mainClock.go();
    }

    @Override
    protected void socketsCreate() {
        this.controlsSocket = new ServerConsoleControlsSocketAdapter();
        this.controlsSocket.addForwardedInput(new Console.ConsoleControlsInputAdapter());
        this.controlsSocket.addForwardedInput(this.tia);
        this.controlsSocket.addForwardedInput(this.pia);
        this.cartridgeSocket = new ServerConsoleCartridgeSocketAdapter();
        this.saveStateSocket = new ServerConsoleSaveStateSourceAdapter();
    }

    @Override
    protected synchronized void cartridge(Cartridge cartridge) {
        super.cartridge(cartridge);
        this.sendStateUpdate();
    }

    @Override
    protected synchronized void loadState(ConsoleState state) {
        super.loadState(state);
        this.sendStateUpdate();
    }

    @Override
    public synchronized void clockPulse() {
        List controlChanges = ((ServerConsoleControlsSocketAdapter)this.controlsSocket).commitAndGetChangesToSend();
        if (this.powerOn) {
            this.tia.clockPulse();
        }
        if (this.remoteTransmitter != null && this.remoteTransmitter.isClientConnected()) {
            ServerUpdate update = new ServerUpdate();
            update.controlChanges = controlChanges;
            update.isClockPulse = this.powerOn;
            this.remoteTransmitter.sendUpdate(update);
        }
    }

    @Override
    protected synchronized void powerFry() {
        super.powerFry();
        this.sendStateUpdate();
    }

    synchronized void clientConnected() {
        this.showOSD("Player 2 Client Connected", true);
        this.sendStateUpdate();
    }

    void clientDisconnected() {
        this.showOSD("Player 2 Client Disconnected", true);
    }

    void receiveClientControlChanges(List<ControlChange> clientControlChages) {
        for (ControlChange change : clientControlChages) {
            if (change instanceof ControlChangeForPaddle) {
                this.controlsSocket.controlStateChanged(change.control, ((ControlChangeForPaddle)change).position);
                continue;
            }
            this.controlsSocket.controlStateChanged(change.control, change.state);
        }
    }

    private void sendStateUpdate() {
        if (this.remoteTransmitter != null && this.remoteTransmitter.isClientConnected()) {
            ServerUpdate update = new ServerUpdate();
            update.powerOn = this.powerOn;
            update.consoleState = this.saveState();
            this.remoteTransmitter.sendUpdate(update);
        }
    }

    private void setupTransmitter(RemoteTransmitter transmitter) {
        this.remoteTransmitter = transmitter;
        this.remoteTransmitter.serverConsole(this);
    }

    private class ServerConsoleCartridgeSocketAdapter
    extends Console.CartridgeSocketAdapter {
        private ServerConsoleCartridgeSocketAdapter() {
        }
    }

    private class ServerConsoleControlsSocketAdapter
    extends ConsoleControlsSocket {
        private List<ControlChange> queuedChanges = new ArrayList<ControlChange>();

        private ServerConsoleControlsSocketAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void controlStateChanged(ConsoleControls.Control control, boolean state) {
            if (control == ConsoleControls.Control.FAST_SPEED || control == ConsoleControls.Control.POWER_FRY || control.isStateControl()) {
                super.controlStateChanged(control, state);
                return;
            }
            List<ControlChange> list = this.queuedChanges;
            synchronized (list) {
                this.queuedChanges.add(new ControlChange(control, state));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void controlStateChanged(ConsoleControls.Control control, int position) {
            List<ControlChange> list = this.queuedChanges;
            synchronized (list) {
                this.queuedChanges.add(new ControlChangeForPaddle(control, position));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<ControlChange> commitAndGetChangesToSend() {
            ArrayList<ControlChange> changesToSend;
            List<ControlChange> list = this.queuedChanges;
            synchronized (list) {
                block6: {
                    if (!this.queuedChanges.isEmpty()) break block6;
                    return null;
                }
                changesToSend = new ArrayList<ControlChange>(this.queuedChanges);
                this.queuedChanges.clear();
            }
            for (ControlChange change : changesToSend) {
                if (change instanceof ControlChangeForPaddle) {
                    super.controlStateChanged(change.control, ((ControlChangeForPaddle)change).position);
                    continue;
                }
                super.controlStateChanged(change.control, change.state);
            }
            return changesToSend;
        }
    }

    private class ServerConsoleSaveStateSourceAdapter
    extends Console.SaveStateSocketAdapter {
        private ServerConsoleSaveStateSourceAdapter() {
        }
    }
}

