/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#ifndef A8CAS_FILE_H
#define A8CAS_FILE_H

#include <stdio.h>

#include "a8cas.h"

struct A8CAS_FILE {
	A8CAS_open_mode mode;
	A8CAS_format format;
	 /* Pointer to description(s) read from the file (not used when
	    opening with modes A8CAS_WRITE and A8CAS_WRRD). */
	char *description;
	A8CAS_errnum errnum;
	struct {
		unsigned int samplerate;
		unsigned int bits;
	} audio;
	FILE *log_stream;
	int (*read_func)(A8CAS_FILE*, A8CAS_signal*);
	int (*write_bytes_func)(A8CAS_FILE*, unsigned char const *bytes, unsigned int size, unsigned int baudrate);
	int (*read_with_audio_func)(A8CAS_FILE*, A8CAS_signal*, unsigned int*);
	int (*write_func)(A8CAS_FILE*, A8CAS_signal const*);
	void *specific_data;
};

int A8CAS_log(A8CAS_FILE *file, const char *fmt, ...);

int A8CAS_fatal_error(A8CAS_FILE *file);

#endif /* A8CAS_FILE_H */

