/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#include "downsample.h"

void DOWNSAMPLE_init(DOWNSAMPLE_t *downsample, double in_rate, double out_rate)
{
	downsample->in_length = 1.0 / in_rate;
	downsample->out_length = 1.0 / out_rate;
	downsample->prev_sample = 0;
	downsample->counter = 0.0;
}

int DOWNSAMPLE_next(DOWNSAMPLE_t *downsample, short int *sample)
{
	int tmp_sample = *sample;
	downsample->counter += downsample->in_length;
	if (downsample->counter >= downsample->out_length) {
		downsample->counter -= downsample->out_length;
		*sample = tmp_sample - (tmp_sample - downsample->prev_sample) * (downsample->counter / downsample->in_length);
		downsample->prev_sample = tmp_sample;
		return 1;
	} else {
		downsample->prev_sample = tmp_sample;
		return 0;
	}
}
