/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
/* Dynamically allocated array that grows itself when new elements are added
   at the end */
#ifndef DYN_ARRAY_H
#define DYN_ARRAY_H

typedef struct DYN_ARRAY_t {
	unsigned int elm_size; /* Read-only */
	unsigned int size; /* Read-only */
	unsigned int fill; /* Read-only */
	char **buffer; /* Write to the buffer by DYN_ARRAY_at */
} DYN_ARRAY_t;

int DYN_ARRAY_init(DYN_ARRAY_t *array, unsigned int size, unsigned int elm_size, void **buffer);

void *DYN_ARRAY_at(DYN_ARRAY_t *array, unsigned int idx);

int DYN_ARRAY_add(DYN_ARRAY_t *array, void const *value);

int DYN_ARRAY_strip(DYN_ARRAY_t *array);

#endif /* DYN_ARRAY_H */

