/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#include <stdio.h>

#include "a8cas.h"
#include "format_stdio_based.h"

FILE *FORMAT_STDIO_BASED_open(char const *path, A8CAS_open_mode const mode)
{
	char *stdio_mode;
	switch (mode) {
	case A8CAS_READ:
		stdio_mode = "rb";
		break;
	case A8CAS_WRITE:
		stdio_mode = "wb";
		break;
	case A8CAS_RDWR:
		stdio_mode = "r+b";
		break;
	default: /* A8CAS_WRRD */
		stdio_mode = "w+b";
	}

	return fopen(path, stdio_mode);
}
