/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#include "pwm_demod.h"

void PWM_DEMOD_init(PWM_DEMOD_t *demod)
{
	demod->prev_sample = 0;
	demod->prev_up = 0;
	
}

int PWM_DEMOD_advance(PWM_DEMOD_t *demod, short int sample)
{
	if (demod->prev_up)
		demod->prev_up = (int)sample >= (int)demod->prev_sample - demod->tolerance;
	else
		demod->prev_up = (int)sample > (int)demod->prev_sample + demod->tolerance;
	demod->prev_sample = sample;
	return demod->prev_up;
}
