/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */

#ifndef PWM_MOD_H
#define PWM_MOD_H

typedef struct PWM_MOD_t PWM_MOD_t;

struct PWM_MOD_t {
	void (*gen_func)(PWM_MOD_t *mod, void *buffer, unsigned int num_samples, int signal);
	unsigned int num_channels;
	unsigned int write_channel;
	float volume;
};

void PWM_MOD_init(PWM_MOD_t *mod, unsigned int samplerate, unsigned int bits, unsigned int num_channels, unsigned int write_channel);

void PWM_MOD_set_volume(PWM_MOD_t *mod, float volume);

/* When num_channels > 1, BUFFER must be empty - this function writes only one
   channel of sound, leaving others untouched. */
void PWM_MOD_generate(PWM_MOD_t *mod, void *buffer, unsigned int num_samples, int signal);

#endif /* PWM_MOD_H */
