/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#include "upsample.h"

void UPSAMPLE_init(UPSAMPLE_t *upsample, float in_rate, float out_rate)
{
	upsample->in_length = 1.0f / in_rate;
	upsample->out_length = 1.0f / out_rate;
	upsample->prev_sample = upsample->next_sample = 0;
	upsample->counter = upsample->in_length;
	upsample->need_sample = 1;
}

int UPSAMPLE_next(UPSAMPLE_t *upsample, short int *sample)
{
	if (upsample->need_sample) {
		upsample->prev_sample = upsample->next_sample;
		upsample->next_sample = *sample;
		upsample->counter -= upsample->in_length;
	}
	*sample = upsample->prev_sample + (upsample->next_sample - upsample->prev_sample) * (upsample->counter / upsample->in_length);

	upsample->counter += upsample->out_length;
	upsample->need_sample = upsample->counter >= upsample->in_length;
	return upsample->need_sample;
}
