##############################################
## The following part is copied from sdl.m4 ##
##############################################

# Configure paths for SDL
# Sam Lantinga 9/21/99
# stolen from Manish Singh
# stolen back from Frank Belew
# stolen from Manish Singh
# Shamelessly stolen from Owen Taylor

dnl AM_PATH_SDL([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for SDL, and define SDL_CFLAGS and SDL_LIBS
dnl
AC_DEFUN([AM_PATH_SDL],
[dnl 
dnl Get the cflags and libraries from the sdl-config script
dnl
AC_ARG_WITH(sdl-prefix,[  --with-sdl-prefix=PFX   Prefix where SDL is installed (optional)],
            sdl_prefix="$withval", sdl_prefix="")
AC_ARG_WITH(sdl-exec-prefix,[  --with-sdl-exec-prefix=PFX Exec prefix where SDL is installed (optional)],
            sdl_exec_prefix="$withval", sdl_exec_prefix="")
AC_ARG_ENABLE(sdltest, [  --disable-sdltest       Do not try to compile and run a test SDL program],
		    , enable_sdltest=yes)

  if test x$sdl_exec_prefix != x ; then
    sdl_config_args="$sdl_config_args --exec-prefix=$sdl_exec_prefix"
    if test x${SDL_CONFIG+set} != xset ; then
      SDL_CONFIG=$sdl_exec_prefix/bin/sdl-config
    fi
  fi
  if test x$sdl_prefix != x ; then
    sdl_config_args="$sdl_config_args --prefix=$sdl_prefix"
    if test x${SDL_CONFIG+set} != xset ; then
      SDL_CONFIG=$sdl_prefix/bin/sdl-config
    fi
  fi

  as_save_PATH="$PATH"
  if test "x$prefix" != xNONE; then
    PATH="$prefix/bin:$prefix/usr/bin:$PATH"
  fi
  AC_PATH_PROG(SDL_CONFIG, sdl-config, no, [$PATH])
  PATH="$as_save_PATH"
  min_sdl_version=ifelse([$1], ,0.11.0,$1)
  AC_MSG_CHECKING(for SDL - version >= $min_sdl_version)
  no_sdl=""
  if test "$SDL_CONFIG" = "no" ; then
    no_sdl=yes
  else
    SDL_CFLAGS=`$SDL_CONFIG $sdl_config_args --cflags`
    SDL_LIBS=`$SDL_CONFIG $sdl_config_args --libs`

    sdl_major_version=`$SDL_CONFIG $sdl_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    sdl_minor_version=`$SDL_CONFIG $sdl_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    sdl_micro_version=`$SDL_CONFIG $sdl_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_sdltest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_CXXFLAGS="$CXXFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $SDL_CFLAGS"
      CXXFLAGS="$CXXFLAGS $SDL_CFLAGS"
      LIBS="$LIBS $SDL_LIBS"
dnl
dnl Now check if the installed SDL is sufficiently new. (Also sanity
dnl checks the results of sdl-config to some extent
dnl
      rm -f conf.sdltest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SDL.h"

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = (char *)malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main (int argc, char *argv[])
{
  int major, minor, micro;
  char *tmp_version;

  /* This hangs on some systems (?)
  system ("touch conf.sdltest");
  */
  { FILE *fp = fopen("conf.sdltest", "a"); if ( fp ) fclose(fp); }

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_sdl_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_sdl_version");
     exit(1);
   }

   if (($sdl_major_version > major) ||
      (($sdl_major_version == major) && ($sdl_minor_version > minor)) ||
      (($sdl_major_version == major) && ($sdl_minor_version == minor) && ($sdl_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'sdl-config --version' returned %d.%d.%d, but the minimum version\n", $sdl_major_version, $sdl_minor_version, $sdl_micro_version);
      printf("*** of SDL required is %d.%d.%d. If sdl-config is correct, then it is\n", major, minor, micro);
      printf("*** best to upgrade to the required version.\n");
      printf("*** If sdl-config was wrong, set the environment variable SDL_CONFIG\n");
      printf("*** to point to the correct copy of sdl-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

],, no_sdl=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       CXXFLAGS="$ac_save_CXXFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_sdl" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$SDL_CONFIG" = "no" ; then
       echo "*** The sdl-config script installed by SDL could not be found"
       echo "*** If SDL was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the SDL_CONFIG environment variable to the"
       echo "*** full path to sdl-config."
     else
       if test -f conf.sdltest ; then
        :
       else
          echo "*** Could not run SDL test program, checking why..."
          CFLAGS="$CFLAGS $SDL_CFLAGS"
          CXXFLAGS="$CXXFLAGS $SDL_CFLAGS"
          LIBS="$LIBS $SDL_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include "SDL.h"

int main(int argc, char *argv[])
{ return 0; }
#undef  main
#define main K_and_R_C_main
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding SDL or finding the wrong"
          echo "*** version of SDL. If it is not finding SDL, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means SDL was incorrectly installed"
          echo "*** or that you have moved SDL since it was installed. In the latter case, you"
          echo "*** may want to edit the sdl-config script: $SDL_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          CXXFLAGS="$ac_save_CXXFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     SDL_CFLAGS=""
     SDL_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(SDL_CFLAGS)
  AC_SUBST(SDL_LIBS)
  rm -f conf.sdltest
])

################################################
## The following part is copied from a8cas.m4 ##
################################################

# Configure paths for liba8cas
# Tomasz Krasuski <kr0tki@poczta.onet.pl> 2011-09-11
# Based on ogg.m4 and alsa.m4

dnl AM_PATH_A8CAS([MINIMUM-VERSION [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for libasound, and define A8CAS_CPPFLAGS, A8CAS_LDFLAGS and
dnl A8CAS_LIBS as appropriate.
dnl enables arguments --with-a8cas-libraries=
dnl                   --with-a8cas-includes=
dnl                   --disable-a8castest
AC_DEFUN([AM_PATH_A8CAS],
[dnl Save the original CPPFLAGS, LDFLAGS, LIBS and LD_LIBRARY_PATH
ac_save_CPPFLAGS="$CPPFLAGS"
ac_save_LDFLAGS="$LDFLAGS"
ac_save_LIBS="$LIBS"
ac_save_LD_LIBRARY_PATH="$LD_LIBRARY_PATH"
a8cas_found=yes

dnl
dnl Get the cflags and libraries
dnl
AC_ARG_WITH(a8cas-libraries,AC_HELP_STRING([--with-a8cas-libraries=DIR],[Directory where liba8cas library is installed (optional)]), a8cas_libraries="$withval", a8cas_libraries="")
AC_ARG_WITH(a8cas-includes,AC_HELP_STRING([--with-a8cas-includes=DIR],[Directory where liba8cas header files are installed (optional)]), a8cas_includes="$withval", a8cas_includes="")
AC_ARG_ENABLE(a8castest,AC_HELP_STRING([--disable-a8castest],[Do not try to compile and run a test A8CAS program]), enable_a8castest="$enableval", enable_a8castest=yes)

dnl Add any special lib dirs
AC_MSG_CHECKING(for A8CAS_LDFLAGS)
if test "x$a8cas_libraries" != "x" ; then
	A8CAS_LIBDIR="$a8cas_libraries"
elif test "x$prefix" != "xNONE"; then
	A8CAS_LIBDIR="$prefix/lib"
fi

if test "x$A8CAS_LIBDIR" != "x" ; then
	A8CAS_LDFLAGS="$A8CAS_LDFLAGS -L$A8CAS_LIBDIR"
fi
AC_MSG_RESULT($A8CAS_LDFLAGS)

AC_MSG_CHECKING(for A8CAS_LIBS)
A8CAS_LIBS="$A8CAS_LIBS -la8cas"
AC_MSG_RESULT($A8CAS_LIBS)

dnl Add any special include dirs
AC_MSG_CHECKING(for A8CAS_CPPFLAGS)
if test "x$a8cas_includes" != "x" ; then
	A8CAS_CPPFLAGS="-I$a8cas_includes"
elif test "x$prefix" != "xNONE"; then
	A8CAS_CPPFLAGS="-I$prefix/include"
fi
AC_MSG_RESULT($A8CAS_CPPFLAGS)

if test "x$enable_a8castest" = "xyes"; then
dnl add the a8cas library
	CPPFLAGS="$A8CAS_CPPFLAGS $CPPFLAGS"
	LDFLAGS="$A8CAS_LDFLAGS $LIBS"
	LIBS="$A8CAS_LIBS $LIBS"
	LD_LIBRARY_PATH="$A8CAS_LIBDIR:$LD_LIBRARY_PATH"
	export LD_LIBRARY_PATH

dnl Check for a working version of liba8cas that is of the right version.
	min_a8cas_version=ifelse([$1], ,0.1.0,$1)
	AC_MSG_CHECKING(for liba8cas headers version >= $min_a8cas_version)
	no_a8cas=""
	a8cas_min_major_version=`echo $min_a8cas_version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
	a8cas_min_minor_version=`echo $min_a8cas_version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
	a8cas_min_patch_version=`echo $min_a8cas_version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

	AC_LANG_SAVE
	AC_LANG_C
	AC_RUN_IFELSE([AC_LANG_PROGRAM([[
	#include <a8cas.h>
	]], [[
	return !((A8CAS_version >> 16) > $a8cas_min_major_version ||
	         ((A8CAS_version >> 16) == $a8cas_min_major_version &&
	          (A8CAS_version & 0xffff) >= $a8cas_min_minor_version));
	]])],
	[AC_MSG_RESULT(found.)],
	[AC_MSG_RESULT(not present.)
	ifelse([$3], , [AC_MSG_ERROR(Sufficiently new version of liba8cas not found.)])
	a8cas_found=no]
	)
	AC_LANG_RESTORE

	dnl Now that we know that we have the right version, let's see if we have the library and not just the headers.
	AC_CHECK_LIB([a8cas], [A8CAS_version],,
	[ifelse([$3], , [AC_MSG_ERROR(No linkable liba8cas was found.)])
	 a8cas_found=no]
	)

	CPPFLAGS="$ac_save_CPPFLAGS"
	LDFLAGS="$ac_save_LDFLAGS"
	LIBS="$ac_save_LIBS"
	LD_LIBRARY_PATH="$ac_save_LD_LIBRARY_PATH"
	export LD_LIBRARY_PATH
fi


if test "x$a8cas_found" = "xyes" ; then
	ifelse([$2], , :, [$2])
else
	A8CAS_CPPFLAGS=""
	A8CAS_LDFLAGS=""
	A8CAS_LIBS=""
	ifelse([$3], , :, [$3])
fi
AC_SUBST(A8CAS_CPPFLAGS)
AC_SUBST(A8CAS_LDFLAGS)
AC_SUBST(A8CAS_LIBS)
])
