# Configure paths for liba8cas
# Tomasz Krasuski <kr0tki@poczta.onet.pl> 2011-09-11
# Based on ogg.m4 and alsa.m4

dnl AM_PATH_A8CAS([MINIMUM-VERSION [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for liba8cas, and define A8CAS_CPPFLAGS, A8CAS_LDFLAGS and
dnl A8CAS_LIBS as appropriate.
dnl enables arguments --with-a8cas-libraries=
dnl                   --with-a8cas-includes=
dnl                   --disable-a8castest
AC_DEFUN([AM_PATH_A8CAS],
[dnl Save the original CPPFLAGS, LDFLAGS, LIBS and LD_LIBRARY_PATH
ac_save_CPPFLAGS="$CPPFLAGS"
ac_save_LDFLAGS="$LDFLAGS"
ac_save_LIBS="$LIBS"
ac_save_LD_LIBRARY_PATH="$LD_LIBRARY_PATH"
a8cas_found=yes

dnl
dnl Get the cflags and libraries
dnl
AC_ARG_WITH(a8cas-libraries,AC_HELP_STRING([--with-a8cas-libraries=DIR],[Directory where liba8cas library is installed (optional)]), a8cas_libraries="$withval", a8cas_libraries="")
AC_ARG_WITH(a8cas-includes,AC_HELP_STRING([--with-a8cas-includes=DIR],[Directory where liba8cas header files are installed (optional)]), a8cas_includes="$withval", a8cas_includes="")
AC_ARG_ENABLE(a8castest,AC_HELP_STRING([--disable-a8castest],[Do not try to compile and run a test A8CAS program]), enable_a8castest="$enableval", enable_a8castest=yes)

dnl Add any special lib dirs
AC_MSG_CHECKING(for A8CAS_LDFLAGS)
if test "x$a8cas_libraries" != "x" ; then
	A8CAS_LIBDIR="$a8cas_libraries"
elif test "x$prefix" != "xNONE"; then
	A8CAS_LIBDIR="$prefix/lib"
fi

if test "x$A8CAS_LIBDIR" != "x" ; then
	A8CAS_LDFLAGS="$A8CAS_LDFLAGS -L$A8CAS_LIBDIR"
fi
AC_MSG_RESULT($A8CAS_LDFLAGS)

AC_MSG_CHECKING(for A8CAS_LIBS)
A8CAS_LIBS="$A8CAS_LIBS -la8cas"
AC_MSG_RESULT($A8CAS_LIBS)

dnl Add any special include dirs
AC_MSG_CHECKING(for A8CAS_CPPFLAGS)
if test "x$a8cas_includes" != "x" ; then
	A8CAS_CPPFLAGS="-I$a8cas_includes"
elif test "x$prefix" != "xNONE"; then
	A8CAS_CPPFLAGS="-I$prefix/include"
fi
AC_MSG_RESULT($A8CAS_CPPFLAGS)

if test "x$enable_a8castest" = "xyes"; then
dnl add the a8cas library
	CPPFLAGS="$A8CAS_CPPFLAGS $CPPFLAGS"
	LDFLAGS="$A8CAS_LDFLAGS $LIBS"
	LIBS="$A8CAS_LIBS $LIBS"
	LD_LIBRARY_PATH="$A8CAS_LIBDIR:$LD_LIBRARY_PATH"
	export LD_LIBRARY_PATH

dnl Check for a working version of liba8cas that is of the right version.
	min_a8cas_version=ifelse([$1], ,0.1.0,$1)
	AC_MSG_CHECKING(for liba8cas headers version >= $min_a8cas_version)
	no_a8cas=""
	a8cas_min_major_version=`echo $min_a8cas_version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
	a8cas_min_minor_version=`echo $min_a8cas_version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
	a8cas_min_patch_version=`echo $min_a8cas_version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

	AC_LANG_SAVE
	AC_LANG_C
	AC_RUN_IFELSE([AC_LANG_PROGRAM([[
	#include <a8cas.h>
	]], [[
	return !((A8CAS_version >> 16) > $a8cas_min_major_version ||
	         ((A8CAS_version >> 16) == $a8cas_min_major_version &&
	          (A8CAS_version & 0xffff) >= $a8cas_min_minor_version));
	]])],
	[AC_MSG_RESULT(found.)],
	[AC_MSG_RESULT(not present.)
	ifelse([$3], , [AC_MSG_ERROR(Sufficiently new version of liba8cas not found.)])
	a8cas_found=no]
	)
	AC_LANG_RESTORE

	dnl Now that we know that we have the right version, let's see if we have the library and not just the headers.
	AC_CHECK_LIB([a8cas], [A8CAS_version],,
	[ifelse([$3], , [AC_MSG_ERROR(No linkable liba8cas was found.)])
	 a8cas_found=no]
	)

	CPPFLAGS="$ac_save_CPPFLAGS"
	LDFLAGS="$ac_save_LDFLAGS"
	LIBS="$ac_save_LIBS"
	LD_LIBRARY_PATH="$ac_save_LD_LIBRARY_PATH"
	export LD_LIBRARY_PATH
fi


if test "x$a8cas_found" = "xyes" ; then
	ifelse([$2], , :, [$2])
else
	A8CAS_CPPFLAGS=""
	A8CAS_LDFLAGS=""
	A8CAS_LIBS=""
	ifelse([$3], , :, [$3])
fi
AC_SUBST(A8CAS_CPPFLAGS)
AC_SUBST(A8CAS_LDFLAGS)
AC_SUBST(A8CAS_LIBS)
])
