/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#ifndef CAS_DECODE_H
#define CAS_DECODE_H

#include <inttypes.h>

#include "a8cas.h"
#include "cas_header.h"

typedef struct CAS_DECODE_t CAS_DECODE_t;

struct CAS_DECODE_t {
	/* The values below should be set by user */
	A8CAS_FILE *file;
	/* Function should set the header's type and aux fields. Length will be ignored. */
	int (*read_header_func)(A8CAS_FILE*, CAS_HEADER_t*);
	int (*read_fsk_signal_func)(A8CAS_FILE*, uint16_t*);
	int (*read_data_byte_func)(A8CAS_FILE*, uint8_t*);
	int (*read_pwms_block_func)(A8CAS_FILE*, uint16_t*);
	int (*read_pwmd_byte_func)(A8CAS_FILE*, uint8_t*);
	int (*read_pwmc_signal_func)(A8CAS_FILE*, uint8_t*, uint16_t*);
	int (*read_pwml_signal_func)(A8CAS_FILE*, uint16_t*);
	int (*read_description_func)(A8CAS_FILE*);

	/* Internal variables */
	uint16_t bit_mask;
	uint16_t current_10bit;
	uint16_t baudrate;

	A8CAS_signal last_irg_signal;

	int (*read_func)(CAS_DECODE_t*, A8CAS_signal*);

	struct {
		unsigned int rate;	/* in most cases samplerate of sampled turbo recording */
		unsigned int length_0;	/* width of bit 0 in "samples" */
		unsigned int length_1;	/* width of bit 1 in "samples" */
		int rising_edge_first;	/* first edge of impulse is rising (1) or not (0) */
		int lsb_first; 		/* bit order is little endian (1) or not (0) */
		uint16_t counter;	/* number of impulses in group (pwmc) */
	} pwm_params;

};

void CAS_DECODE_reset(CAS_DECODE_t *decode, uint16_t baudrate,
		      uint16_t pwm_rate, int pwm_lsb_first, int pwm_rising_edge_first);

int CAS_DECODE_read(CAS_DECODE_t *decode, A8CAS_signal *sig);

unsigned int CAS_DECODE_read_bytes(CAS_DECODE_t *decode, unsigned char *bytes, unsigned int size, unsigned int *baudrate);
unsigned int CAS_DECODE_read_signals(CAS_DECODE_t *decode, A8CAS_signal *sigs, unsigned int size);

#endif /* CAS_DECODE */
