/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#ifndef CAS_HEADER_H
#define CAS_HEADER_H

#include <inttypes.h>

#include "endianness.h"

enum {
	BLOCK_TYPE_FUJI = MAKE_MARKER ('F', 'U', 'J', 'I'),
	BLOCK_TYPE_DATA = MAKE_MARKER ('d', 'a', 't', 'a'),
	BLOCK_TYPE_FSK = MAKE_MARKER ('f', 's', 'k', ' '),
	BLOCK_TYPE_BAUD = MAKE_MARKER ('b', 'a', 'u', 'd'),
	BLOCK_TYPE_PWMS = MAKE_MARKER ('p', 'w', 'm', 's'),
	BLOCK_TYPE_PWMC = MAKE_MARKER ('p', 'w', 'm', 'c'),
	BLOCK_TYPE_PWMD = MAKE_MARKER ('p', 'w', 'm', 'd'),
	BLOCK_TYPE_PWML = MAKE_MARKER ('p', 'w', 'm', 'l')
};

typedef struct CAS_HEADER_t {
	uint32_t type;
	uint16_t length;
	uint16_t aux;
} CAS_HEADER_t;

#endif /* CAS_HEADER_H */
