/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#ifndef DOWNSAMPLE_H
#define DOWNSAMPLE_H

typedef struct DOWNSAMPLE_t {
	double in_length;
	double out_length;
	short int prev_sample;
	double counter;
} DOWNSAMPLE_t;

void DOWNSAMPLE_init(DOWNSAMPLE_t *downsample, double in_rate, double out_rate);

/* Reads a next sample from *SAMPLE. If enough samples have been provided to
   generate a single downsampled sample, that downsampled sample is written
   back to *SAMPLE, and 1 is returned. Otherwise, the function returns 0. */
int DOWNSAMPLE_next(DOWNSAMPLE_t *downsample, short int *sample);

#endif /* DOWNSAMPLE_H */
