/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#include <stdlib.h>
#include <string.h>

#include "dyn_array.h"

int DYN_ARRAY_init(DYN_ARRAY_t *array, unsigned int size, unsigned int elm_size, void **buffer)
{
	array->buffer = (char **)buffer;
	if ((*buffer = malloc(elm_size * size)) == NULL)
		return 1;
	array->elm_size = elm_size;
	array->size = size;
	array->fill = 0;
	return 0;
}

void *DYN_ARRAY_at(DYN_ARRAY_t *array, unsigned int idx)
{
	return &(*array->buffer[idx * array->elm_size]);
}

int DYN_ARRAY_add(DYN_ARRAY_t *array, void const *value)
{
	if (array->fill == array->size) {
		array->size *= 2;
		if (array->size == 0)
			array->size = 1;
		if ((*array->buffer = realloc(*array->buffer, array->elm_size * array->size)) == NULL)
			return 1;
	}
	memcpy(&((*array->buffer)[array->fill++ * array->elm_size]), value, array->elm_size);
	return 0;
}

int DYN_ARRAY_strip(DYN_ARRAY_t *array) {
	if (array->size == array->fill) /* No need to strip */
		return 0;
	if ((*array->buffer = realloc(*array->buffer, array->elm_size * array->fill)) == NULL)
		return 1;
	array->size = array->fill;
	return 0;
}
