/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#ifndef ENDIANNESS_H
#define ENDIANNESS_H

#include "config.h"

#define ENDSWAP_INT(x) ((int) bswap_32 (x))
#define ENDSWAP_SHORT(x) ((short) bswap_16 (x))
#if WORDS_BIGENDIAN
#define MAKE_MARKER(a,b,c,d) (((a) << 24) | ((b) << 16) | ((c) << 8) | (d))
#define LE_INT(x) ENDSWAP_INT(x)
#define LE_SHORT(x) ENDSWAP_SHORT(x)
#else
#define MAKE_MARKER(a,b,c,d) ((a) | ((b) << 8) | ((c) << 16) | ((d) << 24))
#define LE_INT(x) (x)
#define LE_SHORT(x) (x)
#endif

#endif /* ENDIANNESS_H */

