/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#ifndef FORMAT_HEX_H
#define FORMAT_HEX_H

#include "a8cas.h"

int FORMAT_HEX_open(A8CAS_FILE *file, char const *path, A8CAS_info *info);

int FORMAT_HEX_close(A8CAS_FILE *file);

int FORMAT_HEX_flush(A8CAS_FILE *file);

unsigned long FORMAT_HEX_tell(A8CAS_FILE *file);
unsigned long FORMAT_HEX_size(A8CAS_FILE *file);
int FORMAT_HEX_seek(A8CAS_FILE *file, unsigned long position);
enum { FORMAT_HEX_SEEK_UNIT = A8CAS_SEEK_UNIT_BLOCKS };

void FORMAT_HEX_set_audio(A8CAS_FILE *file);
int FORMAT_HEX_read_audio(A8CAS_FILE *file, void *samples, unsigned int num_samples);
int FORMAT_HEX_write_audio(A8CAS_FILE *file, A8CAS_signal const *sig, void *samples);

unsigned int FORMAT_HEX_read_bytes(A8CAS_FILE *file, unsigned char *bytes, unsigned int size, unsigned int *baudrate);
unsigned int FORMAT_HEX_read_signals(A8CAS_FILE *file, A8CAS_signal *sigs, unsigned int size);

int FORMAT_HEX_set_param(A8CAS_FILE *file, A8CAS_param type, void const *value);
int FORMAT_HEX_get_param(A8CAS_FILE *file, A8CAS_param type, void *value);

#endif /* FORMAT_HEX_H */