/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#ifndef PWM_DEMOD_H
#define PWM_DEMOD_H

typedef struct PWM_DEMOD_t {
	short int prev_sample;
	short int tolerance;
	int prev_up;
} PWM_DEMOD_t;

enum { PWM_DEMOD_DEFAULT_TOLERANCE = 200 };
void PWM_DEMOD_init(PWM_DEMOD_t *demod);

int PWM_DEMOD_advance(PWM_DEMOD_t *demod, short int sample);

#endif /* PWM_DEMOD_H */
