/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
/* Support for reading audio tracks in non-audio formats (that is, excluding
   WAV/OGG/other sndfile formats). */
#ifndef READ_AUDIO_H
#define READ_AUDIO_H

#include "a8cas.h"
#include "fsk_mod.h"
#include "pwm_mod.h"

typedef enum {
	MOD_TYPE_FSK,
	MOD_TYPE_PWM
} mod_type_t;

typedef struct READ_AUDIO_t {
	A8CAS_FILE *file;
	struct {
		FSK_MOD_t fsk;
		PWM_MOD_t pwm;
	} mod;
	mod_type_t mod_type;
	unsigned int samplerate;
	double pending_samples;
	char pending_signal;
	float crosstalk_volume;
} READ_AUDIO_t;

void READ_AUDIO_init(READ_AUDIO_t *read_audio, A8CAS_FILE *file);

void READ_AUDIO_reconfigure(READ_AUDIO_t *read_audio, unsigned int samplerate, unsigned int bits);

void READ_AUDIO_reset(READ_AUDIO_t *read_audio);

int READ_AUDIO_read_with_audio(READ_AUDIO_t *read_audio, A8CAS_signal *sig, unsigned int *num_samples);

void READ_AUDIO_read_audio(READ_AUDIO_t *read_audio, void *samples, unsigned int num_samples);

int READ_AUDIO_set_crosstalk_volume(READ_AUDIO_t *read_audio, float value);
#endif /* READ_AUDIO_H */
