/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#include "resample.h"
#include "downsample.h"
#include "upsample.h"

static int next_down(RESAMPLE_t *resample, short int *sample)
{
	return DOWNSAMPLE_next(&resample->dir.down, sample);
}

static int next_up(RESAMPLE_t *resample, short int *sample)
{
	resample->need = UPSAMPLE_next(&resample->dir.up, sample);
	return 1;
}

void RESAMPLE_init(RESAMPLE_t *resample, float in_rate, float out_rate)
{
	resample->need = 1;
	if (in_rate > out_rate) { /* Downsample */
		DOWNSAMPLE_init(&resample->dir.down, in_rate, out_rate);
		resample->next_func = &next_down;
	} else { /* Upsample */
		UPSAMPLE_init(&resample->dir.up, in_rate, out_rate);
		resample->next_func = &next_up;
	}
}

int RESAMPLE_next(RESAMPLE_t *resample, short int *sample)
{
	return (*resample->next_func)(resample, sample);
}