/*
 * Copyright (c) 2010-2013 A8CAS developers (see AUTHORS)
 *
 * This file is part of the A8CAS project which allows to manipulate tape
 * images for Atari 8-bit computers.
 *
 * A8CAS is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * A8CAS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with A8CAS; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#ifndef UPSAMPLE_H
#define UPSAMPLE_H

typedef struct UPSAMPLE_t {
	double in_length;
	double out_length;
	short int prev_sample;
	short int next_sample;
	double counter;
	/* Theoretically this field is not needed, but is used to avoid "excess precision" in FP. */
	int need_sample;
} UPSAMPLE_t;

void UPSAMPLE_init(UPSAMPLE_t *upsample, float in_rate, float out_rate);

/* Reads a next sample from *SAMPLE. Upsampled output is written back to
   *SAMPLE. If the function returns 0, then it means the user should NOT
   provide a new input sample on next call - it's because number of output
   samples is larger than input samples.
   The user should repeatedly call this function and read output samples until
   the function returns 1 - thus signalling that a new input sample is needed.
 */
int UPSAMPLE_next(UPSAMPLE_t *upsample, short int *sample);

#endif /* UPSAMPLE_H */
