/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.CartridgeBanked;

public final class Cartridge64K_F0
extends CartridgeBanked {
    private static final int SIZE = 65536;
    private static final int BANK_SIZE = 4096;
    private static final int BANKSW_ADDRESS = 4080;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("F0", "64K Dynacom Megaboy"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge64K_F0(rom, null);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length != 65536) {
                return null;
            }
            return new CartridgeFormatOption(101, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge64K_F0(ROM rom) {
        super(rom, FORMAT);
    }

    @Override
    protected void performBankSwitchOnMaskedAddress() {
        if (this.maskedAddress == 4080) {
            this.bankAddressOffset += 4096;
            if (this.bankAddressOffset >= 65536) {
                this.bankAddressOffset = 0;
            }
        }
    }

    /* synthetic */ Cartridge64K_F0(ROM rOM, Cartridge64K_F0 cartridge64K_F0) {
        this(rOM);
    }
}

