/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.general.m6502.instructions;

import org.javatari.general.m6502.Instruction;
import org.javatari.general.m6502.M6502;

public final class uSAX
extends Instruction {
    private final int type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public uSAX(M6502 cpu, int type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        if (this.type == 20) {
            this.ea = this.cpu.fetchZeroPageAddress();
            return 3;
        }
        if (this.type == 22) {
            this.ea = this.cpu.fetchZeroPageXAddress();
            return 4;
        }
        if (this.type == 31) {
            this.ea = this.cpu.fetchZeroPageXAddress();
            return 6;
        }
        if (this.type == 10) {
            this.ea = this.cpu.fetchAbsoluteAddress();
            return 4;
        }
        throw new IllegalStateException("uAAX Invalid Operand Type: " + this.type);
    }

    @Override
    public void execute() {
        byte val = (byte)(this.cpu.A & this.cpu.X);
        this.cpu.bus.writeByte(this.ea, val);
    }
}

