/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;

public final class Cartridge2K_CV
extends Cartridge {
    private byte[] extraRAM = new byte[1024];
    private static final int SIZE = 2048;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("CV", "2K Commavid +RAM"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge2K_CV(rom, null);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length != 2048 && rom.content.length != 4096) {
                return null;
            }
            return new CartridgeFormatOption(102, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge2K_CV(ROM rom) {
        super(rom, FORMAT);
        this.bytes = new byte[4096];
        int len = rom.content.length;
        int pos = 0;
        while (pos < this.bytes.length) {
            System.arraycopy(rom.content, 0, this.bytes, pos, len);
            pos += len;
        }
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        if (this.maskedAddress < 1024) {
            return this.extraRAM[this.maskedAddress];
        }
        return this.bytes[this.maskedAddress];
    }

    @Override
    public void writeByte(int address, byte b) {
        this.maskAddress(address);
        if (this.maskedAddress >= 1024 && this.maskedAddress <= 2047) {
            this.extraRAM[this.maskedAddress - 1024] = b;
        }
    }

    @Override
    public Cartridge2K_CV clone() {
        Cartridge2K_CV clone = (Cartridge2K_CV)super.clone();
        clone.extraRAM = (byte[])this.extraRAM.clone();
        return clone;
    }

    /* synthetic */ Cartridge2K_CV(ROM rOM, Cartridge2K_CV cartridge2K_CV) {
        this(rOM);
    }
}

