/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;

public final class Cartridge4K
extends Cartridge {
    private static final int MIN_SIZE = 8;
    private static final int MAX_SIZE = 4096;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("4K", "4K Atari"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge4K(rom, null);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length < 8 || rom.content.length > 4096 || 4096 % rom.content.length != 0) {
                return null;
            }
            return new CartridgeFormatOption(101, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge4K(ROM rom) {
        super(rom, FORMAT);
        this.bytes = new byte[4096];
        int len = rom.content.length;
        int pos = 0;
        while (pos < this.bytes.length) {
            System.arraycopy(rom.content, 0, this.bytes, pos, len);
            pos += len;
        }
    }

    /* synthetic */ Cartridge4K(ROM rOM, Cartridge4K cartridge4K) {
        this(rOM);
    }
}

