#ifndef __BYTEBUFFER_H__
#define __BYTEBUFFER_H__

#include "SmartPointer.h"

class ByteBuffer
{
private:
	unsigned char *Buffer;
	int Size;

	void Construct(const unsigned char *buffer, int size);

public:
	ByteBuffer(void);
	ByteBuffer(SP<class StringStream> str);
	ByteBuffer(const unsigned char *buffer, int size);
	~ByteBuffer(void);

	unsigned char *GetBuffer(void);
	int GetSize(void);
	unsigned char GetByte(int index);
	void SetByte(unsigned char byte, int index);
	void Put(unsigned char *target);
};

#endif
